/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.core.har;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import net.lightbody.bmp.core.har.HarCache;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.core.har.HarTimings;
import net.lightbody.bmp.core.json.ISO8601WithTDZDateFormatter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect
public class HarEntry {
    private volatile String pageref;
    private volatile Date startedDateTime;
    private volatile HarRequest request;
    private volatile HarResponse response;
    private volatile HarCache cache = new HarCache();
    private volatile HarTimings timings = new HarTimings();
    private volatile String serverIPAddress;
    private volatile String connection;
    private volatile String comment = "";

    public HarEntry() {
    }

    public HarEntry(String pageref) {
        this.pageref = pageref;
    }

    public String getPageref() {
        return this.pageref;
    }

    public void setPageref(String pageref) {
        this.pageref = pageref;
    }

    @JsonSerialize(using=ISO8601WithTDZDateFormatter.class)
    public Date getStartedDateTime() {
        return this.startedDateTime;
    }

    public void setStartedDateTime(Date startedDateTime) {
        this.startedDateTime = startedDateTime;
    }

    public long getTime() {
        HarTimings timings = this.getTimings();
        if (timings != null) {
            int time = 0;
            if (timings.getBlocked() != null && timings.getBlocked() > 0L) {
                time = (int)((long)time + timings.getBlocked());
            }
            if (timings.getDns() != null && timings.getDns() > 0L) {
                time = (int)((long)time + timings.getDns());
            }
            if (timings.getConnect() != null && timings.getConnect() > 0L) {
                time = (int)((long)time + timings.getConnect());
            }
            if (timings.getSend() > 0L) {
                time = (int)((long)time + timings.getSend());
            }
            if (timings.getWait() > 0L) {
                time = (int)((long)time + timings.getWait());
            }
            if (timings.getReceive() > 0L) {
                time = (int)((long)time + timings.getReceive());
            }
            return time;
        }
        return -1L;
    }

    public HarRequest getRequest() {
        return this.request;
    }

    public void setRequest(HarRequest request) {
        this.request = request;
    }

    public HarResponse getResponse() {
        return this.response;
    }

    public void setResponse(HarResponse response) {
        this.response = response;
    }

    public HarCache getCache() {
        return this.cache;
    }

    public void setCache(HarCache cache) {
        this.cache = cache;
    }

    public HarTimings getTimings() {
        return this.timings;
    }

    public void setTimings(HarTimings timings) {
        this.timings = timings;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public void setServerIPAddress(String serverIPAddress) {
        this.serverIPAddress = serverIPAddress;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }
}

