/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.impl.ProxyUtils;

public class HttpsAwareFiltersAdapter
extends HttpFiltersAdapter {
    public static final String IS_HTTPS_ATTRIBUTE_NAME = "isHttps";
    public static final String HOST_ATTRIBUTE_NAME = "host";
    public static final String ORIGINAL_HOST_ATTRIBUTE_NAME = "originalHost";

    public HttpsAwareFiltersAdapter(HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
    }

    public boolean isHttps() {
        Attribute isHttpsAttr = this.ctx.attr(AttributeKey.valueOf((String)IS_HTTPS_ATTRIBUTE_NAME));
        Boolean isHttps = (Boolean)isHttpsAttr.get();
        if (isHttps == null) {
            return false;
        }
        return isHttps;
    }

    public String getHttpsRequestHostAndPort() throws IllegalStateException {
        if (!this.isHttps()) {
            throw new IllegalStateException("Request is not HTTPS. Cannot get host and port on non-HTTPS request using this method.");
        }
        Attribute hostnameAttr = this.ctx.attr(AttributeKey.valueOf((String)HOST_ATTRIBUTE_NAME));
        return (String)hostnameAttr.get();
    }

    public String getHttpsOriginalRequestHostAndPort() throws IllegalStateException {
        if (!this.isHttps()) {
            throw new IllegalStateException("Request is not HTTPS. Cannot get original host and port on non-HTTPS request using this method.");
        }
        Attribute hostnameAttr = this.ctx.attr(AttributeKey.valueOf((String)ORIGINAL_HOST_ATTRIBUTE_NAME));
        return (String)hostnameAttr.get();
    }

    public String getFullUrl(HttpRequest modifiedRequest) {
        String url;
        if (ProxyUtils.isCONNECT((HttpObject)modifiedRequest)) {
            return "https://" + modifiedRequest.getUri();
        }
        if (this.isHttps()) {
            String hostAndPort = this.getHttpsRequestHostAndPort();
            String path = BrowserMobHttpUtil.getPathFromRequest((HttpRequest)modifiedRequest);
            url = "https://" + hostAndPort + path;
        } else {
            String hostAndPort = BrowserMobHttpUtil.getHostAndPortFromRequest((HttpRequest)modifiedRequest);
            String path = BrowserMobHttpUtil.getPathFromRequest((HttpRequest)modifiedRequest);
            url = "http://" + hostAndPort + path;
        }
        return url;
    }

    public String getOriginalUrl() {
        return this.getFullUrl(this.originalRequest);
    }

    public String getHostAndPort(HttpRequest modifiedRequest) {
        String serverHost;
        if (this.isHttps()) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)this.getHttpsRequestHostAndPort());
            serverHost = hostAndPort.getHostText();
        } else {
            serverHost = BrowserMobHttpUtil.getHostFromRequest((HttpRequest)modifiedRequest);
        }
        return serverHost;
    }
}

