/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.littleshoot.proxy.HttpFiltersAdapter;

public class ClientRequestCaptureFilter
extends HttpFiltersAdapter {
    private volatile HttpRequest httpRequest;
    private final ByteArrayOutputStream requestContents = new ByteArrayOutputStream();
    private volatile HttpHeaders trailingHeaders;

    public ClientRequestCaptureFilter(HttpRequest originalRequest) {
        super(originalRequest);
    }

    public ClientRequestCaptureFilter(HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            this.httpRequest = (HttpRequest)httpObject;
        }
        if (httpObject instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)httpObject;
            this.storeRequestContent(httpContent);
            if (httpContent instanceof LastHttpContent) {
                LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
                this.trailingHeaders = lastHttpContent.trailingHeaders();
            }
        }
        return null;
    }

    protected void storeRequestContent(HttpContent httpContent) {
        ByteBuf bufferedContent = httpContent.content();
        byte[] content = BrowserMobHttpUtil.extractReadableBytes((ByteBuf)bufferedContent);
        try {
            this.requestContents.write(content);
        }
        catch (IOException iOException) {}
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public byte[] getFullRequestContents() {
        return this.requestContents.toByteArray();
    }

    public HttpHeaders getTrailingHeaders() {
        return this.trailingHeaders;
    }
}

