/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.filters.ModifiedRequestAwareFilter;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.HttpFiltersSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobHttpFilterChain
extends HttpFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobHttpFilterChain.class);
    private final BrowserMobProxyServer proxyServer;
    private final List<HttpFilters> filters;

    public BrowserMobHttpFilterChain(BrowserMobProxyServer proxyServer, HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
        this.proxyServer = proxyServer;
        if (proxyServer.getFilterFactories() != null) {
            this.filters = new ArrayList<HttpFilters>(proxyServer.getFilterFactories().size());
            for (HttpFiltersSource filterFactory : proxyServer.getFilterFactories()) {
                HttpFilters filter = filterFactory.filterRequest(originalRequest, ctx);
                if (filter == null) continue;
                this.filters.add(filter);
            }
        } else {
            this.filters = Collections.emptyList();
        }
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (this.proxyServer.isStopped()) {
            log.warn("Aborting request to {} because proxy is stopped", (Object)this.originalRequest.getUri());
            DefaultFullHttpResponse abortedResponse = new DefaultFullHttpResponse(this.originalRequest.getProtocolVersion(), HttpResponseStatus.SERVICE_UNAVAILABLE);
            HttpHeaders.setContentLength((HttpMessage)abortedResponse, (long)0L);
            return abortedResponse;
        }
        for (HttpFilters filter : this.filters) {
            try {
                HttpResponse filterResponse = filter.clientToProxyRequest(httpObject);
                if (filterResponse == null) continue;
                if (httpObject instanceof HttpRequest) {
                    this.updateFiltersWithModifiedResponse((HttpRequest)httpObject);
                }
                return filterResponse;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        if (httpObject instanceof HttpRequest) {
            this.updateFiltersWithModifiedResponse((HttpRequest)httpObject);
        }
        return null;
    }

    public HttpResponse proxyToServerRequest(HttpObject httpObject) {
        for (HttpFilters filter : this.filters) {
            try {
                HttpResponse filterResponse = filter.proxyToServerRequest(httpObject);
                if (filterResponse == null) continue;
                return filterResponse;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return null;
    }

    public void proxyToServerRequestSending() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerRequestSending();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        HttpObject processedHttpObject = httpObject;
        for (HttpFilters filter : this.filters) {
            try {
                processedHttpObject = filter.serverToProxyResponse(processedHttpObject);
                if (processedHttpObject != null) continue;
                return null;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return processedHttpObject;
    }

    public void serverToProxyResponseTimedOut() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.serverToProxyResponseTimedOut();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void serverToProxyResponseReceiving() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.serverToProxyResponseReceiving();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public InetSocketAddress proxyToServerResolutionStarted(String resolvingServerHostAndPort) {
        InetSocketAddress overrideAddress = null;
        String newServerHostAndPort = resolvingServerHostAndPort;
        for (HttpFilters filter : this.filters) {
            try {
                InetSocketAddress filterResult = filter.proxyToServerResolutionStarted(newServerHostAndPort);
                if (filterResult == null) continue;
                overrideAddress = filterResult;
                newServerHostAndPort = String.valueOf(filterResult.getHostString()) + ":" + filterResult.getPort();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return overrideAddress;
    }

    public void proxyToServerResolutionFailed(String hostAndPort) {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerResolutionFailed(hostAndPort);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerResolutionSucceeded(serverHostAndPort, resolvedRemoteAddress);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        super.proxyToServerResolutionSucceeded(serverHostAndPort, resolvedRemoteAddress);
    }

    public void proxyToServerConnectionStarted() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerConnectionStarted();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void proxyToServerConnectionSSLHandshakeStarted() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerConnectionSSLHandshakeStarted();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void proxyToServerConnectionFailed() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerConnectionFailed();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void proxyToServerConnectionSucceeded(ChannelHandlerContext serverCtx) {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerConnectionSucceeded(serverCtx);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void proxyToServerRequestSent() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerRequestSent();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public void serverToProxyResponseReceived() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.serverToProxyResponseReceived();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    public HttpObject proxyToClientResponse(HttpObject httpObject) {
        HttpObject processedHttpObject = httpObject;
        for (HttpFilters filter : this.filters) {
            try {
                processedHttpObject = filter.proxyToClientResponse(processedHttpObject);
                if (processedHttpObject != null) continue;
                return null;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return processedHttpObject;
    }

    public void proxyToServerConnectionQueued() {
        for (HttpFilters filter : this.filters) {
            try {
                filter.proxyToServerConnectionQueued();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
    }

    private void updateFiltersWithModifiedResponse(HttpRequest modifiedRequest) {
        for (HttpFilters filter : this.filters) {
            if (!(filter instanceof ModifiedRequestAwareFilter)) continue;
            ModifiedRequestAwareFilter requestCaptureFilter = (ModifiedRequestAwareFilter)filter;
            try {
                requestCaptureFilter.setModifiedHttpRequest(modifiedRequest);
            }
            catch (RuntimeException e) {
                log.warn("ModifiedRequestAwareFilter in filter chain threw exception while setting modified HTTP request.", (Throwable)e);
            }
        }
    }
}

