/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.jna.mac;

import com.sun.jna.Library;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import net.lecousin.framework.system.unix.jna.JnaInstances;
import net.lecousin.framework.system.unix.jna.mac.CoreFoundation;

public interface IOKit
extends Library {
    public void IOObjectRelease(int var1);

    public int IOMasterPort(int var1, IntByReference var2);

    public int IOIteratorNext(int var1);

    public CoreFoundation.CFMutableDictionaryRef IOServiceMatching(String var1);

    public int IOServiceGetMatchingService(int var1, CoreFoundation.CFMutableDictionaryRef var2);

    public int IOServiceGetMatchingServices(int var1, CoreFoundation.CFMutableDictionaryRef var2, IntByReference var3);

    public CoreFoundation.CFTypeRef IORegistryEntryCreateCFProperty(int var1, CoreFoundation.CFStringRef var2, CoreFoundation.CFAllocatorRef var3, int var4);

    public static class Util {
        private static MachPort masterPort = new MachPort();

        public static int getMatchingService(String serviceName) {
            if (Util.setMasterPort() == 0) {
                int service = JnaInstances.ioKit.IOServiceGetMatchingService(masterPort.getValue(), JnaInstances.ioKit.IOServiceMatching(serviceName));
                return service;
            }
            return 0;
        }

        public static int getMatchingServices(String serviceName, IntByReference serviceIterator) {
            int setMasterPort = Util.setMasterPort();
            if (setMasterPort == 0) {
                return JnaInstances.ioKit.IOServiceGetMatchingServices(masterPort.getValue(), JnaInstances.ioKit.IOServiceMatching(serviceName), serviceIterator);
            }
            return setMasterPort;
        }

        public static int getMatchingServices(CoreFoundation.CFMutableDictionaryRef matchingDictionary, IntByReference serviceIterator) {
            int setMasterPort = Util.setMasterPort();
            if (setMasterPort == 0) {
                return JnaInstances.ioKit.IOServiceGetMatchingServices(masterPort.getValue(), matchingDictionary, serviceIterator);
            }
            return setMasterPort;
        }

        public static String getIORegistryStringProperty(int entry, String key) {
            String value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.toCFString(key);
            CoreFoundation.CFTypeRef valueAsCFString = JnaInstances.ioKit.IORegistryEntryCreateCFProperty(entry, keyAsCFString, JnaInstances.coreFoundation.CFAllocatorGetDefault(), 0);
            if (valueAsCFString != null && valueAsCFString.getPointer() != null) {
                value = CoreFoundation.Util.cfPointerToString(valueAsCFString.getPointer());
            }
            JnaInstances.coreFoundation.CFRelease(valueAsCFString);
            return value;
        }

        public static long getIORegistryLongProperty(int entry, String key) {
            long value = 0L;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.toCFString(key);
            CoreFoundation.CFTypeRef valueAsCFNumber = JnaInstances.ioKit.IORegistryEntryCreateCFProperty(entry, keyAsCFString, JnaInstances.coreFoundation.CFAllocatorGetDefault(), 0);
            if (valueAsCFNumber != null && valueAsCFNumber.getPointer() != null) {
                value = CoreFoundation.Util.cfPointerToLong(valueAsCFNumber.getPointer());
            }
            JnaInstances.coreFoundation.CFRelease(valueAsCFNumber);
            return value;
        }

        public static int getIORegistryIntProperty(int entry, String key) {
            int value = 0;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.toCFString(key);
            CoreFoundation.CFTypeRef valueAsCFNumber = JnaInstances.ioKit.IORegistryEntryCreateCFProperty(entry, keyAsCFString, JnaInstances.coreFoundation.CFAllocatorGetDefault(), 0);
            if (valueAsCFNumber != null && valueAsCFNumber.getPointer() != null) {
                value = CoreFoundation.Util.cfPointerToInt(valueAsCFNumber.getPointer());
            }
            JnaInstances.coreFoundation.CFRelease(valueAsCFNumber);
            return value;
        }

        public static boolean getIORegistryBooleanProperty(int entry, String key) {
            boolean value = false;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.toCFString(key);
            CoreFoundation.CFTypeRef valueAsCFBoolean = JnaInstances.ioKit.IORegistryEntryCreateCFProperty(entry, keyAsCFString, JnaInstances.coreFoundation.CFAllocatorGetDefault(), 0);
            if (valueAsCFBoolean != null && valueAsCFBoolean.getPointer() != null) {
                value = CoreFoundation.Util.cfPointerToBoolean(valueAsCFBoolean.getPointer());
            }
            JnaInstances.coreFoundation.CFRelease(valueAsCFBoolean);
            return value;
        }

        public static byte[] getIORegistryByteArrayProperty(int entry, String key) {
            byte[] value = null;
            CoreFoundation.CFStringRef keyAsCFString = CoreFoundation.CFStringRef.toCFString(key);
            CoreFoundation.CFTypeRef valueAsCFData = JnaInstances.ioKit.IORegistryEntryCreateCFProperty(entry, keyAsCFString, JnaInstances.coreFoundation.CFAllocatorGetDefault(), 0);
            if (valueAsCFData != null && valueAsCFData.getPointer() != null) {
                int length = JnaInstances.coreFoundation.CFDataGetLength(valueAsCFData);
                PointerByReference p = JnaInstances.coreFoundation.CFDataGetBytePtr(valueAsCFData);
                value = p.getPointer().getByteArray(0L, length);
            }
            JnaInstances.coreFoundation.CFRelease(valueAsCFData);
            return value;
        }

        private static int setMasterPort() {
            if (masterPort.getValue() == 0) {
                return JnaInstances.ioKit.IOMasterPort(0, masterPort);
            }
            return 0;
        }
    }

    public static class MachPort
    extends IntByReference {
    }
}

