/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.jna.mac;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import net.lecousin.framework.system.unix.jna.JnaInstances;

public interface CoreFoundation
extends Library {
    public static final int UTF_8 = 0x8000100;

    public CFAllocatorRef CFAllocatorGetDefault();

    public void CFRelease(PointerType var1);

    public CFStringRef CFStringCreateWithCharacters(Object var1, char[] var2, NativeLong var3);

    public Pointer CFDictionaryGetValue(CFDictionaryRef var1, CFStringRef var2);

    public boolean CFDictionaryGetValueIfPresent(CFDictionaryRef var1, CFStringRef var2, PointerType var3);

    public void CFDictionarySetValue(CFMutableDictionaryRef var1, PointerType var2, PointerType var3);

    public CFMutableDictionaryRef CFDictionaryCreateMutable(CFAllocatorRef var1, int var2, Pointer var3, Pointer var4);

    public boolean CFStringGetCString(Pointer var1, Pointer var2, long var3, int var5);

    public boolean CFBooleanGetValue(Pointer var1);

    public CFTypeRef CFArrayGetValueAtIndex(CFArrayRef var1, int var2);

    public void CFNumberGetValue(Pointer var1, int var2, ByReference var3);

    public long CFStringGetLength(Pointer var1);

    public long CFStringGetMaximumSizeForEncoding(long var1, int var3);

    public int CFDataGetLength(CFTypeRef var1);

    public PointerByReference CFDataGetBytePtr(CFTypeRef var1);

    public CFRunLoopRef CFRunLoopGetCurrent();

    public CFRunLoopRef CFRunLoopGetMain();

    public void CFRunLoopRun();

    public void CFRunLoopStop(CFRunLoopRef var1);

    public static class Util {
        public static long cfPointerToLong(Pointer p) {
            LongByReference lbr = new LongByReference();
            JnaInstances.coreFoundation.CFNumberGetValue(p, CFNumberType.kCFNumberLongLongType.ordinal(), (ByReference)lbr);
            return lbr.getValue();
        }

        public static int cfPointerToInt(Pointer p) {
            IntByReference ibr = new IntByReference();
            JnaInstances.coreFoundation.CFNumberGetValue(p, CFNumberType.kCFNumberIntType.ordinal(), (ByReference)ibr);
            return ibr.getValue();
        }

        public static boolean cfPointerToBoolean(Pointer p) {
            return JnaInstances.coreFoundation.CFBooleanGetValue(p);
        }

        public static String cfPointerToString(Pointer p) {
            if (p == null) {
                return "null";
            }
            long length = JnaInstances.coreFoundation.CFStringGetLength(p);
            long maxSize = JnaInstances.coreFoundation.CFStringGetMaximumSizeForEncoding(length, 0x8000100);
            if (maxSize == 0L) {
                maxSize = 1L;
            }
            Memory buf = new Memory(maxSize);
            JnaInstances.coreFoundation.CFStringGetCString(p, (Pointer)buf, maxSize, 0x8000100);
            return buf.getString(0L);
        }

        public static enum CFNumberType {
            unusedZero,
            kCFNumberSInt8Type,
            kCFNumberSInt16Type,
            kCFNumberSInt32Type,
            kCFNumberSInt64Type,
            kCFNumberFloat32Type,
            kCFNumberFloat64Type,
            kCFNumberCharType,
            kCFNumberShortType,
            kCFNumberIntType,
            kCFNumberLongType,
            kCFNumberLongLongType,
            kCFNumberFloatType,
            kCFNumberDoubleType,
            kCFNumberCFIndexType,
            kCFNumberNSIntegerType,
            kCFNumberCGFloatType,
            kCFNumberMaxType;

        }
    }

    public static class CFRunLoopRef
    extends PointerType {
    }

    public static class CFStringRef
    extends PointerType {
        public static CFStringRef toCFString(String s) {
            char[] chars = s.toCharArray();
            int length = chars.length;
            return JnaInstances.coreFoundation.CFStringCreateWithCharacters(null, chars, new NativeLong((long)length));
        }
    }

    public static class CFURLRef
    extends PointerType {
    }

    public static class CFArrayRef
    extends PointerType {
    }

    public static class CFBooleanRef
    extends PointerType {
    }

    public static class CFNumberRef
    extends PointerType {
    }

    public static class CFTypeRef
    extends PointerType {
    }

    public static class CFMutableDictionaryRef
    extends CFDictionaryRef {
    }

    public static class CFDictionaryRef
    extends PointerType {
    }

    public static class CFAllocatorRef
    extends PointerType {
    }
}

