/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.hardware;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.mutable.Mutable;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.progress.WorkProgressImpl;
import net.lecousin.framework.system.LCSystem;
import net.lecousin.framework.system.hardware.DiskPartition;
import net.lecousin.framework.system.hardware.Drive;
import net.lecousin.framework.system.hardware.Drives;
import net.lecousin.framework.system.hardware.PhysicalDrive;
import net.lecousin.framework.system.unix.hardware.PhysicalDriveUnix;
import net.lecousin.framework.system.unix.jna.JnaInstances;
import net.lecousin.framework.system.unix.jna.mac.CoreFoundation;
import net.lecousin.framework.system.unix.jna.mac.DiskArbitration;
import net.lecousin.framework.system.unix.jna.mac.IOKit;
import net.lecousin.framework.system.unix.jna.mac.SystemB;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.ProcessUtil;

public class DrivesMac
extends Drives {
    private WorkProgress init = null;
    private List<Drive> drives = new ArrayList<Drive>();
    private List<Drives.DriveListener> listeners = new ArrayList<Drives.DriveListener>();
    private static final CoreFoundation.CFStringRef strDADeviceModel = CoreFoundation.CFStringRef.toCFString("DADeviceModel");
    private static final CoreFoundation.CFStringRef strDAMediaSize = CoreFoundation.CFStringRef.toCFString("DAMediaSize");
    private static final CoreFoundation.CFStringRef strDAMediaBSDName = CoreFoundation.CFStringRef.toCFString("DAMediaBSDName");
    private static final CoreFoundation.CFStringRef strDAMediaWhole = CoreFoundation.CFStringRef.toCFString("DAMediaWhole");
    private static final CoreFoundation.CFStringRef strDABusPath = CoreFoundation.CFStringRef.toCFString("DABusPath");
    private static final CoreFoundation.CFStringRef strDADeviceVendor = CoreFoundation.CFStringRef.toCFString("DADeviceVendor");
    private static final CoreFoundation.CFStringRef strDAMediaRemovable = CoreFoundation.CFStringRef.toCFString("DAMediaRemovable");
    private static final CoreFoundation.CFStringRef strDADeviceRevision = CoreFoundation.CFStringRef.toCFString("DADeviceRevision");
    private static final CoreFoundation.CFStringRef strDAVolumeKind = CoreFoundation.CFStringRef.toCFString("DAVolumeKind");
    private static final CoreFoundation.CFStringRef strDAVolumeName = CoreFoundation.CFStringRef.toCFString("DAVolumeName");
    private static final CoreFoundation.CFStringRef strModel = CoreFoundation.CFStringRef.toCFString("Model");
    private static final CoreFoundation.CFStringRef strIOPropertyMatch = CoreFoundation.CFStringRef.toCFString("IOPropertyMatch");

    public WorkProgress initialize() {
        if (this.init != null) {
            return this.init;
        }
        this.init = new WorkProgressImpl(100000L, "Loading drives information");
        new Thread("Initializing Drives Information"){

            @Override
            public void run() {
                DrivesMac.this.initDrives(DrivesMac.this.init);
                LCSystem.log.info("Drives information initialized");
                DrivesMac.this.init.done();
            }
        }.start();
        return this.init;
    }

    public List<Drive> getDrives() {
        return new ArrayList<Drive>(this.drives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDrivesAndListen(Drives.DriveListener listener) {
        List<Drive> list = this.drives;
        synchronized (list) {
            for (Drive d : this.drives) {
                listener.newDrive(d);
            }
            List<Drives.DriveListener> list2 = this.listeners;
            synchronized (list2) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriveListener(Drives.DriveListener listener) {
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriveListener(Drives.DriveListener listener) {
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void initDrives(WorkProgress progress) {
        DiskArbitration da = JnaInstances.diskArbitration;
        final DiskArbitration.DASessionRef session = da.DASessionCreate(JnaInstances.ALLOCATOR);
        ArrayList<String> bsdNames = new ArrayList<String>();
        IntByReference iter = new IntByReference();
        IOKit.Util.getMatchingServices("IOMedia", iter);
        int media = JnaInstances.ioKit.IOIteratorNext(iter.getValue());
        while (media != 0) {
            DiskArbitration.DADiskRef disk = da.DADiskCreateFromIOMedia(JnaInstances.ALLOCATOR, session, media);
            String name = da.DADiskGetBSDName(disk);
            System.out.println("BSD Name: " + name);
            bsdNames.add(name);
            JnaInstances.ioKit.IOObjectRelease(media);
            media = JnaInstances.ioKit.IOIteratorNext(iter.getValue());
        }
        Mutable bsdNamesMountPoints = new Mutable(null);
        Mutable diskImages = new Mutable(null);
        for (String name : bsdNames) {
            DiskArbitration.DADiskRef disk = da.DADiskCreateFromBSDName(JnaInstances.ALLOCATOR, session, "/dev/" + name);
            if (disk == null) continue;
            this.newDisk(disk, (Mutable<List<Pair<String, String>>>)bsdNamesMountPoints, (Mutable<List<DiskImageInfo>>)diskImages);
            JnaInstances.coreFoundation.CFRelease(disk);
        }
        bsdNamesMountPoints = null;
        diskImages = null;
        da.DARegisterDiskAppearedCallback(session, null, new DiskArbitration.DADiskAppearedCallback(){

            @Override
            public void callback(DiskArbitration.DADiskRef disk, Pointer context) {
                DrivesMac.this.newDisk(disk, (Mutable<List<Pair<String, String>>>)new Mutable(null), (Mutable<List<DiskImageInfo>>)new Mutable(null));
            }
        }, null);
        da.DARegisterDiskDescriptionChangedCallback(session, null, null, new DiskArbitration.DADiskDescriptionChangedCallback(){

            @Override
            public void callback(DiskArbitration.DADiskRef disk, CoreFoundation.CFArrayRef keys, Pointer context) {
            }
        }, null);
        da.DARegisterDiskDisappearedCallback(session, null, new DiskArbitration.DADiskDisappearedCallback(){

            @Override
            public void callback(DiskArbitration.DADiskRef disk, Pointer context) {
                DrivesMac.this.diskRemoved(disk);
            }
        }, null);
        da.DASessionScheduleWithRunLoop(session, JnaInstances.coreFoundation.CFRunLoopGetMain(), CoreFoundation.CFStringRef.toCFString("kCFRunLoopDefaultMode"));
        LCCore.get().toClose(new Closeable(){

            @Override
            public void close() {
                JnaInstances.coreFoundation.CFRelease(session);
            }
        });
    }

    private static List<DiskImageInfo> hdiutilInfo() {
        LinkedList<DiskImageInfo> infos = new LinkedList<DiskImageInfo>();
        LinkedList lines = new LinkedList();
        try {
            Process process = Runtime.getRuntime().exec("hdiutil info");
            ProcessUtil.consumeProcessConsole((Process)process, line -> lines.add(line), line -> {});
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                return infos;
            }
        }
        catch (Throwable t) {
            LCSystem.log.error("Error running command hdiutil info", t);
            return infos;
        }
        DiskImageInfo di = null;
        for (String line2 : lines) {
            if ((line2 = line2.trim()).isEmpty()) continue;
            if (line2.equals("================================================")) {
                if (di != null) {
                    infos.add(di);
                }
                di = new DiskImageInfo();
                continue;
            }
            if (line2.length() > 16 && line2.charAt(16) == ':') {
                String value;
                String key = line2.substring(0, 15).trim();
                String string = value = line2.length() > 18 ? line2.substring(18).trim() : "";
                if (!"image-path".equals(key)) continue;
                di.path = value;
                continue;
            }
            if (!line2.startsWith("/dev/")) continue;
            int i = line2.indexOf(32);
            String dev = i < 0 ? line2 : line2.substring(0, i);
            di.devices.add(dev);
        }
        if (di != null) {
            infos.add(di);
        }
        return infos;
    }

    private static List<Pair<String, String>> getMountPoints() {
        int numfs = JnaInstances.systemB.getfsstat64(null, 0, 0);
        SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
        JnaInstances.systemB.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(numfs);
        for (SystemB.Statfs f : fs) {
            String mntFrom = new String(f.f_mntfromname).trim();
            String mntPath = new String(f.f_mntonname).trim();
            list.add((Pair<String, String>)new Pair((Object)mntFrom, (Object)mntPath));
            LCSystem.log.info("Mounted filesystem: " + mntFrom + " => " + mntPath);
        }
        return list;
    }

    private static File getMountPointFromDeviceName(String deviceName, Mutable<List<Pair<String, String>>> bsdNamesMountPoints) {
        if (bsdNamesMountPoints.get() == null) {
            bsdNamesMountPoints.set(DrivesMac.getMountPoints());
        }
        for (Pair p : (List)bsdNamesMountPoints.get()) {
            if (!deviceName.equals(p.getValue1())) continue;
            return new File((String)p.getValue2());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDisk(DiskArbitration.DADiskRef disk, Mutable<List<Pair<String, String>>> bsdNamesMountPoints, Mutable<List<DiskImageInfo>> diskImages) {
        DiskArbitration da = JnaInstances.diskArbitration;
        CoreFoundation.CFDictionaryRef diskInfo = da.DADiskCopyDescription(disk);
        if (diskInfo == null) {
            return;
        }
        Pointer ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDADeviceModel);
        String model = CoreFoundation.Util.cfPointerToString(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaSize);
        long size = ptr == null ? -1L : CoreFoundation.Util.cfPointerToLong(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaBSDName);
        String bsdName = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaWhole);
        if (ptr != null && CoreFoundation.Util.cfPointerToBoolean(ptr)) {
            if ("Disk Image".equals(model)) {
                this.newDiskImage(bsdName, bsdNamesMountPoints, diskImages);
                return;
            }
            PhysicalDriveUnix drive = new PhysicalDriveUnix();
            drive.devpath = bsdName;
            drive.model = model;
            drive.size = BigInteger.valueOf(size);
            ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDABusPath);
            drive.OSID = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
            ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDADeviceVendor);
            drive.manufacturer = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
            ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaRemovable);
            drive.removable = ptr == null ? false : CoreFoundation.Util.cfPointerToBoolean(ptr);
            ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDADeviceRevision);
            drive.version = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
            drive.itype = PhysicalDrive.InterfaceType.Unknown;
            drive.type = PhysicalDrive.Type.UNKNOWN;
            CoreFoundation.CFStringRef modelNameRef = CoreFoundation.CFStringRef.toCFString(model);
            CoreFoundation.CFMutableDictionaryRef propertyDict = JnaInstances.coreFoundation.CFDictionaryCreateMutable(JnaInstances.ALLOCATOR, 0, null, null);
            JnaInstances.coreFoundation.CFDictionarySetValue(propertyDict, strModel, modelNameRef);
            CoreFoundation.CFMutableDictionaryRef matchingDict = JnaInstances.coreFoundation.CFDictionaryCreateMutable(JnaInstances.ALLOCATOR, 0, null, null);
            JnaInstances.coreFoundation.CFDictionarySetValue(matchingDict, strIOPropertyMatch, propertyDict);
            IntByReference serviceIterator = new IntByReference();
            IOKit.Util.getMatchingServices(matchingDict, serviceIterator);
            int sdService = JnaInstances.ioKit.IOIteratorNext(serviceIterator.getValue());
            while (sdService != 0) {
                drive.serial = IOKit.Util.getIORegistryStringProperty(sdService, "Serial Number");
                JnaInstances.ioKit.IOObjectRelease(sdService);
                if (drive.serial != null) break;
                sdService = JnaInstances.ioKit.IOIteratorNext(serviceIterator.getValue());
            }
            JnaInstances.ioKit.IOObjectRelease(serviceIterator.getValue());
            JnaInstances.coreFoundation.CFRelease(modelNameRef);
            JnaInstances.coreFoundation.CFRelease(propertyDict);
            this.newDrive(drive);
            return;
        }
        DiskPartition part = new DiskPartition();
        part.size = size;
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDABusPath);
        String osId = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
        List<Drive> list = this.drives;
        synchronized (list) {
            for (Drive d : this.drives) {
                if (((PhysicalDriveUnix)d).OSID == null || !((PhysicalDriveUnix)d).OSID.equals(osId)) continue;
                part.drive = d;
                break;
            }
        }
        if (part.drive == null) {
            return;
        }
        part.OSID = bsdName;
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAVolumeKind);
        part.filesystem = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAVolumeName);
        part.name = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
        part.mountPoint = DrivesMac.getMountPointFromDeviceName("/dev/" + bsdName, bsdNamesMountPoints);
        for (DiskPartition p : ((PhysicalDriveUnix)part.drive).partitions) {
            if (!p.OSID.equals(bsdName)) continue;
            return;
        }
        ((PhysicalDriveUnix)part.drive).partitions.add(part);
        this.newPartition(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diskRemoved(DiskArbitration.DADiskRef disk) {
        DiskArbitration da = JnaInstances.diskArbitration;
        CoreFoundation.CFDictionaryRef diskInfo = da.DADiskCopyDescription(disk);
        if (diskInfo == null) {
            return;
        }
        Pointer ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDADeviceModel);
        String model = CoreFoundation.Util.cfPointerToString(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaBSDName);
        String bsdName = ptr == null ? null : CoreFoundation.Util.cfPointerToString(ptr);
        ptr = JnaInstances.coreFoundation.CFDictionaryGetValue(diskInfo, strDAMediaWhole);
        if (ptr != null && CoreFoundation.Util.cfPointerToBoolean(ptr)) {
            if ("Disk Image".equals(model)) {
                this.diskImageRemoved(bsdName);
                return;
            }
            PhysicalDriveUnix drive = null;
            List<Drive> list = this.drives;
            synchronized (list) {
                Iterator<Drive> it = this.drives.iterator();
                while (it.hasNext()) {
                    PhysicalDriveUnix d = (PhysicalDriveUnix)it.next();
                    if (!d.devpath.equals(bsdName)) continue;
                    drive = d;
                    it.remove();
                    break;
                }
            }
            if (drive != null) {
                this.driveRemoved(drive);
            }
            return;
        }
        DiskPartition part = null;
        List<Drive> list = this.drives;
        synchronized (list) {
            block7: for (Drive d : this.drives) {
                Iterator<DiskPartition> it = ((PhysicalDriveUnix)d).partitions.iterator();
                while (it.hasNext()) {
                    DiskPartition p = it.next();
                    if (!p.OSID.equals(bsdName)) continue;
                    part = p;
                    it.remove();
                    continue block7;
                }
            }
        }
        if (part == null) {
            return;
        }
        this.partitionRemoved(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDrive(PhysicalDriveUnix drive) {
        ArrayList<Drives.DriveListener> listeners;
        LCSystem.log.info("New drive on " + drive.devpath + " (" + drive.OSID + "): " + drive);
        Object object = this.listeners;
        synchronized (object) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        object = this.drives;
        synchronized (object) {
            for (Drive d : this.drives) {
                if (!(d instanceof PhysicalDriveUnix) || !((PhysicalDriveUnix)d).devpath.equals(drive.devpath)) continue;
                LCSystem.log.info("Drive already known: " + drive);
                return;
            }
            this.drives.add((Drive)drive);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.newDrive((Drive)drive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveRemoved(PhysicalDriveUnix drive) {
        ArrayList<Drives.DriveListener> listeners;
        LCSystem.log.info("Drive removed on " + drive.devpath + " (" + drive.OSID + "): " + drive);
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.driveRemoved((Drive)drive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newPartition(DiskPartition part) {
        ArrayList<Drives.DriveListener> listeners;
        LCSystem.log.info("New partition: " + part);
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.newPartition(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionRemoved(DiskPartition part) {
        ArrayList<Drives.DriveListener> listeners;
        LCSystem.log.info("Partition removed: " + part);
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.partitionRemoved(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDiskImage(String bsdName, Mutable<List<Pair<String, String>>> bsdNamesMountPoints, Mutable<List<DiskImageInfo>> diskImages) {
        if (diskImages.get() == null) {
            diskImages.set(DrivesMac.hdiutilInfo());
        }
        if (diskImages.get() == null) {
            return;
        }
        for (DiskImageInfo di : (List)diskImages.get()) {
            String dev2;
            File mountPoint = null;
            Iterator iterator = di.devices.iterator();
            while (iterator.hasNext() && (mountPoint = DrivesMac.getMountPointFromDeviceName(dev2 = (String)iterator.next(), bsdNamesMountPoints)) == null) {
            }
            for (String dev2 : di.devices) {
                if (!dev2.equals(bsdName)) continue;
                DiskPartition part = null;
                List<Drive> list = this.drives;
                synchronized (list) {
                    block6: for (Drive d : this.drives) {
                        for (DiskPartition p : ((PhysicalDriveUnix)d).partitions) {
                            if (p.mountPoint == null || !di.path.startsWith(p.mountPoint.getAbsolutePath())) continue;
                            part = p;
                            continue block6;
                        }
                    }
                }
                if (part != null) {
                    DiskPartition p = new DiskPartition();
                    p.drive = part.drive;
                    p.mountPoint = mountPoint;
                    p.OSID = bsdName;
                    this.newPartition(p);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diskImageRemoved(String bsdName) {
        DiskPartition part = null;
        List<Drive> list = this.drives;
        synchronized (list) {
            for (Drive d : this.drives) {
                Iterator<DiskPartition> it = ((PhysicalDriveUnix)d).partitions.iterator();
                while (it.hasNext()) {
                    DiskPartition p = it.next();
                    if (!p.OSID.equals(bsdName)) continue;
                    it.remove();
                    part = p;
                    break;
                }
                if (part == null) continue;
                break;
            }
        }
        if (part != null) {
            this.partitionRemoved(part);
        }
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> T openReadOnly(PhysicalDrive drive, byte priority) throws IOException {
        throw new IOException("Open drive not supported on MAC by library net.lecousin.system.unix");
    }

    public <T extends IO.Writable.Seekable & IO.KnownSize> T openWriteOnly(PhysicalDrive drive, byte priority) throws IOException {
        throw new IOException("Open drive not supported on MAC by library net.lecousin.system.unix");
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> T openReadWrite(PhysicalDrive drive, byte priority) throws IOException {
        throw new IOException("Open drive not supported on MAC by library net.lecousin.system.unix");
    }

    private static class DiskImageInfo {
        private String path;
        private List<String> devices = new LinkedList<String>();

        private DiskImageInfo() {
        }
    }
}

