/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer.util;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.kuujo.catalyst.buffer.util.MappedMemoryAllocator;
import net.kuujo.catalyst.buffer.util.NativeMemory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class MappedMemory
extends NativeMemory {
    public static final long MAX_SIZE = Integer.MAX_VALUE;
    private final MappedByteBuffer buffer;

    public static MappedMemory allocate(File file, long size) {
        return new MappedMemoryAllocator(file).allocate(size);
    }

    public static MappedMemory allocate(File file, FileChannel.MapMode mode, long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new MappedMemoryAllocator(file, mode).allocate(size);
    }

    public MappedMemory(MappedByteBuffer buffer, MappedMemoryAllocator allocator) {
        super(((DirectBuffer)((Object)buffer)).address(), buffer.capacity(), allocator);
        this.buffer = buffer;
    }

    public void flush() {
        this.buffer.force();
    }

    @Override
    public void free() {
        Cleaner cleaner = ((DirectBuffer)((Object)this.buffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
        ((MappedMemoryAllocator)this.allocator).release();
    }
}

