/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.BufferInput;
import net.kuujo.catalyst.buffer.Bytes;
import net.kuujo.catalyst.buffer.CatalystIOException;
import net.kuujo.catalyst.buffer.HeapBuffer;
import net.kuujo.catalyst.buffer.HeapBytes;

public class InputStreamBufferInput
implements BufferInput {
    private final DataInputStream is;

    public InputStreamBufferInput(InputStream is) {
        this(new DataInputStream(is));
    }

    public InputStreamBufferInput(DataInputStream is) {
        if (is == null) {
            throw new NullPointerException("input stream cannot be null");
        }
        this.is = is;
    }

    @Override
    public long remaining() {
        try {
            return this.is.available();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public BufferInput skip(long bytes) {
        try {
            this.is.skip(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferInput read(Bytes bytes) {
        if (bytes instanceof HeapBytes) {
            try {
                this.is.read(((HeapBytes)bytes).array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[(int)bytes.size()];
        try {
            int read = this.is.read(buffer);
            if (read != -1) {
                bytes.write(0L, buffer, 0L, (long)read);
            }
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferInput read(byte[] bytes) {
        try {
            this.is.read(bytes);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferInput read(Bytes bytes, long offset, long length) {
        if (bytes instanceof HeapBytes) {
            try {
                this.is.read(((HeapBytes)bytes).array(), (int)offset, (int)length);
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] buffer = new byte[1024];
        try {
            int read;
            long position = offset;
            long remaining = length;
            while ((read = this.is.read(buffer)) != -1) {
                bytes.write(position, buffer, 0L, Math.min((long)read, remaining));
                position += (long)read;
                remaining -= (long)read;
            }
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferInput read(byte[] bytes, long offset, long length) {
        try {
            this.is.read(bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    public BufferInput read(Buffer buffer) {
        if (buffer instanceof HeapBuffer) {
            try {
                this.is.read(((HeapBuffer)buffer).array());
            }
            catch (IOException e) {
                throw new CatalystIOException(e);
            }
        }
        byte[] bytes = new byte[1024];
        try {
            int read;
            while ((read = this.is.read(bytes)) != -1) {
                buffer.write(bytes, 0L, (long)read);
            }
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
        return this;
    }

    @Override
    public int readByte() {
        try {
            return this.is.readByte();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.is.readUnsignedByte();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public char readChar() {
        try {
            return this.is.readChar();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.is.readShort();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public int readUnsignedShort() {
        try {
            return this.is.readUnsignedShort();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public int readMedium() {
        try {
            return this.is.readByte() << 16 | (this.is.readByte() & 0xFF) << 8 | this.is.readByte() & 0xFF;
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public int readUnsignedMedium() {
        try {
            return (this.is.readByte() & 0xFF) << 16 | (this.is.readByte() & 0xFF) << 8 | this.is.readByte() & 0xFF;
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.is.readInt();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public long readUnsignedInt() {
        try {
            return (long)this.is.readInt() & 0xFFFFFFFFL;
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.is.readLong();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.is.readFloat();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.is.readDouble();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.is.readBoolean();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public String readString() {
        try {
            return this.is.readUTF();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public String readUTF8() {
        try {
            return this.is.readUTF();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }
}

