/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import net.jqwik.time.api.constraints.DateTimeRange;

public class DateTimeRangeConfigurator
extends ArbitraryConfiguratorBase {
    private static LocalDateTime stringToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime);
    }

    private static boolean filter(LocalDateTime dateTime, LocalDateTime min, LocalDateTime max) {
        return !dateTime.isBefore(min) && !dateTime.isAfter(max);
    }

    private static boolean filter(OffsetDateTime dateTime, LocalDateTime min, LocalDateTime max) {
        return DateTimeRangeConfigurator.filter(dateTime.toLocalDateTime(), min, max);
    }

    private static boolean filter(ZonedDateTime dateTime, LocalDateTime min, LocalDateTime max) {
        return DateTimeRangeConfigurator.filter(dateTime.toLocalDateTime(), min, max);
    }

    public static class ForZonedDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(ZonedDateTime.class);
        }

        public Arbitrary<ZonedDateTime> configure(Arbitrary<ZonedDateTime> arbitrary, DateTimeRange range) {
            LocalDateTime min = DateTimeRangeConfigurator.stringToLocalDateTime(range.min());
            LocalDateTime max = DateTimeRangeConfigurator.stringToLocalDateTime(range.max());
            if (arbitrary instanceof ZonedDateTimeArbitrary) {
                ZonedDateTimeArbitrary zonedDateTimeArbitrary = (ZonedDateTimeArbitrary)arbitrary;
                return zonedDateTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateTimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, DateTimeRange range) {
            LocalDateTime min = DateTimeRangeConfigurator.stringToLocalDateTime(range.min());
            LocalDateTime max = DateTimeRangeConfigurator.stringToLocalDateTime(range.max());
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateTimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, DateTimeRange range) {
            LocalDateTime min = DateTimeRangeConfigurator.stringToLocalDateTime(range.min());
            LocalDateTime max = DateTimeRangeConfigurator.stringToLocalDateTime(range.max());
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateTimeRangeConfigurator.filter(v, min, max));
        }
    }
}

