/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.constraints.InstantRange;

public class InstantConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Instant.class);
    }

    public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, InstantRange range) {
        Instant min = InstantConfigurator.stringToInstant(range.min());
        Instant max = InstantConfigurator.stringToInstant(range.max());
        if (arbitrary instanceof InstantArbitrary) {
            InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
            return instantArbitrary.between(min, max);
        }
        return arbitrary.filter(v -> InstantConfigurator.filter(v, min, max));
    }

    private static Instant stringToInstant(String instant) {
        return Instant.parse(instant);
    }

    private static boolean filter(Instant instant, Instant min, Instant max) {
        return !instant.isBefore(min) && !instant.isAfter(max);
    }
}

