/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Times;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultOffsetTimeArbitrary
extends ArbitraryDecorator<OffsetTime>
implements OffsetTimeArbitrary {
    private LocalTimeArbitrary localTimes = Times.times();
    private ZoneOffsetArbitrary zoneOffsets = Times.zoneOffsets();

    protected Arbitrary<OffsetTime> arbitrary() {
        return Combinators.combine((Arbitrary)this.localTimes, (Arbitrary)this.zoneOffsets).as(OffsetTime::of);
    }

    @Override
    public OffsetTimeArbitrary atTheEarliest(LocalTime min) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.atTheEarliest(min);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary atTheLatest(LocalTime max) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.atTheLatest(max);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary hourBetween(int min, int max) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.hourBetween(min, max);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary minuteBetween(int min, int max) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.minuteBetween(min, max);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary secondBetween(int min, int max) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.secondBetween(min, max);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary offsetBetween(ZoneOffset min, ZoneOffset max) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.zoneOffsets = clone.zoneOffsets.between(min, max);
        return clone;
    }

    @Override
    public OffsetTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultOffsetTimeArbitrary clone = (DefaultOffsetTimeArbitrary)this.typedClone();
        clone.localTimes = clone.localTimes.ofPrecision(ofPrecision);
        return clone;
    }
}

