/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.CacheLoader;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.Keywords;
import net.jimblackler.jsonschemafriend.Loader;
import net.jimblackler.jsonschemafriend.MetaSchemaDetector;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft03;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft04;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft06;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft07;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft201909;
import net.jimblackler.jsonschemafriend.MetaSchemaDraft202012;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.StandardGenerationException;
import net.jimblackler.jsonschemafriend.StreamUtils;
import net.jimblackler.jsonschemafriend.UriUtils;
import net.jimblackler.jsonschemafriend.UrlRewriter;
import net.jimblackler.jsonschemafriend.ValidationError;
import net.jimblackler.jsonschemafriend.Validator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SchemaStore {
    private static final Logger LOG = Logger.getLogger(SchemaStore.class.getName());
    private final Map<URI, Object> canonicalUriToObject = new HashMap<URI, Object>();
    private final Map<URI, Object> canonicalUriToBaseObject = new HashMap<URI, Object>();
    private final Map<URI, URI> validUriToCanonicalUri = new HashMap<URI, URI>();
    private final Map<URI, URI> canonicalUriToResourceUri = new HashMap<URI, URI>();
    private final Map<URI, Schema> builtSchemas = new HashMap<URI, Schema>();
    private final Map<URI, Set<String>> dynamicAnchorsBySchemaResource = new HashMap<URI, Set<String>>();
    private final Collection<URI> mapped = new HashSet<URI>();
    private final UrlRewriter urlRewriter;
    private final Loader loader;
    private int memorySchemaNumber;
    private boolean cacheSchema;

    public SchemaStore() {
        this(null, false);
    }

    public SchemaStore(boolean cacheSchema) {
        this(null, cacheSchema);
    }

    public SchemaStore(UrlRewriter urlRewriter) {
        this(urlRewriter, false);
    }

    public SchemaStore(Loader loader) {
        this(null, false, loader);
    }

    public SchemaStore(UrlRewriter urlRewriter, Loader loader) {
        this(urlRewriter, false, loader);
    }

    public SchemaStore(UrlRewriter urlRewriter, boolean cacheSchema) {
        this(urlRewriter, cacheSchema, new CacheLoader());
    }

    public SchemaStore(UrlRewriter urlRewriter, boolean cacheSchema, Loader loader) {
        this.urlRewriter = urlRewriter;
        this.cacheSchema = cacheSchema;
        this.loader = loader;
        this.store(MetaSchemaUris.DRAFT_3, MetaSchemaDraft03.SCHEMA);
        this.store(MetaSchemaUris.DRAFT_4, MetaSchemaDraft04.SCHEMA);
        this.store(MetaSchemaUris.DRAFT_6, MetaSchemaDraft06.SCHEMA);
        this.store(MetaSchemaUris.DRAFT_7, MetaSchemaDraft07.SCHEMA);
        this.store(MetaSchemaUris.DRAFT_2019_09, MetaSchemaDraft201909.SCHEMAS);
        this.store(MetaSchemaUris.DRAFT_2020_12, MetaSchemaDraft202012.SCHEMAS);
    }

    public Schema loadSchema(Object document) throws GenerationException {
        return this.loadSchema(document, new Validator());
    }

    public Schema loadSchema(Object document, Validator validator) throws GenerationException {
        URI uri = URI.create(this.memorySchemaNumber == 0 ? "" : String.valueOf(this.memorySchemaNumber));
        ++this.memorySchemaNumber;
        URI canonicalUri = this.store(uri, document);
        return this.loadSchema(canonicalUri, validator);
    }

    public Schema loadSchema(File file) throws GenerationException {
        if (!file.isFile()) {
            throw new GenerationException(file + " is not a file.");
        }
        return this.loadSchema(file.toURI());
    }

    public Schema loadSchema(URL url) throws GenerationException {
        return this.loadSchema(url, new Validator(), null);
    }

    public Schema loadSchema(URL url, Validator validator, Consumer<ValidationError> errorConsumer) throws GenerationException {
        try {
            return this.loadSchema(url.toURI(), validator, errorConsumer);
        }
        catch (URISyntaxException e) {
            throw new GenerationException(e);
        }
    }

    public Schema loadSchema(URI uri) throws GenerationException {
        return this.loadSchema(uri, new Validator());
    }

    public Schema loadSchema(InputStream stream) throws GenerationException {
        try {
            return this.loadSchemaJson(StreamUtils.streamToString(stream));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Schema loadSchemaJson(String string) throws GenerationException {
        try {
            return this.loadSchema(new ObjectMapper().readValue(string, Object.class));
        }
        catch (JsonProcessingException e) {
            throw new GenerationException(e);
        }
    }

    public Schema loadSchema(URI uri, Validator validator) throws GenerationException {
        return this.loadSchema(uri, validator, null);
    }

    public Schema loadSchema(URI uri, Validator validator, Consumer<ValidationError> errorConsumer) throws GenerationException {
        URI metaSchemaUri;
        Object schemaObject;
        uri = PathUtils.normalize(uri);
        while (true) {
            boolean preDraft2019;
            Map schemaJsonObject;
            Object refObject;
            URI documentUri;
            if (this.builtSchemas.containsKey(uri)) {
                return this.builtSchemas.get(uri);
            }
            if (this.validUriToCanonicalUri.containsKey(uri)) {
                uri = this.validUriToCanonicalUri.get(uri);
                continue;
            }
            if (uri.isAbsolute() && !this.canonicalUriToObject.containsKey(documentUri = PathUtils.baseDocumentFromUri(uri))) {
                LOG.fine("Loading: " + documentUri + " to resolve: " + uri);
                try {
                    if (!this.mapped.contains(documentUri)) {
                        String content = this.getContent(documentUri);
                        try {
                            this.store(documentUri, new ObjectMapper().readValue(content, Object.class));
                        }
                        catch (JsonProcessingException e) {
                            Document doc = Jsoup.parse((String)content);
                            Elements links = doc.head().select("link[rel='canonical']");
                            boolean resolved = false;
                            for (Element link : links) {
                                String href = link.attr("href");
                                URI canonical = new URL(documentUri.toURL(), href).toURI();
                                if (canonical.equals(documentUri)) continue;
                                this.store(documentUri, this.getContent(canonical));
                                resolved = true;
                                break;
                            }
                            if (resolved) continue;
                            LOG.warning("Was not valid JSON: " + documentUri);
                        }
                        continue;
                    }
                }
                catch (IOException | URISyntaxException e) {
                    LOG.warning("Failed attempt to auto fetch " + documentUri + " to resolve: " + uri);
                }
            }
            if (!((schemaObject = this.getObject(uri)) instanceof Map) || !((refObject = (schemaJsonObject = (Map)schemaObject).get("$ref")) instanceof String)) break;
            URI metaSchema = MetaSchemaDetector.detectMetaSchema(this.canonicalUriToBaseObject.get(uri));
            boolean preDraft4 = metaSchema.equals(MetaSchemaUris.DRAFT_3);
            boolean preDraft6 = preDraft4 || metaSchema.equals(MetaSchemaUris.DRAFT_4);
            boolean preDraft7 = preDraft6 || metaSchema.equals(MetaSchemaUris.DRAFT_6);
            boolean bl = preDraft2019 = preDraft7 || metaSchema.equals(MetaSchemaUris.DRAFT_7);
            if (!preDraft2019 && schemaJsonObject.size() > 1) break;
            String refString = PathUtils.fixUnescaped((String)refObject);
            uri = PathUtils.normalize(PathUtils.resolve(uri, URI.create(refString)));
        }
        if (validator != null && (schemaObject = this.getObject(uri)) != null && !PathUtils.normalize(metaSchemaUri = MetaSchemaDetector.detectMetaSchema(this.canonicalUriToBaseObject.get(uri))).equals(uri)) {
            Schema metaSchema = this.loadSchema(metaSchemaUri, null);
            if (errorConsumer == null) {
                Map<String, Object> validation = validator.validateWithOutput(metaSchema, schemaObject);
                if (!((Boolean)validation.get("valid")).booleanValue()) {
                    throw new StandardGenerationException(validation);
                }
            } else {
                validator.validate(metaSchema, schemaObject, errorConsumer);
            }
        }
        return new Schema(this, uri);
    }

    private String getContent(URI documentUri) throws IOException {
        if (this.urlRewriter == null) {
            return this.loader.load(documentUri, this.cacheSchema);
        }
        return this.loader.load(this.urlRewriter.rewrite(documentUri), this.cacheSchema);
    }

    public void register(URI path, Schema schema) throws GenerationException {
        if (this.builtSchemas.put(path, schema) != null) {
            throw new GenerationException(path + " already registered");
        }
    }

    public URI store(URI uri, Object document) {
        if (!this.mapped.add(uri)) {
            throw new IllegalStateException("Double mapped");
        }
        return this.map(document, document, uri, uri, MetaSchemaDetector.detectMetaSchema(document), true, 1);
    }

    URI map(Object object, Object baseObject, URI validUri, URI canonicalBaseUri, URI metaSchema, boolean isResource, int context) {
        URI was;
        Map jsonObject;
        URI canonicalUri = canonicalBaseUri;
        if ((context & 1) != 0 && object instanceof Map) {
            Object dynamicAnchorObject;
            Object anchorObject;
            jsonObject = (Map)object;
            boolean preDraft4 = metaSchema.equals(MetaSchemaUris.DRAFT_3);
            boolean preDraft6 = preDraft4 || metaSchema.equals(MetaSchemaUris.DRAFT_4);
            boolean preDraft7 = preDraft6 || metaSchema.equals(MetaSchemaUris.DRAFT_6);
            boolean preDraft2019 = preDraft7 || metaSchema.equals(MetaSchemaUris.DRAFT_7);
            String idKey = preDraft6 ? "id" : "$id";
            Object idObject = jsonObject.get(idKey);
            if (idObject instanceof String) {
                URI child = URI.create((String)idObject);
                if (preDraft2019 && jsonObject.containsKey("$ref")) {
                    LOG.warning("$id and $ref together are invalid");
                } else if (!preDraft2019 && child.getRawFragment() != null && !child.getRawFragment().isEmpty()) {
                    LOG.warning("Illegal fragment in ID");
                } else {
                    canonicalUri = PathUtils.normalize(PathUtils.resolve(canonicalUri, child));
                }
            }
            if ((anchorObject = jsonObject.get("$anchor")) instanceof String) {
                try {
                    URI anchor = new URI(null, null, null, (String)anchorObject);
                    canonicalUri = PathUtils.resolve(canonicalUri, anchor);
                }
                catch (URISyntaxException e) {
                    LOG.warning("Problem with $anchor: " + e.getMessage());
                }
            }
            if ((dynamicAnchorObject = jsonObject.get("$dynamicAnchor")) instanceof String) {
                try {
                    URI dynamicAnchorUri = new URI(null, null, null, (String)dynamicAnchorObject);
                    this.validUriToCanonicalUri.put(PathUtils.resolve(canonicalUri, dynamicAnchorUri), canonicalUri);
                    URI schemaResource = UriUtils.withoutFragment(canonicalUri);
                    this.dynamicAnchorsBySchemaResource.computeIfAbsent(schemaResource, k -> new HashSet()).add(dynamicAnchorUri.getFragment());
                }
                catch (URISyntaxException e) {
                    LOG.warning("Problem with $dynamicAnchor: " + e.getMessage());
                }
            }
        }
        if (((context & 1) != 0 || (context & 8) != 0) && isResource) {
            was = this.canonicalUriToResourceUri.put(canonicalUri, validUri);
            if (was != null) {
                LOG.warning("Attempt to map from at least two locations: " + canonicalUri + System.lineSeparator() + validUri + System.lineSeparator() + was);
                return canonicalUri;
            }
            if (this.canonicalUriToObject.put(canonicalUri, object) != null) {
                throw new IllegalStateException("Different content with same IDs found mapping " + canonicalUri);
            }
            if (this.canonicalUriToBaseObject.put(canonicalUri, baseObject) != null) {
                throw new IllegalStateException("Different content with same IDs found mapping " + canonicalUri);
            }
        }
        if ((context & 1) != 0) {
            if (!canonicalBaseUri.equals(canonicalUri) && (was = this.validUriToCanonicalUri.put(canonicalBaseUri, canonicalUri)) != null && !was.equals(canonicalUri)) {
                LOG.warning("Error mapping " + canonicalBaseUri + " to " + canonicalUri + System.lineSeparator() + "Location was already mapped to " + was);
            }
            if (!(validUri.equals(canonicalUri) || canonicalBaseUri.equals(validUri) || (was = this.validUriToCanonicalUri.put(validUri, canonicalUri)) == null || was.equals(canonicalUri))) {
                LOG.warning("Error mapping " + validUri + " to " + canonicalUri + System.lineSeparator() + "Location was already mapped to " + was);
            }
            if (object instanceof Map) {
                jsonObject = (Map)object;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Integer mapContext = Keywords.KEY_TYPES.get(key);
                    URI nextCanonical = PathUtils.append(canonicalUri, key);
                    if (mapContext == null) {
                        mapContext = 8;
                    }
                    if (mapContext == 0) continue;
                    this.map(entry.getValue(), baseObject, PathUtils.append(validUri, key), nextCanonical, metaSchema, isResource, mapContext);
                    if (canonicalBaseUri.equals(canonicalUri) || canonicalBaseUri.equals(validUri)) continue;
                    this.map(entry.getValue(), baseObject, PathUtils.append(canonicalBaseUri, key), nextCanonical, metaSchema, false, mapContext);
                }
            }
        }
        if (((context & 1) == 0 || (context & 2) != 0) && object instanceof Map) {
            jsonObject = (Map)object;
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                URI nextCanonical = PathUtils.append(canonicalUri, key);
                if (this.validUriToCanonicalUri.containsKey(nextCanonical)) continue;
                this.map(entry.getValue(), baseObject, PathUtils.append(validUri, key), nextCanonical, metaSchema, isResource, (context & 2) == 0 ? 0 : 1);
            }
        }
        if (((context & 1) == 0 || (context & 4) != 0) && object instanceof List) {
            List jsonArray = (List)object;
            for (int idx = 0; idx != jsonArray.size(); ++idx) {
                this.map(jsonArray.get(idx), baseObject, PathUtils.append(validUri, String.valueOf(idx)), PathUtils.append(canonicalUri, String.valueOf(idx)), metaSchema, isResource, (context & 4) == 0 ? 0 : 1);
            }
        }
        return canonicalUri;
    }

    Object getObject(URI canonicalUri) {
        if (this.validUriToCanonicalUri.containsKey(canonicalUri)) {
            throw new IllegalStateException("getObject(): non-canonical URL received");
        }
        if (this.canonicalUriToObject.containsKey(canonicalUri)) {
            return this.canonicalUriToObject.get(canonicalUri);
        }
        return null;
    }

    public Object getBaseObject(URI uri) {
        return this.canonicalUriToBaseObject.get(uri);
    }

    public URI canonicalUriToResourceUri(URI uri) {
        return this.canonicalUriToResourceUri.get(uri);
    }

    public Set<String> getDynamicAnchorsForSchemaResource(URI uri) {
        return this.dynamicAnchorsBySchemaResource.get(uri);
    }
}

