/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.MetaSchemaDetector;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.SchemaStore;
import net.jimblackler.jsonschemafriend.UriUtils;
import net.jimblackler.jsonschemafriend.Utils;
import net.jimblackler.jsonschemafriend.ValidationError;
import net.jimblackler.jsonschemafriend.Validator;

public class Schema {
    private static final Logger LOG = Logger.getLogger(Schema.class.getName());
    private final Object schemaObject;
    private final Object baseObject;
    private final URI uri;
    private final URI resourceUri;
    private final boolean isFalse;
    private final Number multipleOf;
    private final Number maximum;
    private final Object exclusiveMaximum;
    private final Number minimum;
    private final Object exclusiveMinimum;
    private final Number divisibleBy;
    private final Number maxLength;
    private final Number minLength;
    private final String pattern;
    private final String format;
    private final String contentEncoding;
    private final String contentMediaType;
    private final List<Schema> prefixItems;
    private final Schema additionalItems;
    private final Schema unevaluatedItems;
    private final Schema _items;
    private final List<Schema> itemsTuple;
    private final Number maxItems;
    private final Number minItems;
    private final boolean uniqueItems;
    private final Schema contains;
    private final Number minContains;
    private final Number maxContains;
    private final Number maxProperties;
    private final Number minProperties;
    private final Collection<String> requiredProperties = new HashSet<String>();
    private final boolean required;
    private final Schema additionalProperties;
    private final Schema unevaluatedProperties;
    private final Map<String, Schema> _properties = new LinkedHashMap<String, Schema>();
    private final Collection<String> patternPropertiesPatterns = new ArrayList<String>();
    private final Collection<Schema> patternPropertiesSchemas = new ArrayList<Schema>();
    private final Map<String, Collection<String>> dependentRequired = new HashMap<String, Collection<String>>();
    private final Map<String, Schema> dependentSchemas = new HashMap<String, Schema>();
    private final Schema propertyNames;
    private final boolean hasConst;
    private final Object _const;
    private final List<Object> enums;
    private final Set<String> explicitTypes;
    private final Collection<Schema> typesSchema = new HashSet<Schema>();
    private final Collection<String> disallow = new HashSet<String>();
    private final Collection<Schema> disallowSchemas = new HashSet<Schema>();
    private final Object defaultValue;
    private final Schema _if;
    private final Schema _then;
    private final Schema _else;
    private final Collection<Schema> allOf = new ArrayList<Schema>();
    private final Collection<Schema> anyOf;
    private final Collection<Schema> oneOf;
    private final Schema not;
    private final Schema ref;
    private final Schema recursiveRef;
    private final URI dynamicRefURI;
    private final Schema defaultDynamicRef;
    private final String dynamicAnchor;
    private final boolean recursiveAnchor;
    private final Map<String, Schema> dynamicAnchorsInResource = new HashMap<String, Schema>();
    private final List<Object> examples;
    private final String title;
    private final String description;
    private URI metaSchema;
    private Map<URI, Schema> subSchemas = new LinkedHashMap<URI, Schema>();
    private Schema parent;

    Schema(SchemaStore schemaStore, URI uri) throws GenerationException {
        Object oneOfObject;
        Object dynamicRefObject;
        Object refObject;
        Object extendsObject;
        Collection array;
        Map map;
        Map dependentRequiredJsonObject;
        ArrayList<String> spec;
        Map dependenciesJsonObject;
        Object patternPropertiesObject;
        Object propertiesObject;
        Object defsObject;
        this.uri = uri;
        URI resourceUri = schemaStore.canonicalUriToResourceUri(uri);
        this.resourceUri = resourceUri == null ? uri : resourceUri;
        schemaStore.register(uri, this);
        Object _schemaObject = schemaStore.getObject(uri);
        if (_schemaObject == null) {
            LOG.warning("No match for " + uri);
            _schemaObject = true;
        }
        this.schemaObject = _schemaObject;
        LinkedHashMap<String, Object> jsonObject = this.schemaObject instanceof Map ? (LinkedHashMap<String, Object>)this.schemaObject : new LinkedHashMap<String, Object>();
        this.baseObject = schemaStore.getBaseObject(uri);
        this.isFalse = Boolean.FALSE.equals(this.schemaObject);
        this.multipleOf = (Number)jsonObject.get("multipleOf");
        this.maximum = (Number)jsonObject.get("maximum");
        this.exclusiveMaximum = jsonObject.get("exclusiveMaximum");
        this.minimum = (Number)jsonObject.get("minimum");
        this.exclusiveMinimum = jsonObject.get("exclusiveMinimum");
        this.divisibleBy = (Number)jsonObject.get("divisibleBy");
        this.maxLength = (Number)jsonObject.get("maxLength");
        this.minLength = (Number)jsonObject.get("minLength");
        Object patternObject = jsonObject.get("pattern");
        String _pattern = null;
        if (patternObject != null) {
            _pattern = (String)patternObject;
        }
        this.pattern = _pattern;
        Object formatObject = jsonObject.get("format");
        this.format = formatObject instanceof String ? (String)formatObject : null;
        Object contentEncodingObject = jsonObject.get("contentEncoding");
        this.contentEncoding = contentEncodingObject instanceof String ? (String)contentEncodingObject : null;
        Object contentMediaTypeObject = jsonObject.get("contentMediaType");
        this.contentMediaType = contentMediaTypeObject instanceof String ? (String)contentMediaTypeObject : null;
        Object prefixItemsObject = jsonObject.get("prefixItems");
        URI prefixItemsPath = PathUtils.append(uri, "prefixItems");
        if (prefixItemsObject instanceof List) {
            this.prefixItems = new ArrayList<Schema>();
            Collection jsonArray = (Collection)prefixItemsObject;
            for (int idx = 0; idx != jsonArray.size(); ++idx) {
                this.prefixItems.add(this.getChildSchema(schemaStore, PathUtils.append(prefixItemsPath, String.valueOf(idx))));
            }
        } else {
            this.prefixItems = null;
        }
        this.additionalItems = this.getChildSchema(schemaStore, jsonObject, uri, "additionalItems");
        this.unevaluatedItems = this.getChildSchema(schemaStore, jsonObject, uri, "unevaluatedItems");
        Object itemsObject = jsonObject.get("items");
        URI itemsPath = PathUtils.append(uri, "items");
        if (itemsObject instanceof List) {
            this.itemsTuple = new ArrayList<Schema>();
            Collection jsonArray = (Collection)itemsObject;
            for (int idx = 0; idx != jsonArray.size(); ++idx) {
                this.itemsTuple.add(this.getChildSchema(schemaStore, PathUtils.append(itemsPath, String.valueOf(idx))));
            }
            this._items = null;
        } else {
            this.itemsTuple = null;
            this._items = this.getChildSchema(schemaStore, jsonObject, uri, "items");
        }
        this.maxItems = (Number)jsonObject.get("maxItems");
        this.minItems = (Number)jsonObject.get("minItems");
        this.uniqueItems = Utils.getOrDefault(jsonObject, "uniqueItems", false);
        this.contains = this.getChildSchema(schemaStore, jsonObject, uri, "contains");
        this.minContains = (Number)jsonObject.get("minContains");
        this.maxContains = (Number)jsonObject.get("maxContains");
        this.maxProperties = (Number)jsonObject.get("maxProperties");
        this.minProperties = (Number)jsonObject.get("minProperties");
        Object requiredObject = jsonObject.get("required");
        if (requiredObject instanceof List) {
            for (Object req : (Iterable)requiredObject) {
                this.requiredProperties.add((String)req);
            }
        }
        this.required = requiredObject instanceof Boolean && (Boolean)requiredObject != false;
        this.additionalProperties = this.getChildSchema(schemaStore, jsonObject, uri, "additionalProperties");
        this.unevaluatedProperties = this.getChildSchema(schemaStore, jsonObject, uri, "unevaluatedProperties");
        Object definitionsObject = jsonObject.get("definitions");
        if (definitionsObject instanceof Map) {
            Map definitions = (Map)definitionsObject;
            URI propertiesPointer = PathUtils.append(uri, "definitions");
            for (Object key : definitions.keySet()) {
                this.getChildSchema(schemaStore, PathUtils.append(propertiesPointer, (String)key));
            }
        }
        if ((defsObject = jsonObject.get("$defs")) instanceof Map) {
            Map defs = (Map)defsObject;
            URI propertiesPointer = PathUtils.append(uri, "$defs");
            for (Object key : defs.keySet()) {
                this.getChildSchema(schemaStore, PathUtils.append(propertiesPointer, (String)key));
            }
        }
        if ((propertiesObject = jsonObject.get("properties")) instanceof Map) {
            Map properties = (Map)propertiesObject;
            URI propertiesPointer = PathUtils.append(uri, "properties");
            for (String string : properties.keySet()) {
                URI uRI = PathUtils.append(propertiesPointer, string);
                this._properties.put(string, this.getChildSchema(schemaStore, uRI));
            }
        }
        if ((patternPropertiesObject = jsonObject.get("patternProperties")) instanceof Map) {
            Map patternProperties = (Map)patternPropertiesObject;
            URI propertiesPointer = PathUtils.append(uri, "patternProperties");
            for (String string : patternProperties.keySet()) {
                this.patternPropertiesPatterns.add(string);
                URI patternPointer = PathUtils.append(propertiesPointer, string);
                this.patternPropertiesSchemas.add(this.getChildSchema(schemaStore, patternPointer));
            }
        }
        if ((dependenciesJsonObject = (Map)jsonObject.get("dependencies")) != null) {
            for (Map.Entry entry : dependenciesJsonObject.entrySet()) {
                String string = (String)entry.getKey();
                spec = new ArrayList<String>();
                Object dependencyObject = entry.getValue();
                if (dependencyObject instanceof List) {
                    for (Object o : (Iterable)dependencyObject) {
                        spec.add((String)o);
                    }
                    this.dependentRequired.put(string, spec);
                    continue;
                }
                if (dependencyObject instanceof Map || dependencyObject instanceof Boolean) {
                    URI dependenciesPointer = PathUtils.append(uri, "dependencies");
                    this.dependentSchemas.put(string, this.getChildSchema(schemaStore, PathUtils.append(dependenciesPointer, string)));
                    continue;
                }
                ArrayList<String> objects = new ArrayList<String>();
                objects.add((String)dependencyObject);
                this.dependentRequired.put(string, objects);
            }
        }
        if ((dependentRequiredJsonObject = (Map)jsonObject.get("dependentRequired")) != null) {
            for (Map.Entry entry : dependentRequiredJsonObject.entrySet()) {
                spec = new ArrayList();
                for (Object req : (Iterable)entry.getValue()) {
                    spec.add((String)req);
                }
                this.dependentRequired.put((String)entry.getKey(), spec);
            }
        }
        if ((map = (Map)jsonObject.get("dependentSchemas")) != null) {
            for (String dependency : map.keySet()) {
                URI dependenciesPointer = PathUtils.append(uri, "dependentSchemas");
                this.dependentSchemas.put(dependency, this.getChildSchema(schemaStore, PathUtils.append(dependenciesPointer, dependency)));
            }
        }
        this.propertyNames = this.getChildSchema(schemaStore, jsonObject, uri, "propertyNames");
        if (jsonObject.containsKey("const")) {
            this.hasConst = true;
            this._const = jsonObject.get("const");
        } else {
            this.hasConst = false;
            this._const = null;
        }
        Collection collection = (Collection)jsonObject.get("enum");
        if (collection == null) {
            this.enums = null;
        } else {
            this.enums = new ArrayList<Object>();
            this.enums.addAll(collection);
        }
        Object typeObject = jsonObject.get("type");
        if (typeObject instanceof List) {
            URI typePointer = PathUtils.append(uri, "type");
            this.explicitTypes = new HashSet<String>();
            array = (List)typeObject;
            for (int idx = 0; idx != array.size(); ++idx) {
                Object arrayEntryObject = array.get(idx);
                if (arrayEntryObject instanceof Boolean || arrayEntryObject instanceof Map) {
                    this.typesSchema.add(this.getChildSchema(schemaStore, PathUtils.append(typePointer, String.valueOf(idx))));
                    continue;
                }
                this.explicitTypes.add((String)arrayEntryObject);
            }
        } else {
            this.explicitTypes = typeObject instanceof String ? Utils.setOf(typeObject.toString()) : null;
        }
        this._if = this.getChildSchema(schemaStore, jsonObject, uri, "if");
        this._then = this.getChildSchema(schemaStore, jsonObject, uri, "then");
        this._else = this.getChildSchema(schemaStore, jsonObject, uri, "else");
        Object allOfObject = jsonObject.get("allOf");
        if (allOfObject instanceof List) {
            array = (Collection)allOfObject;
            URI arrayPath = PathUtils.append(uri, "allOf");
            for (int idx = 0; idx != array.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.allOf.add(this.getChildSchema(schemaStore, indexPointer));
            }
        }
        if ((extendsObject = jsonObject.get("extends")) instanceof List) {
            URI arrayPath = PathUtils.append(uri, "extends");
            Collection array2 = (Collection)extendsObject;
            for (int idx = 0; idx != array2.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.allOf.add(this.getChildSchema(schemaStore, indexPointer));
            }
        } else if (extendsObject instanceof Map || extendsObject instanceof Boolean) {
            URI arrayPath = PathUtils.append(uri, "extends");
            this.allOf.add(this.getChildSchema(schemaStore, arrayPath));
        }
        if ((refObject = jsonObject.get("$ref")) instanceof String) {
            URI resolved = PathUtils.resolve(uri, URI.create(PathUtils.fixUnescaped((String)refObject)));
            this.ref = this.getSubSchema(schemaStore, resolved);
        } else {
            this.ref = null;
        }
        Object recursiveRefObject = jsonObject.get("$recursiveRef");
        if (recursiveRefObject instanceof String) {
            URI resolved = PathUtils.resolve(uri, URI.create((String)recursiveRefObject));
            this.recursiveRef = this.getSubSchema(schemaStore, resolved);
        } else {
            this.recursiveRef = null;
        }
        this.recursiveAnchor = Utils.getOrDefault(jsonObject, "$recursiveAnchor", false);
        URI schemaResource = UriUtils.withoutFragment(uri);
        Set<String> dynamicAnchorsInResource = schemaStore.getDynamicAnchorsForSchemaResource(schemaResource);
        if (dynamicAnchorsInResource != null) {
            for (String anchor : dynamicAnchorsInResource) {
                URI uri1 = PathUtils.resolve(uri, URI.create("#" + anchor));
                Schema schema = this.getSubSchema(schemaStore, uri1);
                this.dynamicAnchorsInResource.put(anchor, schema);
            }
        }
        if ((dynamicRefObject = jsonObject.get("$dynamicRef")) instanceof String) {
            this.dynamicRefURI = URI.create(PathUtils.fixUnescaped((String)dynamicRefObject));
            this.defaultDynamicRef = this.getSubSchema(schemaStore, PathUtils.resolve(uri, this.dynamicRefURI));
        } else {
            this.dynamicRefURI = null;
            this.defaultDynamicRef = null;
        }
        Object dynamicAnchorObject = jsonObject.get("$dynamicAnchor");
        this.dynamicAnchor = dynamicAnchorObject instanceof String ? (String)dynamicAnchorObject : null;
        Object anyOfObject = jsonObject.get("anyOf");
        if (anyOfObject instanceof List) {
            this.anyOf = new ArrayList<Schema>();
            Collection array3 = (Collection)anyOfObject;
            URI arrayPath = PathUtils.append(uri, "anyOf");
            for (int idx = 0; idx != array3.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.anyOf.add(this.getChildSchema(schemaStore, indexPointer));
            }
        } else {
            this.anyOf = null;
        }
        if ((oneOfObject = jsonObject.get("oneOf")) instanceof List) {
            this.oneOf = new ArrayList<Schema>();
            Collection array4 = (Collection)oneOfObject;
            URI arrayPath = PathUtils.append(uri, "oneOf");
            for (int idx = 0; idx != array4.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.oneOf.add(this.getChildSchema(schemaStore, indexPointer));
            }
        } else {
            this.oneOf = null;
        }
        this.not = this.getChildSchema(schemaStore, jsonObject, uri, "not");
        Object disallowObject = jsonObject.get("disallow");
        if (disallowObject instanceof String) {
            this.disallow.add(disallowObject.toString());
        } else if (disallowObject instanceof List) {
            List array5 = (List)disallowObject;
            URI disallowPointer = PathUtils.append(uri, "disallow");
            for (int idx = 0; idx != array5.size(); ++idx) {
                Object disallowEntryObject = array5.get(idx);
                if (disallowEntryObject instanceof String) {
                    this.disallow.add((String)array5.get(idx));
                    continue;
                }
                this.disallowSchemas.add(this.getChildSchema(schemaStore, PathUtils.append(disallowPointer, String.valueOf(idx))));
            }
        }
        this.defaultValue = jsonObject.get("default");
        this.title = (String)jsonObject.get("title");
        this.description = (String)jsonObject.get("description");
        this.examples = (List)jsonObject.get("examples");
    }

    private Schema getChildSchema(SchemaStore schemaStore, Map<String, Object> jsonObject, URI uri, String name) throws GenerationException {
        Object childObject = jsonObject.get(name);
        if (childObject instanceof Map || childObject instanceof Boolean) {
            return this.getChildSchema(schemaStore, PathUtils.append(uri, name));
        }
        return null;
    }

    private Schema getChildSchema(SchemaStore schemaStore, URI uri) throws GenerationException {
        Schema subSchema = this.getSubSchema(schemaStore, uri);
        if (subSchema != null && subSchema.getUri().equals(uri)) {
            subSchema.setParent(this);
        }
        return subSchema;
    }

    private Schema getSubSchema(SchemaStore schemaStore, URI uri) throws GenerationException {
        Schema subSchema = schemaStore.loadSchema(uri, null);
        if (subSchema != null) {
            this.subSchemas.put(subSchema.getUri(), subSchema);
        }
        return subSchema;
    }

    public Boolean isFalse() {
        return this.isFalse;
    }

    public String toString() {
        return this.uri + " / " + this.schemaObject;
    }

    public boolean isExclusiveMinimumBoolean() {
        if (this.exclusiveMinimum instanceof Boolean) {
            return (Boolean)this.exclusiveMinimum;
        }
        return false;
    }

    public boolean isExclusiveMaximumBoolean() {
        if (this.exclusiveMaximum instanceof Boolean) {
            return (Boolean)this.exclusiveMaximum;
        }
        return false;
    }

    public Object getSchemaObject() {
        return this.schemaObject;
    }

    public URI getUri() {
        return this.uri;
    }

    public Object getResourceUri() {
        return this.resourceUri;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getExclusiveMaximum() {
        if (this.exclusiveMaximum instanceof Number) {
            return (Number)this.exclusiveMaximum;
        }
        return null;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getExclusiveMinimum() {
        if (this.exclusiveMinimum instanceof Number) {
            return (Number)this.exclusiveMinimum;
        }
        return null;
    }

    public Number getDivisibleBy() {
        return this.divisibleBy;
    }

    public Number getMaxLength() {
        return this.maxLength;
    }

    public Number getMinLength() {
        return this.minLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFormat() {
        return this.format;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentMediaType() {
        return this.contentMediaType;
    }

    public List<Schema> getPrefixItems() {
        return this.prefixItems == null ? null : Collections.unmodifiableList(this.prefixItems);
    }

    public Schema getAdditionalItems() {
        return this.additionalItems;
    }

    public Schema getUnevaluatedItems() {
        return this.unevaluatedItems;
    }

    public Schema getItems() {
        return this._items;
    }

    public List<Schema> getItemsTuple() {
        return this.itemsTuple == null ? null : Collections.unmodifiableList(this.itemsTuple);
    }

    public Number getMaxItems() {
        return this.maxItems;
    }

    public Number getMinItems() {
        return this.minItems;
    }

    public Schema getContains() {
        return this.contains;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public Number getMinContains() {
        return this.minContains;
    }

    public Number getMaxContains() {
        return this.maxContains;
    }

    public Number getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinProperties() {
        return this.minProperties;
    }

    public Collection<String> getRequiredProperties() {
        return Collections.unmodifiableCollection(this.requiredProperties);
    }

    public boolean isRequired() {
        return this.required;
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Schema getUnevaluatedProperties() {
        return this.unevaluatedProperties;
    }

    public Map<String, Schema> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public Collection<String> getPatternPropertiesPatterns() {
        return Collections.unmodifiableCollection(this.patternPropertiesPatterns);
    }

    public Collection<Schema> getPatternPropertiesSchema() {
        return Collections.unmodifiableCollection(this.patternPropertiesSchemas);
    }

    public Map<String, Collection<String>> getDependentRequired() {
        return Collections.unmodifiableMap(this.dependentRequired);
    }

    public Map<String, Schema> getDependentSchemas() {
        return Collections.unmodifiableMap(this.dependentSchemas);
    }

    public Schema getPropertyNames() {
        return this.propertyNames;
    }

    public boolean hasConst() {
        return this.hasConst;
    }

    public Object getConst() {
        return this._const;
    }

    public List<Object> getEnums() {
        return this.enums == null ? null : Collections.unmodifiableList(this.enums);
    }

    public Collection<String> getExplicitTypes() {
        if (this.explicitTypes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.explicitTypes);
    }

    public Collection<Schema> getTypesSchema() {
        return Collections.unmodifiableCollection(this.typesSchema);
    }

    public Schema getIf() {
        return this._if;
    }

    public Schema getThen() {
        return this._then;
    }

    public Schema getElse() {
        return this._else;
    }

    public Collection<Schema> getAllOf() {
        return Collections.unmodifiableCollection(this.allOf);
    }

    public Collection<Schema> getAnyOf() {
        return this.anyOf == null ? null : Collections.unmodifiableCollection(this.anyOf);
    }

    public Collection<Schema> getOneOf() {
        return this.oneOf == null ? null : Collections.unmodifiableCollection(this.oneOf);
    }

    public Schema getNot() {
        return this.not;
    }

    public Schema getRef() {
        return this.ref;
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public Schema getRecursiveRef() {
        return this.recursiveRef;
    }

    public Map<String, Schema> getDynamicAnchorsInResource() {
        return Collections.unmodifiableMap(this.dynamicAnchorsInResource);
    }

    public URI getDynamicRefURI() {
        return this.dynamicRefURI;
    }

    public Schema getDefaultDynamicRef() {
        return this.defaultDynamicRef;
    }

    public String getDynamicAnchor() {
        return this.dynamicAnchor;
    }

    public Collection<String> getDisallow() {
        return Collections.unmodifiableCollection(this.disallow);
    }

    public Collection<Schema> getDisallowSchemas() {
        return Collections.unmodifiableCollection(this.disallowSchemas);
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public List<Object> getExamples() {
        return this.examples;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema getParent() {
        return this.parent;
    }

    protected void setParent(Schema parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Schemas may only have one parent");
        }
        this.parent = parent;
    }

    public URI getMetaSchema() {
        if (this.metaSchema == null) {
            this.metaSchema = MetaSchemaDetector.detectMetaSchema(this.baseObject);
        }
        return this.metaSchema;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        return this.uri.equals(((Schema)obj).getUri());
    }

    public Map<URI, Schema> getSubSchemas() {
        return Collections.unmodifiableMap(this.subSchemas);
    }

    public void validateExamples(Validator validator, Consumer<ValidationError> errorConsumer) {
        if (this.examples == null) {
            return;
        }
        for (int idx = 0; idx != this.examples.size(); ++idx) {
            URI resourceUri = URI.create("#" + this.resourceUri.getRawFragment());
            URI example = PathUtils.append(PathUtils.append(resourceUri, "examples"), String.valueOf(idx));
            validator.validate(this, this.baseObject, example, errorConsumer);
        }
    }

    public void validateExamplesRecursive(Validator validator, Consumer<ValidationError> errorConsumer) {
        LinkedHashMap<URI, Schema> unevaluated = new LinkedHashMap<URI, Schema>(this.subSchemas);
        LinkedHashSet<URI> evaluated = new LinkedHashSet<URI>();
        while (!unevaluated.isEmpty()) {
            Map.Entry next = unevaluated.entrySet().iterator().next();
            unevaluated.remove(next.getKey());
            for (Map.Entry<URI, Schema> entry : ((Schema)next.getValue()).getSubSchemas().entrySet()) {
                if (evaluated.contains(entry.getKey())) continue;
                unevaluated.put(entry.getKey(), entry.getValue());
            }
            ((Schema)next.getValue()).validateExamples(validator, errorConsumer);
            evaluated.add((URI)next.getKey());
        }
    }
}

