/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonPointer;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.MissingPathException;

public class PathUtils {
    private static final String ESCAPED_EMPTY = "~2";
    private static final Logger LOG = Logger.getLogger(PathUtils.class.getName());

    public static URI append(URI uri, String value) {
        String uriString = uri.toString();
        if (!uriString.contains("#")) {
            uriString = uriString + "#";
        }
        if (uriString.charAt(uriString.length() - 1) != '/') {
            uriString = uriString + "/";
        }
        value = value.replace("~", "~0").replace("/", "~1");
        if ((value = PathUtils.uriComponentEncode(value)).isEmpty()) {
            value = ESCAPED_EMPTY;
        }
        return URI.create(uriString + value);
    }

    static URI baseDocumentFromUri(URI path) {
        try {
            return new URI(path.getScheme(), path.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object fetchFromPath(Object document, String path) throws MissingPathException {
        if (path == null || path.isEmpty()) {
            return document;
        }
        path = path.replace(ESCAPED_EMPTY, "");
        JsonPointer jsonPointer = JsonPointer.compile((String)path);
        return PathUtils.queryFrom(jsonPointer, document);
    }

    private static Object queryFrom(JsonPointer jsonPointer, Object object) throws MissingPathException {
        if (jsonPointer.matches()) {
            return object;
        }
        if (object instanceof List) {
            int matchingIndex = jsonPointer.getMatchingIndex();
            List list = (List)object;
            if (matchingIndex < 0 || matchingIndex >= list.size()) {
                throw new MissingPathException(jsonPointer.toString());
            }
            return PathUtils.queryFrom(jsonPointer.tail(), list.get(matchingIndex));
        }
        if (object instanceof Map) {
            String property;
            Map map = (Map)object;
            try {
                property = URLDecoder.decode(jsonPointer.getMatchingProperty(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new MissingPathException(e);
            }
            if (!map.containsKey(property)) {
                throw new MissingPathException(jsonPointer.toString());
            }
            return PathUtils.queryFrom(jsonPointer.tail(), map.get(property));
        }
        throw new MissingPathException(jsonPointer.toString());
    }

    private static String uriComponentEncode(String value) {
        String encoded;
        try {
            encoded = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        encoded = encoded.replace("%24", "$");
        encoded = encoded.replace("%7E", "~");
        return encoded;
    }

    static URI resolve(URI base, URI child) {
        String baseWithoutFragment;
        if (child.getScheme() != null) {
            return child;
        }
        String childString = child.toString();
        String baseString = base.toString();
        int i = baseString.indexOf(35);
        String string = baseWithoutFragment = i == -1 ? baseString : baseString.substring(0, i);
        if (childString.charAt(0) == '#') {
            return URI.create(baseWithoutFragment + childString);
        }
        int i2 = baseWithoutFragment.lastIndexOf(47);
        if (i2 == -1 && (i2 = baseWithoutFragment.lastIndexOf(58)) == -1) {
            return child;
        }
        return URI.create(baseWithoutFragment.substring(0, i2 + 1) + (childString.charAt(0) == '/' ? childString.substring(1) : childString));
    }

    public static String fixUnescaped(String ref) {
        String fragment;
        int i = ref.indexOf(35);
        if (i == -1) {
            return ref;
        }
        String value = fragment = ref.substring(i + 1);
        value = value.replace("\t", "%09");
        value = value.replace("\n", "%0A");
        value = value.replace("\f", "%0C");
        value = value.replace("\r", "%0D");
        value = value.replace("!", "%21");
        value = value.replace("\"", "%22");
        value = value.replace("#", "%23");
        value = value.replace("+", "%2B");
        value = value.replace(":", "%3A");
        value = value.replace("<", "%3C");
        value = value.replace(">", "%3E");
        value = value.replace("?", "%3F");
        value = value.replace("\\", "%5C");
        value = value.replace("^", "%5E");
        value = value.replace("`", "%60");
        value = value.replace("{", "%7B");
        value = value.replace("|", "%7C");
        if ((value = value.replace("}", "%7D")).equals(fragment)) {
            return ref;
        }
        String ref2 = ref.substring(0, i + 1) + value;
        LOG.warning("Converting unescaped reference " + ref + " to JSON Schema legal $ref form " + ref2);
        return ref2;
    }

    static URI normalize(URI uri) {
        String uriString = uri.toString();
        int length = uriString.length();
        if (uriString.endsWith("#")) {
            return URI.create(uriString.substring(0, length - "#".length()));
        }
        if (uriString.endsWith("#/")) {
            return URI.create(uriString.substring(0, length - "#/".length()));
        }
        return uri;
    }
}

