/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.JsonPointer;
import com.ibm.icu.text.IDNA;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jimblackler.jsonschemafriend.InvalidRegexException;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.RegExPatternSupplier;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public class FormatChecker {
    private static final Collection<String> IDNA_DISALLOWED;
    private static final Pattern RELATIVE_JSON_POINTER_PATTERN;
    private static final Pattern NON_ASCII_CHARACTERS;
    private static final Pattern DURATION_CHARACTERS;
    private static final Pattern TIME_CHARACTERS;

    static String formatCheck(String string, String format, URI metaSchema, RegExPatternSupplier regExPatternSupplier, boolean validateFormats) {
        boolean preDraft2019;
        boolean preDraft4 = metaSchema.equals(MetaSchemaUris.DRAFT_3);
        boolean preDraft6 = preDraft4 || metaSchema.equals(MetaSchemaUris.DRAFT_4);
        boolean preDraft7 = preDraft6 || metaSchema.equals(MetaSchemaUris.DRAFT_6);
        boolean bl = preDraft2019 = preDraft7 || metaSchema.equals(MetaSchemaUris.DRAFT_7);
        if (!preDraft7 && (preDraft2019 || validateFormats)) {
            switch (format) {
                case "idn-hostname": {
                    for (int idx = 0; idx < string.length(); ++idx) {
                        char c = string.charAt(idx);
                        if (!IDNA_DISALLOWED.contains(String.valueOf(c))) continue;
                        return "Disallowed character " + c;
                    }
                    StringBuilder sb = new StringBuilder();
                    IDNA.Info info = new IDNA.Info();
                    IDNA.getUTS46Instance((int)88).nameToASCII((CharSequence)string, sb, info);
                    if (info.getErrors().isEmpty()) break;
                    return info.getErrors().toString();
                }
                case "relative-json-pointer": {
                    Matcher matcher = RELATIVE_JSON_POINTER_PATTERN.matcher(string);
                    if (!matcher.find() || matcher.groupCount() != 2) {
                        return "Relative JSON Pointer invalid";
                    }
                    String number = matcher.group(1);
                    if (!number.equals(String.valueOf(Integer.parseInt(number)))) {
                        return "Index number invalid";
                    }
                    String remain = matcher.group(2);
                    if ("#".equals(remain)) break;
                    return FormatChecker.checkJsonPointer(remain);
                }
            }
        }
        if (!preDraft6 && (preDraft2019 || validateFormats)) {
            switch (format) {
                case "json-pointer": {
                    return FormatChecker.checkJsonPointer(string);
                }
                case "iri-reference": 
                case "uri-reference": {
                    try {
                        new URI(string);
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "uri-template": {
                    try {
                        UriTemplate.buildFromTemplate((String)string);
                        break;
                    }
                    catch (MalformedUriTemplateException e) {
                        return e.getMessage();
                    }
                }
            }
        }
        if (preDraft2019 || validateFormats) {
            switch (format) {
                case "date": {
                    try {
                        DateTimeFormatter.ISO_DATE.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
                case "date-time": {
                    try {
                        DateTimeFormatter.ISO_DATE_TIME.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
                case "duration": {
                    if (DURATION_CHARACTERS.matcher(string).find()) break;
                    return "Failed DurationValidator";
                }
                case "email": 
                case "idn-email": {
                    if (EmailValidator.getInstance().isValid(string)) break;
                    return "Did not match";
                }
                case "hostname": 
                case "host-name": {
                    if (DomainValidator.getInstance().isValid(string)) break;
                    return "Failed DomainValidator";
                }
                case "ipv4": 
                case "ip-address": {
                    if (InetAddressValidator.getInstance().isValidInet4Address(string)) break;
                    return "Failed InetAddressValidator";
                }
                case "ipv6": {
                    if (!InetAddressValidator.getInstance().isValidInet6Address(string)) {
                        return "Failed InetAddressValidator";
                    }
                    if (NON_ASCII_CHARACTERS.matcher(string).find()) {
                        return "Non-ASCII characters found";
                    }
                    try {
                        InetAddress.getByName(string);
                        break;
                    }
                    catch (UnknownHostException e) {
                        return e.getMessage();
                    }
                }
                case "iri": {
                    URI uri1;
                    try {
                        uri1 = new URI(string);
                        if (!uri1.isAbsolute()) {
                            return "Not absolute";
                        }
                        String authority = uri1.getAuthority();
                        if (authority != null && InetAddressValidator.getInstance().isValidInet6Address(authority)) {
                            return "ipv6 not valid as host in an IRI";
                        }
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "regex": {
                    try {
                        regExPatternSupplier.newPattern(string);
                        break;
                    }
                    catch (InvalidRegexException ex) {
                        return ex.getMessage();
                    }
                }
                case "time": {
                    if (TIME_CHARACTERS.matcher(string).find()) break;
                    return "Failed TimeValidation";
                }
                case "uri": {
                    URI uri1;
                    try {
                        if (string.startsWith("//")) {
                            return "Protocol-relative";
                        }
                        uri1 = new URI(string);
                        if (!metaSchema.equals(MetaSchemaUris.DRAFT_3) && !uri1.isAbsolute()) {
                            return "Not absolute";
                        }
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "uuid": {
                    try {
                        UUID uuid = UUID.fromString(string);
                        if (!string.toLowerCase().equals(uuid.toString())) {
                            return "Not canonical";
                        }
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        return e.getMessage();
                    }
                }
            }
        }
        if (preDraft7) {
            switch (format) {
                case "time": {
                    try {
                        DateTimeFormatter.ISO_TIME.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
            }
        }
        return null;
    }

    private static String checkJsonPointer(String string) {
        if (string.replace("~0", "").replace("~1", "").contains("~")) {
            return "Not escaped";
        }
        try {
            JsonPointer jsonPointer = JsonPointer.compile((String)string);
            String readBack = jsonPointer.toString().replace("\\\\", "\\").replace("\\\"", "\"");
            if (readBack.equals(string)) {
                return null;
            }
            return "Not canonical: " + readBack;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    static {
        RELATIVE_JSON_POINTER_PATTERN = Pattern.compile("^(\\d+)(.*)$");
        NON_ASCII_CHARACTERS = Pattern.compile("[^\\x00-\\x7F]");
        DURATION_CHARACTERS = Pattern.compile("^P(\\d+W|T(\\d+H(\\d+M(\\d+S)?)?|\\d+M(\\d+S)?|\\d+S)|(\\d+D|\\d+M(\\d+D)?|\\d+Y(\\d+M(\\d+D)?)?)(T(\\d+H(\\d+M(\\d+S)?)?|\\d+M(\\d+S)?|\\d+S))?)$");
        TIME_CHARACTERS = Pattern.compile("^(2[0-3]|[01][0-9]):?([0-5][0-9]):?([0-5][0-9])(\\.\\d+)?([Z]|[+-](?:2[0-3]|[01][0-9])(?::?(?:[0-5][0-9]))?)$", 2);
        HashSet<String> set = new HashSet<String>();
        set.add("\u0640");
        set.add("\u07fa");
        set.add("\u302e");
        set.add("\u302f");
        set.add("\u3031");
        set.add("\u3032");
        set.add("\u3033");
        set.add("\u3034");
        set.add("\u3035");
        set.add("\u303b");
        IDNA_DISALLOWED = set;
    }
}

