/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.nio.charset.StandardCharsets;
import net.jimblackler.jsonschemafriend.InvalidRegexException;
import net.jimblackler.jsonschemafriend.RegExPattern;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Regex;
import org.joni.exception.SyntaxException;

public class JoniRegExPattern
implements RegExPattern {
    private final Regex regex;
    private final String pattern;

    public JoniRegExPattern(String pattern) throws InvalidRegexException {
        this.pattern = pattern;
        byte[] bytes = pattern.getBytes(StandardCharsets.UTF_8);
        try {
            this.regex = new Regex(bytes, 0, bytes.length, 0, (Encoding)UTF8Encoding.INSTANCE);
        }
        catch (SyntaxException e) {
            throw new InvalidRegexException((Exception)((Object)e));
        }
    }

    @Override
    public boolean matches(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return this.regex.matcher(bytes).search(0, bytes.length, 0) != -1;
    }

    public String toString() {
        return this.pattern;
    }
}

