/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.AnyOfError;
import net.jimblackler.jsonschemafriend.CachedRegExPatternSupplier;
import net.jimblackler.jsonschemafriend.ComparableUtils;
import net.jimblackler.jsonschemafriend.ConstError;
import net.jimblackler.jsonschemafriend.ContentEncodingError;
import net.jimblackler.jsonschemafriend.DependencyError;
import net.jimblackler.jsonschemafriend.DisallowError;
import net.jimblackler.jsonschemafriend.DivisibleByError;
import net.jimblackler.jsonschemafriend.EnumError;
import net.jimblackler.jsonschemafriend.ExclusiveMaximumError;
import net.jimblackler.jsonschemafriend.ExclusiveMinimumError;
import net.jimblackler.jsonschemafriend.FalseSchemaError;
import net.jimblackler.jsonschemafriend.FormatChecker;
import net.jimblackler.jsonschemafriend.FormatError;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.InvalidRegexException;
import net.jimblackler.jsonschemafriend.JoniRegExPattern;
import net.jimblackler.jsonschemafriend.ListValidationException;
import net.jimblackler.jsonschemafriend.MaxContainsError;
import net.jimblackler.jsonschemafriend.MaxItemsError;
import net.jimblackler.jsonschemafriend.MaxLengthError;
import net.jimblackler.jsonschemafriend.MaxPropertiesError;
import net.jimblackler.jsonschemafriend.MaximumError;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.MinContainsError;
import net.jimblackler.jsonschemafriend.MinItemsError;
import net.jimblackler.jsonschemafriend.MinLengthError;
import net.jimblackler.jsonschemafriend.MinPropertiesError;
import net.jimblackler.jsonschemafriend.MinimumError;
import net.jimblackler.jsonschemafriend.MissingPathException;
import net.jimblackler.jsonschemafriend.MissingPropertyError;
import net.jimblackler.jsonschemafriend.MultipleError;
import net.jimblackler.jsonschemafriend.NotError;
import net.jimblackler.jsonschemafriend.OneOfError;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.PatternError;
import net.jimblackler.jsonschemafriend.RegExPatternSupplier;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.TypeDisallowedError;
import net.jimblackler.jsonschemafriend.TypeError;
import net.jimblackler.jsonschemafriend.UnexpectedTypeError;
import net.jimblackler.jsonschemafriend.UniqueItemsError;
import net.jimblackler.jsonschemafriend.Utils;
import net.jimblackler.jsonschemafriend.ValidationError;
import net.jimblackler.jsonschemafriend.ValidationException;

public class Validator {
    private static final Logger LOG = Logger.getLogger(Validator.class.getName());
    private final RegExPatternSupplier regExPatternSupplier;
    private final Predicate<? super ValidationError> errorFilter;
    private final boolean validateFormats;

    public Validator() {
        this(validationError -> true);
    }

    public Validator(boolean validateFormats) {
        this(new CachedRegExPatternSupplier(JoniRegExPattern::new), validationError -> true, validateFormats);
    }

    public Validator(Predicate<? super ValidationError> errorFilter) {
        this(new CachedRegExPatternSupplier(JoniRegExPattern::new), errorFilter);
    }

    public Validator(RegExPatternSupplier regExPatternSupplier, Predicate<? super ValidationError> errorFilter) {
        this(regExPatternSupplier, errorFilter, false);
    }

    public Validator(RegExPatternSupplier regExPatternSupplier, Predicate<? super ValidationError> errorFilter, boolean validateFormats) {
        this.regExPatternSupplier = regExPatternSupplier;
        this.errorFilter = errorFilter;
        this.validateFormats = validateFormats;
    }

    public static Object getObject(Object document, URI uri) throws MissingPathException {
        String query = uri.getQuery();
        Object object = query == null ? PathUtils.fetchFromPath(document, uri.getRawFragment()) : query;
        return object;
    }

    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer) {
        this.validate(schema, document, uri, errorConsumer, property -> {}, item -> {}, new HashMap<String, Schema>());
    }

    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer, Map<String, Schema> dynamicAnchors) {
        this.validate(schema, document, uri, errorConsumer, property -> {}, item -> {}, dynamicAnchors);
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer, Consumer<String> propertyConsumer, Consumer<Integer> itemConsumer, Map<String, Schema> dynamicAnchorsIn) {
        List<Object> enums;
        Schema not;
        ArrayList errors;
        Collection<Schema> oneOf;
        URI dynamicRefURI;
        Schema recursiveRef1;
        Schema ref;
        Object object;
        try {
            object = Validator.getObject(document, uri);
        }
        catch (MissingPathException e) {
            throw new IllegalStateException(e);
        }
        Consumer<ValidationError> error = validationError -> {
            if (this.errorFilter.test((ValidationError)validationError)) {
                errorConsumer.accept((ValidationError)validationError);
            }
        };
        if (schema.isFalse().booleanValue()) {
            error.accept(new FalseSchemaError(uri, document, schema));
            return;
        }
        HashSet evaluatedProperties = new HashSet();
        Consumer<String> selfPropertyHandler = property -> {
            propertyConsumer.accept((String)property);
            evaluatedProperties.add(property);
        };
        HashSet evaluatedItems = new HashSet();
        Consumer<Integer> selfItemHandler = property -> {
            itemConsumer.accept((Integer)property);
            evaluatedItems.add(property);
        };
        HashMap<String, Schema> dynamicAnchors = new HashMap<String, Schema>(dynamicAnchorsIn);
        for (Map.Entry<String, Schema> entry : schema.getDynamicAnchorsInResource().entrySet()) {
            String anchor = entry.getKey();
            if (dynamicAnchors.containsKey(anchor)) continue;
            dynamicAnchors.put(anchor, entry.getValue());
        }
        if (schema.isRecursiveAnchor() && !dynamicAnchors.containsKey(null)) {
            dynamicAnchors.put(null, schema);
        }
        Schema _if = schema.getIf();
        Schema _then = schema.getThen();
        Schema _else = schema.getElse();
        if (_if != null) {
            Schema useSchema;
            ArrayList errors2 = new ArrayList();
            HashSet unevaluatedProperties = new HashSet();
            HashSet unevaluatedItems = new HashSet();
            this.validate(_if, document, uri, errors2::add, unevaluatedProperties::add, unevaluatedItems::add, dynamicAnchors);
            if (errors2.isEmpty()) {
                useSchema = _then;
                unevaluatedProperties.forEach(selfPropertyHandler);
                unevaluatedItems.forEach(selfItemHandler);
            } else {
                useSchema = _else;
            }
            if (useSchema != null) {
                this.validate(useSchema, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
            }
        }
        if ((ref = schema.getRef()) != null) {
            this.validate(ref, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
        }
        if ((recursiveRef1 = schema.getRecursiveRef()) != null) {
            this.validate(recursiveRef1.isRecursiveAnchor() ? (Schema)dynamicAnchors.get(null) : recursiveRef1, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
        }
        if ((dynamicRefURI = schema.getDynamicRefURI()) != null) {
            Object toValidate;
            String anchor = dynamicRefURI.getFragment();
            Object object2 = toValidate = schema.getDynamicAnchorsInResource().containsKey(anchor) ? (Schema)dynamicAnchors.get(anchor) : schema.getDefaultDynamicRef();
            if (anchor.equals(((Schema)toValidate).getDynamicAnchor())) {
                toValidate = (Schema)dynamicAnchors.get(anchor);
            }
            if (toValidate == null) {
                LOG.warning("Could not resolve dynamic anchor: " + anchor);
            } else {
                this.validate((Schema)toValidate, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
            }
        }
        Collection<Schema> allOf = schema.getAllOf();
        for (Schema schema1 : allOf) {
            this.validate(schema1, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
        }
        Collection<Schema> anyOf = schema.getAnyOf();
        if (anyOf != null) {
            int numberPassed = 0;
            ArrayList<List<ValidationError>> allErrors = new ArrayList<List<ValidationError>>();
            for (Schema schema2 : anyOf) {
                ArrayList errors3 = new ArrayList();
                HashSet unevaluatedProperties = new HashSet();
                HashSet unevaluatedItems = new HashSet();
                this.validate(schema2, document, uri, errors3::add, unevaluatedProperties::add, unevaluatedItems::add, dynamicAnchors);
                if (errors3.isEmpty()) {
                    ++numberPassed;
                    unevaluatedProperties.forEach(selfPropertyHandler);
                    unevaluatedItems.forEach(selfItemHandler);
                }
                allErrors.add(errors3);
            }
            if (numberPassed == 0) {
                error.accept(new AnyOfError(uri, document, allErrors, schema));
            }
        }
        if ((oneOf = schema.getOneOf()) != null) {
            ArrayList<Schema> passed = new ArrayList<Schema>();
            ArrayList<List<ValidationError>> allErrors = new ArrayList<List<ValidationError>>();
            for (Schema schema1 : oneOf) {
                errors = new ArrayList();
                ArrayList unevaluatedProperties = new ArrayList();
                ArrayList unevaluatedItems = new ArrayList();
                this.validate(schema1, document, uri, errors::add, unevaluatedProperties::add, unevaluatedItems::add, dynamicAnchors);
                if (errors.isEmpty()) {
                    passed.add(schema1);
                    unevaluatedProperties.forEach(selfPropertyHandler);
                    unevaluatedItems.forEach(selfItemHandler);
                }
                allErrors.add(errors);
            }
            if (passed.size() != 1) {
                error.accept(new OneOfError(uri, document, passed, allErrors, schema));
            }
        }
        if ((not = schema.getNot()) != null) {
            ArrayList errors4 = new ArrayList();
            this.validate(not, document, uri, errors4::add, dynamicAnchors);
            if (errors4.isEmpty()) {
                error.accept(new NotError(uri, document, schema));
            }
        }
        Collection<Schema> disallowSchemas = schema.getDisallowSchemas();
        for (Schema disallowSchema : disallowSchemas) {
            errors = new ArrayList();
            this.validate(disallowSchema, document, uri, errors::add, selfPropertyHandler, selfItemHandler, dynamicAnchors);
            if (!errors.isEmpty()) continue;
            error.accept(new DisallowError(uri, document, schema));
        }
        Number number = schema.getMultipleOf();
        Number minimum = schema.getMinimum();
        Number maximum = schema.getMaximum();
        Number exclusiveMinimum = schema.getExclusiveMinimum();
        Number exclusiveMaximum = schema.getExclusiveMaximum();
        boolean exclusiveMinimumBoolean = schema.isExclusiveMinimumBoolean();
        boolean exclusiveMaximumBoolean = schema.isExclusiveMaximumBoolean();
        Collection<String> disallow = schema.getDisallow();
        if (object instanceof Number) {
            Number number2 = (Number)object;
            if (number != null && new BigDecimal(number2.toString()).remainder(new BigDecimal(number.toString())).compareTo(BigDecimal.ZERO) != 0) {
                error.accept(new MultipleError(uri, document, schema));
            }
            if (maximum != null && (exclusiveMaximumBoolean ? number2.doubleValue() >= maximum.doubleValue() : number2.doubleValue() > maximum.doubleValue())) {
                error.accept(new MaximumError(uri, document, schema));
            }
            if (exclusiveMaximum != null && number2.doubleValue() >= exclusiveMaximum.doubleValue()) {
                error.accept(new ExclusiveMaximumError(uri, document, schema));
            }
            if (minimum != null && (exclusiveMinimumBoolean ? number2.doubleValue() <= minimum.doubleValue() : number2.doubleValue() < minimum.doubleValue())) {
                error.accept(new MinimumError(uri, document, schema));
            }
            if (exclusiveMinimum != null && number2.doubleValue() <= exclusiveMinimum.doubleValue()) {
                error.accept(new ExclusiveMinimumError(uri, document, schema));
            }
            HashSet<String> okTypes = new HashSet<String>();
            okTypes.add("number");
            try {
                boolean preDraft5;
                boolean bl = preDraft5 = MetaSchemaUris.DRAFT_3.equals(schema.getMetaSchema()) || MetaSchemaUris.DRAFT_4.equals(schema.getMetaSchema());
                if (preDraft5) {
                    if (!(number2 instanceof Float) && !(number2 instanceof Double)) {
                        okTypes.add("integer");
                    }
                } else {
                    BigDecimal bigDecimal = new BigDecimal(number2.toString());
                    if (bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
                        okTypes.add("integer");
                    }
                }
            }
            catch (NumberFormatException preDraft5) {
                // empty catch block
            }
            this.typeCheck(schema, document, uri, okTypes, disallow, error);
            Number divisibleBy = schema.getDivisibleBy();
            if (divisibleBy != null && number2.doubleValue() / divisibleBy.doubleValue() % 1.0 != 0.0) {
                error.accept(new DivisibleByError(uri, document, schema));
            }
        } else if (object instanceof String) {
            boolean preDraft2019;
            String string;
            String string2;
            String patternString;
            String string3 = (String)object;
            int unicodeCompliantLength = string3.codePointCount(0, string3.length());
            Number minLength = schema.getMinLength();
            Number maxLength = schema.getMaxLength();
            if (maxLength != null && unicodeCompliantLength > maxLength.intValue()) {
                error.accept(new MaxLengthError(uri, document, schema));
            }
            if (minLength != null && unicodeCompliantLength < minLength.intValue()) {
                error.accept(new MinLengthError(uri, document, schema));
            }
            if ((patternString = schema.getPattern()) != null) {
                try {
                    if (!this.regExPatternSupplier.newPattern(patternString).matches(string3)) {
                        error.accept(new PatternError(uri, document, schema));
                    }
                }
                catch (InvalidRegexException invalidRegexException) {
                    LOG.warning("Invalid regex " + patternString);
                }
            }
            if ((string2 = schema.getFormat()) != null && (string = FormatChecker.formatCheck(string3, string2, schema.getMetaSchema(), this.regExPatternSupplier, this.validateFormats)) != null) {
                error.accept(new FormatError(uri, document, schema, string));
            }
            String string4 = string3;
            String contentEncoding = schema.getContentEncoding();
            boolean preDraft5 = MetaSchemaUris.DRAFT_3.equals(schema.getMetaSchema()) || MetaSchemaUris.DRAFT_4.equals(schema.getMetaSchema());
            boolean bl = preDraft2019 = preDraft5 || MetaSchemaUris.DRAFT_6.equals(schema.getMetaSchema()) || MetaSchemaUris.DRAFT_7.equals(schema.getMetaSchema());
            if (preDraft2019) {
                String string5;
                if ("base64".equals(contentEncoding)) {
                    Base64.Decoder decoder = Base64.getUrlDecoder();
                    byte[] decoded = null;
                    try {
                        decoded = decoder.decode(string3);
                    }
                    catch (IllegalArgumentException e) {
                        error.accept(new ContentEncodingError(uri, document, schema, e.getMessage()));
                    }
                    if (decoded != null) {
                        String string6 = new String(decoded, StandardCharsets.UTF_8);
                    }
                }
                if ("application/json".equals(string5 = schema.getContentMediaType())) {
                    try {
                        void var40_76;
                        new ObjectMapper().readValue((String)var40_76, Object.class);
                    }
                    catch (JsonProcessingException e) {
                        error.accept(new ContentEncodingError(uri, document, schema, e.getMessage()));
                    }
                }
            }
            this.typeCheck(schema, document, uri, Utils.setOf("string"), disallow, errorConsumer);
        } else if (object instanceof Boolean) {
            this.typeCheck(schema, document, uri, Utils.setOf("boolean"), disallow, errorConsumer);
        } else if (object instanceof List) {
            Number minItems;
            Number number3;
            Schema schema3;
            Object contains;
            Schema _items;
            this.typeCheck(schema, document, uri, Utils.setOf("array"), disallow, errorConsumer);
            Collection jsonArray = (Collection)object;
            List<Schema> prefixItems = schema.getPrefixItems();
            int itemStart = 0;
            if (prefixItems != null) {
                itemStart = prefixItems.size();
                for (int idx = 0; idx != Math.min(prefixItems.size(), jsonArray.size()); ++idx) {
                    this.validate(prefixItems.get(idx), document, PathUtils.append(uri, String.valueOf(idx)), errorConsumer, dynamicAnchors);
                    selfItemHandler.accept(idx);
                }
            } else {
                List<Schema> itemsTuple = schema.getItemsTuple();
                if (itemsTuple != null) {
                    void var39_65;
                    Schema additionalItems = schema.getAdditionalItems();
                    if (jsonArray.size() > itemsTuple.size() && additionalItems != null) {
                        void var39_63;
                        int n = itemsTuple.size();
                        while (var39_63 != jsonArray.size()) {
                            this.validate(additionalItems, document, PathUtils.append(uri, String.valueOf((int)var39_63)), errorConsumer, dynamicAnchors);
                            selfItemHandler.accept((int)var39_63);
                            ++var39_63;
                        }
                    }
                    boolean bl = false;
                    while (var39_65 != Math.min(itemsTuple.size(), jsonArray.size())) {
                        this.validate(itemsTuple.get((int)var39_65), document, PathUtils.append(uri, String.valueOf((int)var39_65)), errorConsumer, dynamicAnchors);
                        selfItemHandler.accept((int)var39_65);
                        ++var39_65;
                    }
                }
            }
            if ((_items = schema.getItems()) != null) {
                for (int idx = itemStart; idx < jsonArray.size(); ++idx) {
                    this.validate(_items, document, PathUtils.append(uri, String.valueOf(idx)), errorConsumer, dynamicAnchors);
                    selfItemHandler.accept(idx);
                }
            }
            if ((contains = schema.getContains()) != null) {
                Number maxContains;
                void var39_67;
                void var40_78;
                boolean bl = false;
                boolean bl2 = false;
                while (var40_78 != jsonArray.size()) {
                    ArrayList errors5 = new ArrayList();
                    this.validate((Schema)contains, document, PathUtils.append(uri, String.valueOf((int)var40_78)), errors5::add, dynamicAnchors);
                    if (errors5.isEmpty()) {
                        selfItemHandler.accept((int)var40_78);
                        ++var39_67;
                    }
                    ++var40_78;
                }
                Number number4 = schema.getMinContains();
                if (var39_67 < (number4 == null ? 1 : number4.intValue())) {
                    error.accept(new MinContainsError(uri, document, schema));
                }
                if ((maxContains = schema.getMaxContains()) != null && var39_67 > maxContains.intValue()) {
                    error.accept(new MaxContainsError(uri, document, schema));
                }
            }
            if ((schema3 = schema.getUnevaluatedItems()) != null) {
                void var40_81;
                boolean bl = false;
                while (var40_81 != jsonArray.size()) {
                    if (!evaluatedItems.contains((int)var40_81)) {
                        this.validate(schema3, document, PathUtils.append(uri, String.valueOf((int)var40_81)), errorConsumer, dynamicAnchors);
                        selfItemHandler.accept((int)var40_81);
                    }
                    ++var40_81;
                }
            }
            if ((number3 = schema.getMaxItems()) != null && jsonArray.size() > number3.intValue()) {
                error.accept(new MaxItemsError(uri, document, schema));
            }
            if ((minItems = schema.getMinItems()) != null && jsonArray.size() < minItems.intValue()) {
                error.accept(new MinItemsError(uri, document, schema));
            }
            if (schema.isUniqueItems()) {
                HashSet<Object> items = new HashSet<Object>();
                for (Object e : jsonArray) {
                    if (items.add(ComparableUtils.makeComparable(e))) continue;
                    error.accept(new UniqueItemsError(uri, document, schema));
                }
            }
        } else if (object instanceof Map) {
            Schema schema4;
            Number minProperties;
            this.typeCheck(schema, document, uri, Utils.setOf("object"), disallow, errorConsumer);
            Map jsonObject = (Map)object;
            Number maxProperties = schema.getMaxProperties();
            if (maxProperties != null && jsonObject.size() > maxProperties.intValue()) {
                error.accept(new MaxPropertiesError(uri, document, schema));
            }
            if ((minProperties = schema.getMinProperties()) != null && jsonObject.size() < minProperties.intValue()) {
                error.accept(new MinPropertiesError(uri, document, schema));
            }
            Collection<String> requiredProperties = schema.getRequiredProperties();
            for (String string : requiredProperties) {
                if (jsonObject.containsKey(string)) continue;
                error.accept(new MissingPropertyError(uri, document, string, schema));
            }
            Map<String, Schema> _properties = schema.getProperties();
            for (Map.Entry<String, Schema> entry : _properties.entrySet()) {
                String property3;
                if (!entry.getValue().isRequired() || jsonObject.containsKey(property3 = entry.getKey())) continue;
                error.accept(new MissingPropertyError(uri, document, property3, schema));
            }
            HashSet hashSet = new HashSet(jsonObject.keySet());
            Collection<String> collection = schema.getPatternPropertiesPatterns();
            Collection<Schema> patternPropertiesSchema = schema.getPatternPropertiesSchema();
            for (Object property4 : jsonObject.keySet()) {
                if (_properties.containsKey(property4)) {
                    this.validate(_properties.get(property4), document, PathUtils.append(uri, (String)property4), errorConsumer, dynamicAnchors);
                    hashSet.remove(property4);
                    selfPropertyHandler.accept((String)property4);
                }
                Iterator<String> iterator = collection.iterator();
                Iterator<Schema> it1 = patternPropertiesSchema.iterator();
                while (iterator.hasNext()) {
                    String pattern1 = iterator.next();
                    Schema schema1 = it1.next();
                    try {
                        if (!this.regExPatternSupplier.newPattern(pattern1).matches((String)property4)) continue;
                        this.validate(schema1, document, PathUtils.append(uri, (String)property4), errorConsumer, dynamicAnchors);
                        hashSet.remove(property4);
                        selfPropertyHandler.accept((String)property4);
                    }
                    catch (InvalidRegexException e) {
                        LOG.warning("Invalid regex: " + e.getMessage());
                    }
                }
                Schema propertyNames = schema.getPropertyNames();
                if (propertyNames == null) continue;
                try {
                    URI propertyPath = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), (String)property4, uri.getRawFragment());
                    this.validate(propertyNames, document, propertyPath, errorConsumer, dynamicAnchors);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
            Map<String, Schema> schemaDependencies = schema.getDependentSchemas();
            for (Map.Entry entry : schemaDependencies.entrySet()) {
                String property5 = (String)entry.getKey();
                if (!jsonObject.containsKey(property5)) continue;
                this.validate((Schema)entry.getValue(), document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, dynamicAnchors);
            }
            Schema additionalProperties = schema.getAdditionalProperties();
            if (additionalProperties != null) {
                for (String property2 : hashSet) {
                    this.validate(additionalProperties, document, PathUtils.append(uri, property2), errorConsumer, dynamicAnchors);
                    selfPropertyHandler.accept(property2);
                }
            }
            if ((schema4 = schema.getUnevaluatedProperties()) != null) {
                HashSet remainingProperties2 = new HashSet(jsonObject.keySet());
                remainingProperties2.removeAll(evaluatedProperties);
                for (String property6 : remainingProperties2) {
                    this.validate(schema4, document, PathUtils.append(uri, property6), errorConsumer, dynamicAnchors);
                    selfPropertyHandler.accept(property6);
                }
            }
            Map<String, Collection<String>> dependencies = schema.getDependentRequired();
            for (Map.Entry<String, Collection<String>> entry : dependencies.entrySet()) {
                String property7 = entry.getKey();
                if (!jsonObject.containsKey(property7)) continue;
                Collection<String> _dependencies = entry.getValue();
                for (String dependency : _dependencies) {
                    if (jsonObject.containsKey(dependency)) continue;
                    error.accept(new DependencyError(uri, document, property7, dependency, schema));
                }
            }
        } else if (object == null) {
            this.typeCheck(schema, document, uri, Utils.setOf("null"), disallow, errorConsumer);
        } else {
            error.accept(new UnexpectedTypeError(uri, document, object, schema));
        }
        if (schema.hasConst() && !ComparableUtils.makeComparable(schema.getConst()).equals(ComparableUtils.makeComparable(object))) {
            error.accept(new ConstError(uri, document, schema));
        }
        if ((enums = schema.getEnums()) != null) {
            boolean matchedOne = false;
            Object o = ComparableUtils.makeComparable(object);
            for (Object value : enums) {
                if (!o.equals(ComparableUtils.makeComparable(value))) continue;
                matchedOne = true;
                break;
            }
            if (!matchedOne) {
                error.accept(new EnumError(uri, document, schema));
            }
        }
    }

    private void typeCheck(Schema schema, Object document, URI path, Set<String> types, Collection<String> disallow, Consumer<? super ValidationError> errorConsumer) {
        Set<String> typesIn;
        Collection<String> explicitTypes;
        if (!disallow.isEmpty()) {
            HashSet<String> typesIn0 = new HashSet<String>(types);
            typesIn0.retainAll(disallow);
            if (!typesIn0.isEmpty()) {
                errorConsumer.accept(new TypeDisallowedError(path, document, typesIn0, schema));
            }
        }
        if ((explicitTypes = schema.getExplicitTypes()) == null) {
            return;
        }
        Collection<Schema> typesSchema = schema.getTypesSchema();
        for (Schema schema1 : typesSchema) {
            ArrayList errors = new ArrayList();
            this.validate(schema1, document, path, errors::add);
            if (!errors.isEmpty()) continue;
            return;
        }
        if (explicitTypes.contains("any")) {
            return;
        }
        if (explicitTypes.isEmpty() && typesSchema.isEmpty()) {
            typesIn = types;
        } else {
            typesIn = new HashSet<String>(types);
            typesIn.retainAll(explicitTypes);
        }
        if (!typesIn.isEmpty()) {
            return;
        }
        errorConsumer.accept(new TypeError(path, document, explicitTypes, types, schema));
    }

    public void validate(Schema schema, File file) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, file, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, URI uri) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, uri, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, URL url) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, url, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, Object document, URI uri) throws ValidationException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, document, uri, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, Object document) throws ValidationException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, document, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validateJson(Schema schema, String string) throws ValidationException {
        try {
            this.validate(schema, new ObjectMapper().readValue(string, Object.class));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void validate(Schema schema, InputStream inputStream) throws ValidationException, IOException {
        this.validate(schema, new ObjectMapper().readValue(inputStream, Object.class));
    }

    public void validate(Schema schema, URL url, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, new ObjectMapper().readValue(url.openStream(), Object.class), errorConsumer);
    }

    public void validate(Schema schema, URI uri, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, uri.toURL(), errorConsumer);
    }

    public void validate(Schema schema, File file, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, file.toURI(), errorConsumer);
    }

    public void validate(Schema schema, Object document, Consumer<ValidationError> errorConsumer) {
        this.validate(schema, document, URI.create(""), errorConsumer);
    }

    public Map<String, Object> validateWithOutput(Schema schema, Object document) throws GenerationException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("valid", true);
        output.put("keywordLocation", schema.getUri().toString());
        output.put("absoluteKeywordLocation", schema.getResourceUri().toString());
        output.put("instanceLocation", "");
        this.validate(schema, document, (ValidationError validationError) -> {
            output.put("valid", false);
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            error.put("valid", false);
            error.put("error", validationError.getMessage());
            Schema failedSubSchema = validationError.getSchema();
            error.put("keywordLocation", failedSubSchema.getUri().toString());
            error.put("absoluteKeywordLocation", failedSubSchema.getResourceUri().toString());
            String rawFragment = validationError.getUri().getRawFragment();
            error.put("instanceLocation", "#" + (rawFragment == null ? "" : rawFragment));
            if (!output.containsKey("errors")) {
                output.put("errors", new ArrayList());
            }
            ((Collection)output.get("errors")).add(error);
        });
        return output;
    }
}

