/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.AnyOfError;
import net.jimblackler.jsonschemafriend.CachedRegExPatternSupplier;
import net.jimblackler.jsonschemafriend.ComparableUtils;
import net.jimblackler.jsonschemafriend.ConstError;
import net.jimblackler.jsonschemafriend.ContentEncodingError;
import net.jimblackler.jsonschemafriend.DependencyError;
import net.jimblackler.jsonschemafriend.DisallowError;
import net.jimblackler.jsonschemafriend.DivisibleByError;
import net.jimblackler.jsonschemafriend.DocumentUtils;
import net.jimblackler.jsonschemafriend.EnumError;
import net.jimblackler.jsonschemafriend.ExclusiveMaximumError;
import net.jimblackler.jsonschemafriend.ExclusiveMinimumError;
import net.jimblackler.jsonschemafriend.FalseSchemaError;
import net.jimblackler.jsonschemafriend.FormatChecker;
import net.jimblackler.jsonschemafriend.FormatError;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.InvalidRegexException;
import net.jimblackler.jsonschemafriend.JavaRegExPattern;
import net.jimblackler.jsonschemafriend.ListValidationException;
import net.jimblackler.jsonschemafriend.MaxContainsError;
import net.jimblackler.jsonschemafriend.MaxItemsError;
import net.jimblackler.jsonschemafriend.MaxLengthError;
import net.jimblackler.jsonschemafriend.MaxPropertiesError;
import net.jimblackler.jsonschemafriend.MaximumError;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.MinContainsError;
import net.jimblackler.jsonschemafriend.MinItemsError;
import net.jimblackler.jsonschemafriend.MinLengthError;
import net.jimblackler.jsonschemafriend.MinPropertiesError;
import net.jimblackler.jsonschemafriend.MinimumError;
import net.jimblackler.jsonschemafriend.MissingPathException;
import net.jimblackler.jsonschemafriend.MissingPropertyError;
import net.jimblackler.jsonschemafriend.MultipleError;
import net.jimblackler.jsonschemafriend.NotError;
import net.jimblackler.jsonschemafriend.OneOfError;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.PatternError;
import net.jimblackler.jsonschemafriend.RegExPatternSupplier;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.SchemaStore;
import net.jimblackler.jsonschemafriend.TypeDisallowedError;
import net.jimblackler.jsonschemafriend.TypeError;
import net.jimblackler.jsonschemafriend.UnexpectedTypeError;
import net.jimblackler.jsonschemafriend.UniqueItemsError;
import net.jimblackler.jsonschemafriend.Utils;
import net.jimblackler.jsonschemafriend.ValidationError;
import net.jimblackler.jsonschemafriend.ValidationException;

public class Validator {
    private static final Logger LOG = Logger.getLogger(Validator.class.getName());
    private final RegExPatternSupplier regExPatternSupplier;
    private final Predicate<? super ValidationError> errorFilter;

    public Validator() {
        this(validationError -> true);
    }

    public Validator(Predicate<? super ValidationError> errorFilter) {
        this(new CachedRegExPatternSupplier(JavaRegExPattern::new), errorFilter);
    }

    public Validator(RegExPatternSupplier regExPatternSupplier, Predicate<? super ValidationError> errorFilter) {
        this.regExPatternSupplier = regExPatternSupplier;
        this.errorFilter = errorFilter;
    }

    public static Object getObject(Object document, URI uri) throws MissingPathException {
        String query = uri.getQuery();
        Object object = query == null ? PathUtils.fetchFromPath(document, uri.getRawFragment()) : query;
        return object;
    }

    public static void validate(Schema schema, InputStream inputStream, Consumer<ValidationError> errorConsumer) {
        Validator.validate(schema, inputStream, errorConsumer);
    }

    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer) {
        this.validate(schema, document, uri, errorConsumer, property -> {}, item -> {}, null);
    }

    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer, Schema recursiveRef) {
        this.validate(schema, document, uri, errorConsumer, property -> {}, item -> {}, recursiveRef);
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Schema schema, Object document, URI uri, Consumer<ValidationError> errorConsumer, Consumer<String> propertyConsumer, Consumer<Integer> itemConsumer, Schema recursiveRef) {
        List<Object> enums;
        Schema not;
        ArrayList errors;
        Collection<Schema> oneOf;
        Schema ref;
        Object object;
        try {
            object = Validator.getObject(document, uri);
        }
        catch (MissingPathException e) {
            throw new IllegalStateException(e);
        }
        Consumer<ValidationError> error = validationError -> {
            if (this.errorFilter.test((ValidationError)validationError)) {
                errorConsumer.accept((ValidationError)validationError);
            }
        };
        if (schema.isFalse().booleanValue()) {
            error.accept(new FalseSchemaError(uri, document, schema));
            return;
        }
        HashSet evaluatedProperties = new HashSet();
        Consumer<String> selfPropertyHandler = property -> {
            propertyConsumer.accept((String)property);
            evaluatedProperties.add(property);
        };
        HashSet evaluatedItems = new HashSet();
        Consumer<Integer> selfItemHandler = property -> {
            itemConsumer.accept((Integer)property);
            evaluatedItems.add(property);
        };
        Schema recursiveRef1 = schema.getRecursiveRef();
        if (recursiveRef1 != null) {
            if (recursiveRef != null && recursiveRef1.isRecursiveAnchor()) {
                this.validate(recursiveRef, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, null);
            } else {
                this.validate(recursiveRef1, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, null);
            }
        }
        if (recursiveRef == null && schema.isRecursiveAnchor()) {
            recursiveRef = schema;
        }
        Schema _if = schema.getIf();
        Schema _then = schema.getThen();
        Schema _else = schema.getElse();
        if (_if != null) {
            Schema useSchema;
            ArrayList errors2 = new ArrayList();
            HashSet unevaluatedProperties = new HashSet();
            HashSet unevaluatedItems = new HashSet();
            this.validate(_if, document, uri, errors2::add, unevaluatedProperties::add, unevaluatedItems::add, recursiveRef);
            if (errors2.isEmpty()) {
                useSchema = _then;
                unevaluatedProperties.forEach(selfPropertyHandler);
                unevaluatedItems.forEach(selfItemHandler);
            } else {
                useSchema = _else;
            }
            if (useSchema != null) {
                this.validate(useSchema, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, recursiveRef);
            }
        }
        if ((ref = schema.getRef()) != null) {
            this.validate(ref, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, recursiveRef);
        }
        Collection<Schema> allOf = schema.getAllOf();
        for (Schema schema1 : allOf) {
            this.validate(schema1, document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, recursiveRef);
        }
        Collection<Schema> anyOf = schema.getAnyOf();
        if (anyOf != null) {
            int numberPassed = 0;
            ArrayList<List<ValidationError>> allErrors = new ArrayList<List<ValidationError>>();
            for (Schema schema2 : anyOf) {
                ArrayList errors3 = new ArrayList();
                HashSet unevaluatedProperties = new HashSet();
                HashSet unevaluatedItems = new HashSet();
                this.validate(schema2, document, uri, errors3::add, unevaluatedProperties::add, unevaluatedItems::add, recursiveRef);
                if (errors3.isEmpty()) {
                    ++numberPassed;
                    unevaluatedProperties.forEach(selfPropertyHandler);
                    unevaluatedItems.forEach(selfItemHandler);
                }
                allErrors.add(errors3);
            }
            if (numberPassed == 0) {
                error.accept(new AnyOfError(uri, document, allErrors, schema));
            }
        }
        if ((oneOf = schema.getOneOf()) != null) {
            ArrayList<Schema> passed = new ArrayList<Schema>();
            ArrayList<List<ValidationError>> allErrors = new ArrayList<List<ValidationError>>();
            for (Schema schema1 : oneOf) {
                errors = new ArrayList();
                this.validate(schema1, document, uri, errors::add, selfPropertyHandler, selfItemHandler, recursiveRef);
                if (errors.isEmpty()) {
                    passed.add(schema1);
                }
                allErrors.add(errors);
            }
            if (passed.size() != 1) {
                error.accept(new OneOfError(uri, document, passed, allErrors, schema));
            }
        }
        if ((not = schema.getNot()) != null) {
            ArrayList errors4 = new ArrayList();
            this.validate(not, document, uri, errors4::add, recursiveRef);
            if (errors4.isEmpty()) {
                error.accept(new NotError(uri, document, schema));
            }
        }
        Collection<Schema> disallowSchemas = schema.getDisallowSchemas();
        for (Schema disallowSchema : disallowSchemas) {
            errors = new ArrayList();
            this.validate(disallowSchema, document, uri, errors::add, selfPropertyHandler, selfItemHandler, recursiveRef);
            if (!errors.isEmpty()) continue;
            error.accept(new DisallowError(uri, document, schema));
        }
        Number number = schema.getMultipleOf();
        Number minimum = schema.getMinimum();
        Number maximum = schema.getMaximum();
        Number exclusiveMinimum = schema.getExclusiveMinimum();
        Number exclusiveMaximum = schema.getExclusiveMaximum();
        boolean exclusiveMinimumBoolean = schema.isExclusiveMinimumBoolean();
        boolean exclusiveMaximumBoolean = schema.isExclusiveMaximumBoolean();
        Collection<String> disallow = schema.getDisallow();
        if (object instanceof Number) {
            Number number2 = (Number)object;
            if (number != null && number2.doubleValue() / number.doubleValue() % 1.0 != 0.0) {
                error.accept(new MultipleError(uri, document, schema));
            }
            if (maximum != null && (exclusiveMaximumBoolean ? number2.doubleValue() >= maximum.doubleValue() : number2.doubleValue() > maximum.doubleValue())) {
                error.accept(new MaximumError(uri, document, schema));
            }
            if (exclusiveMaximum != null && number2.doubleValue() >= exclusiveMaximum.doubleValue()) {
                error.accept(new ExclusiveMaximumError(uri, document, schema));
            }
            if (minimum != null && (exclusiveMinimumBoolean ? number2.doubleValue() <= minimum.doubleValue() : number2.doubleValue() < minimum.doubleValue())) {
                error.accept(new MinimumError(uri, document, schema));
            }
            if (exclusiveMinimum != null && number2.doubleValue() <= exclusiveMinimum.doubleValue()) {
                error.accept(new ExclusiveMinimumError(uri, document, schema));
            }
            HashSet<String> okTypes = new HashSet<String>();
            okTypes.add("number");
            try {
                if (MetaSchemaUris.DRAFT_3.equals(schema.getMetaSchema()) || MetaSchemaUris.DRAFT_4.equals(schema.getMetaSchema())) {
                    if (!(number2 instanceof Float) && !(number2 instanceof Double)) {
                        okTypes.add("integer");
                    }
                } else {
                    BigDecimal bigDecimal = new BigDecimal(number2.toString());
                    if (bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
                        okTypes.add("integer");
                    }
                }
            }
            catch (NumberFormatException bigDecimal) {
                // empty catch block
            }
            this.typeCheck(schema, document, uri, okTypes, disallow, error);
            Number divisibleBy = schema.getDivisibleBy();
            if (divisibleBy != null && number2.doubleValue() / divisibleBy.doubleValue() % 1.0 != 0.0) {
                error.accept(new DivisibleByError(uri, document, schema));
            }
        } else if (object instanceof String) {
            String contentMediaType;
            String string;
            String string2;
            String patternString;
            String string3 = (String)object;
            int unicodeCompliantLength = string3.codePointCount(0, string3.length());
            Number minLength = schema.getMinLength();
            Number maxLength = schema.getMaxLength();
            if (maxLength != null && unicodeCompliantLength > maxLength.intValue()) {
                error.accept(new MaxLengthError(uri, document, schema));
            }
            if (minLength != null && unicodeCompliantLength < minLength.intValue()) {
                error.accept(new MinLengthError(uri, document, schema));
            }
            if ((patternString = schema.getPattern()) != null) {
                try {
                    if (!this.regExPatternSupplier.newPattern(patternString).matches(string3)) {
                        error.accept(new PatternError(uri, document, schema));
                    }
                }
                catch (InvalidRegexException invalidRegexException) {
                    LOG.warning("Invalid regex " + patternString);
                }
            }
            if ((string2 = schema.getFormat()) != null && (string = FormatChecker.formatCheck(string3, string2, schema.getMetaSchema(), this.regExPatternSupplier)) != null) {
                error.accept(new FormatError(uri, document, schema, string));
            }
            String string4 = string3;
            String contentEncoding = schema.getContentEncoding();
            if ("base64".equals(contentEncoding)) {
                Base64.Decoder urlDecoder = Base64.getUrlDecoder();
                byte[] decoded = null;
                try {
                    decoded = urlDecoder.decode(string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    error.accept(new ContentEncodingError(uri, document, schema, illegalArgumentException.getMessage()));
                }
                if (decoded != null) {
                    String string5 = new String(decoded, StandardCharsets.UTF_8);
                }
            }
            if ("application/json".equals(contentMediaType = schema.getContentMediaType())) {
                try {
                    void var38_63;
                    new ObjectMapper().readValue((String)var38_63, Object.class);
                }
                catch (JsonProcessingException e) {
                    error.accept(new ContentEncodingError(uri, document, schema, e.getMessage()));
                }
            }
            this.typeCheck(schema, document, uri, Utils.setOf("string"), disallow, errorConsumer);
        } else if (object instanceof Boolean) {
            this.typeCheck(schema, document, uri, Utils.setOf("boolean"), disallow, errorConsumer);
        } else if (object instanceof List) {
            Schema contains;
            Number number3;
            Number number4;
            Object unevaluatedItems;
            Schema _items;
            this.typeCheck(schema, document, uri, Utils.setOf("array"), disallow, errorConsumer);
            Collection jsonArray = (Collection)object;
            List<Schema> itemsTuple = schema.getItemsTuple();
            Schema additionalItems = schema.getAdditionalItems();
            if (itemsTuple != null) {
                int idx;
                if (jsonArray.size() > itemsTuple.size() && additionalItems != null) {
                    for (idx = itemsTuple.size(); idx != jsonArray.size(); ++idx) {
                        this.validate(additionalItems, document, PathUtils.append(uri, String.valueOf(idx)), errorConsumer, recursiveRef);
                        selfItemHandler.accept(idx);
                    }
                }
                for (idx = 0; idx != Math.min(itemsTuple.size(), jsonArray.size()); ++idx) {
                    this.validate(itemsTuple.get(idx), document, PathUtils.append(uri, String.valueOf(idx)), errorConsumer, recursiveRef);
                    selfItemHandler.accept(idx);
                }
            }
            if ((_items = schema.getItems()) != null) {
                for (int idx = 0; idx != jsonArray.size(); ++idx) {
                    this.validate(_items, document, PathUtils.append(uri, String.valueOf(idx)), errorConsumer, recursiveRef);
                    selfItemHandler.accept(idx);
                }
            }
            if ((unevaluatedItems = schema.getUnevaluatedItems()) != null) {
                void var37_54;
                boolean bl = false;
                while (var37_54 != jsonArray.size()) {
                    if (!evaluatedItems.contains((int)var37_54)) {
                        this.validate((Schema)unevaluatedItems, document, PathUtils.append(uri, String.valueOf((int)var37_54)), errorConsumer, recursiveRef);
                        selfItemHandler.accept((int)var37_54);
                    }
                    ++var37_54;
                }
            }
            if ((number4 = schema.getMaxItems()) != null && jsonArray.size() > number4.intValue()) {
                error.accept(new MaxItemsError(uri, document, schema));
            }
            if ((number3 = schema.getMinItems()) != null && jsonArray.size() < number3.intValue()) {
                error.accept(new MinItemsError(uri, document, schema));
            }
            if (schema.isUniqueItems()) {
                HashSet<Object> items = new HashSet<Object>();
                for (Object o : jsonArray) {
                    if (items.add(ComparableUtils.makeComparable(o))) continue;
                    error.accept(new UniqueItemsError(uri, document, schema));
                }
            }
            if ((contains = schema.getContains()) != null) {
                Number number5;
                int numberPassed = 0;
                for (int idx = 0; idx != jsonArray.size(); ++idx) {
                    ArrayList arrayList = new ArrayList();
                    this.validate(contains, document, PathUtils.append(uri, String.valueOf(idx)), arrayList::add, recursiveRef);
                    if (!arrayList.isEmpty()) continue;
                    ++numberPassed;
                }
                Number minContains = schema.getMinContains();
                if (numberPassed < (minContains == null ? 1 : minContains.intValue())) {
                    error.accept(new MinContainsError(uri, document, schema));
                }
                if ((number5 = schema.getMaxContains()) != null && numberPassed > number5.intValue()) {
                    error.accept(new MaxContainsError(uri, document, schema));
                }
            }
        } else if (object instanceof Map) {
            Schema schema3;
            Number minProperties;
            this.typeCheck(schema, document, uri, Utils.setOf("object"), disallow, errorConsumer);
            Map jsonObject = (Map)object;
            Number maxProperties = schema.getMaxProperties();
            if (maxProperties != null && jsonObject.size() > maxProperties.intValue()) {
                error.accept(new MaxPropertiesError(uri, document, schema));
            }
            if ((minProperties = schema.getMinProperties()) != null && jsonObject.size() < minProperties.intValue()) {
                error.accept(new MinPropertiesError(uri, document, schema));
            }
            Collection<String> requiredProperties = schema.getRequiredProperties();
            for (String string : requiredProperties) {
                if (jsonObject.containsKey(string)) continue;
                error.accept(new MissingPropertyError(uri, document, string, schema));
            }
            Map<String, Schema> _properties = schema.getProperties();
            for (Map.Entry<String, Schema> entry : _properties.entrySet()) {
                String property3;
                if (!entry.getValue().isRequired() || jsonObject.containsKey(property3 = entry.getKey())) continue;
                error.accept(new MissingPropertyError(uri, document, property3, schema));
            }
            HashSet hashSet = new HashSet(jsonObject.keySet());
            Collection<String> collection = schema.getPatternPropertiesPatterns();
            Collection<Schema> patternPropertiesSchema = schema.getPatternPropertiesSchema();
            for (Object property4 : jsonObject.keySet()) {
                if (_properties.containsKey(property4)) {
                    this.validate(_properties.get(property4), document, PathUtils.append(uri, (String)property4), errorConsumer, recursiveRef);
                    hashSet.remove(property4);
                    selfPropertyHandler.accept((String)property4);
                }
                Iterator<String> iterator = collection.iterator();
                Iterator<Schema> it1 = patternPropertiesSchema.iterator();
                while (iterator.hasNext()) {
                    String pattern1 = iterator.next();
                    Schema schema1 = it1.next();
                    try {
                        if (!this.regExPatternSupplier.newPattern(pattern1).matches((String)property4)) continue;
                        this.validate(schema1, document, PathUtils.append(uri, (String)property4), errorConsumer, recursiveRef);
                        hashSet.remove(property4);
                        selfPropertyHandler.accept((String)property4);
                    }
                    catch (InvalidRegexException e) {
                        LOG.warning("Invalid regex: " + e.getMessage());
                    }
                }
                Schema propertyNames = schema.getPropertyNames();
                if (propertyNames == null) continue;
                try {
                    URI propertyPath = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), (String)property4, uri.getRawFragment());
                    this.validate(propertyNames, document, propertyPath, errorConsumer, recursiveRef);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
            Map<String, Schema> schemaDependencies = schema.getDependentSchemas();
            for (Map.Entry entry : schemaDependencies.entrySet()) {
                String property5 = (String)entry.getKey();
                if (!jsonObject.containsKey(property5)) continue;
                this.validate((Schema)entry.getValue(), document, uri, errorConsumer, selfPropertyHandler, selfItemHandler, recursiveRef);
            }
            Schema additionalProperties = schema.getAdditionalProperties();
            if (additionalProperties != null) {
                for (String property2 : hashSet) {
                    this.validate(additionalProperties, document, PathUtils.append(uri, property2), errorConsumer, recursiveRef);
                    selfPropertyHandler.accept(property2);
                }
            }
            if ((schema3 = schema.getUnevaluatedProperties()) != null) {
                HashSet remainingProperties2 = new HashSet(jsonObject.keySet());
                remainingProperties2.removeAll(evaluatedProperties);
                for (String property6 : remainingProperties2) {
                    this.validate(schema3, document, PathUtils.append(uri, property6), errorConsumer, recursiveRef);
                    selfPropertyHandler.accept(property6);
                }
            }
            Map<String, Collection<String>> dependencies = schema.getDependentRequired();
            for (Map.Entry<String, Collection<String>> entry : dependencies.entrySet()) {
                String property7 = entry.getKey();
                if (!jsonObject.containsKey(property7)) continue;
                Collection<String> _dependencies = entry.getValue();
                for (String dependency : _dependencies) {
                    if (jsonObject.containsKey(dependency)) continue;
                    error.accept(new DependencyError(uri, document, property7, dependency, schema));
                }
            }
        } else if (object == null) {
            this.typeCheck(schema, document, uri, Utils.setOf("null"), disallow, errorConsumer);
        } else {
            error.accept(new UnexpectedTypeError(uri, document, object, schema));
        }
        if (schema.hasConst() && !ComparableUtils.makeComparable(schema.getConst()).equals(ComparableUtils.makeComparable(object))) {
            error.accept(new ConstError(uri, document, schema));
        }
        if ((enums = schema.getEnums()) != null) {
            boolean matchedOne = false;
            Object o = ComparableUtils.makeComparable(object);
            for (Object value : enums) {
                if (!o.equals(ComparableUtils.makeComparable(value))) continue;
                matchedOne = true;
                break;
            }
            if (!matchedOne) {
                error.accept(new EnumError(uri, document, schema));
            }
        }
    }

    private void typeCheck(Schema schema, Object document, URI path, Set<String> types, Collection<String> disallow, Consumer<? super ValidationError> errorConsumer) {
        Set<String> typesIn;
        Collection<String> explicitTypes;
        if (!disallow.isEmpty()) {
            HashSet<String> typesIn0 = new HashSet<String>(types);
            typesIn0.retainAll(disallow);
            if (!typesIn0.isEmpty()) {
                errorConsumer.accept(new TypeDisallowedError(path, document, typesIn0, schema));
            }
        }
        if ((explicitTypes = schema.getExplicitTypes()) == null) {
            return;
        }
        Collection<Schema> typesSchema = schema.getTypesSchema();
        for (Schema schema1 : typesSchema) {
            ArrayList errors = new ArrayList();
            this.validate(schema1, document, path, errors::add);
            if (!errors.isEmpty()) continue;
            return;
        }
        if (explicitTypes.contains("any")) {
            return;
        }
        if (explicitTypes.isEmpty() && typesSchema.isEmpty()) {
            typesIn = types;
        } else {
            typesIn = new HashSet<String>(types);
            typesIn.retainAll(explicitTypes);
        }
        if (!typesIn.isEmpty()) {
            return;
        }
        errorConsumer.accept(new TypeError(path, document, explicitTypes, types, schema));
    }

    public void validate(Schema schema, File file) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, file, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, URI uri) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, uri, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, URL url) throws ValidationException, IOException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, url, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, Object document) throws ValidationException {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validate(schema, document, errors::add);
        if (!errors.isEmpty()) {
            throw new ListValidationException(errors);
        }
    }

    public void validate(Schema schema, InputStream inputStream) throws ValidationException, IOException {
        this.validate(schema, DocumentUtils.loadJson(inputStream));
    }

    public void validate(Schema schema, URL url, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, DocumentUtils.loadJson(url.openStream()), errorConsumer);
    }

    public void validate(Schema schema, URI uri, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, uri.toURL(), errorConsumer);
    }

    public void validate(Schema schema, File file, Consumer<ValidationError> errorConsumer) throws IOException {
        this.validate(schema, file.toURI(), errorConsumer);
    }

    public void validate(Schema schema, Object document, Consumer<ValidationError> errorConsumer) {
        this.validate(schema, document, URI.create(""), errorConsumer);
    }

    public Map<String, Object> validateWithOutput(SchemaStore schemaStore, Schema schema, Object document) throws GenerationException {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        output.put("valid", true);
        this.validate(schema, document, (ValidationError validationError) -> {
            output.put("valid", false);
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            error.put("error", validationError.getMessage());
            error.put("keywordLocation", validationError.getSchema().getUri());
            error.put("absoluteKeywordLocation", schemaStore.canonicalUriToResourceUri(validationError.getSchema().getUri()));
            String rawFragment = validationError.getUri().getRawFragment();
            error.put("instanceLocation", "#" + (rawFragment == null ? "" : rawFragment));
            if (!output.containsKey("errors")) {
                output.put("errors", new ArrayList());
            }
            ((Collection)output.get("errors")).add(error);
        });
        Schema metaSchema = schemaStore.loadSchema(URI.create("https://json-schema.org/draft/2019-09/output/schema"), false);
        try {
            new Validator().validate(metaSchema, output);
        }
        catch (ValidationException e) {
            throw new GenerationException(e);
        }
        return output;
    }
}

