/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.fasterxml.jackson.core.JsonPointer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.MissingPathException;

public class PathUtils {
    public static final String ESCAPED_EMPTY = "~2";
    private static final Logger LOG = Logger.getLogger(PathUtils.class.getName());

    public static URI append(URI uri, String value) {
        String uriString = uri.toString();
        if (!uriString.contains("#")) {
            uriString = uriString + "#";
        }
        if (uriString.charAt(uriString.length() - 1) != '/') {
            uriString = uriString + "/";
        }
        value = value.replace("~", "~0").replace("/", "~1");
        if ((value = PathUtils.uriComponentEncode(value)).isEmpty()) {
            value = ESCAPED_EMPTY;
        }
        return URI.create(uriString + value);
    }

    static URI baseDocumentFromUri(URI path) {
        try {
            return new URI(path.getScheme(), path.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object fetchFromPath(Object document, String path) throws MissingPathException {
        if (path == null || path.isEmpty()) {
            return document;
        }
        path = path.replace(ESCAPED_EMPTY, "");
        JsonPointer jsonPointer = JsonPointer.compile((String)path);
        return PathUtils.queryFrom(jsonPointer, document);
    }

    private static Object queryFrom(JsonPointer jsonPointer, Object object) throws MissingPathException {
        if (jsonPointer.matches()) {
            return object;
        }
        if (object instanceof List) {
            int matchingIndex = jsonPointer.getMatchingIndex();
            List list = (List)object;
            if (matchingIndex < 0 || matchingIndex >= list.size()) {
                throw new MissingPathException(jsonPointer.toString());
            }
            return PathUtils.queryFrom(jsonPointer.tail(), list.get(matchingIndex));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            String property = URLDecoder.decode(jsonPointer.getMatchingProperty());
            if (!map.containsKey(property)) {
                throw new MissingPathException(jsonPointer.toString());
            }
            return PathUtils.queryFrom(jsonPointer.tail(), map.get(property));
        }
        throw new MissingPathException(jsonPointer.toString());
    }

    public static Object modifyAtPath(Object document, String path, Object newObject) throws MissingPathException {
        if (path == null || path.isEmpty()) {
            return newObject;
        }
        try {
            String parentPath = PathUtils.getParentPath(path);
            path = path.replace(ESCAPED_EMPTY, "");
            JsonPointer jsonPointer = JsonPointer.compile((String)parentPath);
            Object parentObject = PathUtils.queryFrom(jsonPointer, document);
            String lastPart = PathUtils.getLastPart(path);
            lastPart = URLDecoder.decode(lastPart);
            lastPart = PathUtils.jsonPointerUnescape(lastPart);
            if (parentObject instanceof Map) {
                ((Map)parentObject).put(lastPart, newObject);
                return document;
            }
            if (parentObject instanceof List) {
                ((List)parentObject).add(Integer.parseInt(lastPart), newObject);
                return document;
            }
            throw new MissingPathException("Could not modify document");
        }
        catch (IllegalArgumentException ex) {
            throw new MissingPathException("Probable attempt to use an $id as a URL", ex);
        }
    }

    public static void deleteAtPath(Object document, String path) throws MissingPathException {
        if (path == null || path.isEmpty()) {
            throw new MissingPathException();
        }
        try {
            String parentPath = PathUtils.getParentPath(path);
            path = path.replace(ESCAPED_EMPTY, "");
            JsonPointer jsonPointer = JsonPointer.compile((String)("#" + parentPath));
            Object parentObject = PathUtils.queryFrom(jsonPointer, document);
            String lastPart = PathUtils.getLastPart(path);
            lastPart = URLDecoder.decode(lastPart);
            lastPart = PathUtils.jsonPointerUnescape(lastPart);
            if (parentObject instanceof Map) {
                ((Map)parentObject).remove(lastPart);
                return;
            }
            if (parentObject instanceof List) {
                ((List)parentObject).remove(Integer.parseInt(lastPart));
                return;
            }
            throw new MissingPathException("Could not modify document");
        }
        catch (IllegalArgumentException ex) {
            throw new MissingPathException("Probable attempt to use an $id as a URL", ex);
        }
    }

    private static String getParentPath(String path) throws MissingPathException {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            throw new MissingPathException("No parent");
        }
        return path.substring(0, i);
    }

    private static String getLastPart(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            return path;
        }
        return path.substring(i + 1);
    }

    static String uriComponentEncode(String value) {
        String encoded = URLEncoder.encode(value);
        encoded = encoded.replace("%24", "$");
        encoded = encoded.replace("%7E", "~");
        return encoded;
    }

    private static String jsonPointerUnescape(String token) {
        return token.replace("~1", "/").replace("~0", "~").replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public static URI getParent(URI uri) {
        String pointer = uri.getRawFragment();
        if (pointer == null) {
            return null;
        }
        int i = pointer.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        try {
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), pointer.substring(0, i));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    static <T> URI resolve(URI base, URI child) {
        if ("jar".equals(base.getScheme())) {
            URI converted = URI.create(base.toString().substring("jar:".length()));
            URI resolved = PathUtils.resolve(converted, child);
            if ("file".equals(resolved.getScheme())) {
                return URI.create("jar:" + resolved);
            }
            return resolved;
        }
        URI resolve = base.resolve(child);
        return PathUtils.normalize(resolve);
    }

    public static String fixUnescaped(String ref) {
        String fragment;
        int i = ref.indexOf(35);
        if (i == -1) {
            return ref;
        }
        String value = fragment = ref.substring(i + 1);
        value = value.replace("\t", "%09");
        value = value.replace("\n", "%0A");
        value = value.replace("\f", "%0C");
        value = value.replace("\r", "%0D");
        value = value.replace("!", "%21");
        value = value.replace("\"", "%22");
        value = value.replace("#", "%23");
        value = value.replace("+", "%2B");
        value = value.replace(":", "%3A");
        value = value.replace("<", "%3C");
        value = value.replace(">", "%3E");
        value = value.replace("?", "%3F");
        value = value.replace("\\", "%5C");
        value = value.replace("^", "%5E");
        value = value.replace("`", "%60");
        value = value.replace("{", "%7B");
        value = value.replace("|", "%7C");
        if ((value = value.replace("}", "%7D")).equals(fragment)) {
            return ref;
        }
        String ref2 = ref.substring(0, i + 1) + value;
        LOG.warning("Converting unescaped reference " + ref + " to JSON Schema legal $ref form " + ref2);
        return ref2;
    }

    static URI normalize(URI uri) {
        String uriString = uri.toString();
        int length = uriString.length();
        if (uriString.endsWith("#")) {
            return URI.create(uriString.substring(0, length - "#".length()));
        }
        if (uriString.endsWith("#/")) {
            return URI.create(uriString.substring(0, length - "#/".length()));
        }
        return uri;
    }
}

