/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.JsonPointer;
import com.ibm.icu.text.IDNA;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.jimblackler.jsonschemafriend.InvalidRegexException;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.RegExPatternSupplier;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public class FormatChecker {
    private static final Collection<String> IDNA_DISALLOWED;
    private static final Pattern RELATIVE_JSON_POINTER_PATTERN;

    static String formatCheck(String string, String format, URI metaSchema, RegExPatternSupplier regExPatternSupplier) {
        URI uri1;
        boolean doAll = false;
        if (metaSchema.equals(MetaSchemaUris.DRAFT_2019_09)) {
            doAll = true;
            switch (format) {
                case "uuid": {
                    try {
                        UUID uuid = UUID.fromString(string);
                        if (!string.toLowerCase().equals(uuid.toString())) {
                            return "Not canonical";
                        }
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        return e.getMessage();
                    }
                }
            }
        }
        if (doAll || metaSchema.equals(MetaSchemaUris.DRAFT_7)) {
            doAll = true;
            switch (format) {
                case "iri": {
                    try {
                        uri1 = new URI(string);
                        if (!uri1.isAbsolute()) {
                            return "Not absolute";
                        }
                        String authority = uri1.getAuthority();
                        if (authority != null && InetAddressValidator.getInstance().isValidInet6Address(authority)) {
                            return "ipv6 not valid as host in an IRI";
                        }
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "idn-email": {
                    try {
                        InternetAddress[] parsed = InternetAddress.parse((String)string);
                        if (parsed.length != 1) {
                            return "Unexpected parse result";
                        }
                        parsed[0].validate();
                        break;
                    }
                    catch (AddressException e) {
                        return e.getMessage();
                    }
                }
                case "relative-json-pointer": {
                    Matcher matcher = RELATIVE_JSON_POINTER_PATTERN.matcher(string);
                    System.out.println("groupCount " + matcher.groupCount());
                    if (!matcher.find() || matcher.groupCount() != 2) {
                        return "Relative JSON Pointer invalid";
                    }
                    String number = matcher.group(1);
                    String remain = matcher.group(2);
                    if ("#".equals(remain)) break;
                    return FormatChecker.checkJsonPointer(remain);
                }
                case "idn-hostname": {
                    for (int idx = 0; idx < string.length(); ++idx) {
                        char c = string.charAt(idx);
                        if (!IDNA_DISALLOWED.contains(String.valueOf(c))) continue;
                        return "Disallowed character " + c;
                    }
                    StringBuilder sb = new StringBuilder();
                    IDNA.Info info = new IDNA.Info();
                    IDNA.getUTS46Instance((int)88).nameToASCII((CharSequence)string, sb, info);
                    if (info.getErrors().isEmpty()) break;
                    return info.getErrors().toString();
                }
            }
        }
        if (doAll || metaSchema.equals(MetaSchemaUris.DRAFT_6)) {
            doAll = true;
            switch (format) {
                case "iri-reference": 
                case "uri-reference": {
                    try {
                        new URI(string);
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "uri-template": {
                    try {
                        UriTemplate.buildFromTemplate((String)string);
                        break;
                    }
                    catch (MalformedUriTemplateException e) {
                        return e.getMessage();
                    }
                }
                case "json-pointer": {
                    return FormatChecker.checkJsonPointer(string);
                }
            }
        }
        if (doAll || metaSchema.equals(MetaSchemaUris.DRAFT_3) || metaSchema.equals(MetaSchemaUris.DRAFT_4)) {
            switch (format) {
                case "regex": {
                    try {
                        regExPatternSupplier.newPattern(string);
                        break;
                    }
                    catch (InvalidRegexException ex) {
                        return ex.getMessage();
                    }
                }
                case "date": {
                    try {
                        DateTimeFormatter.ISO_DATE.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
                case "time": {
                    try {
                        DateTimeFormatter.ISO_TIME.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
                case "date-time": {
                    try {
                        DateTimeFormatter.ISO_DATE_TIME.parse(string);
                        break;
                    }
                    catch (DateTimeParseException e) {
                        return e.getMessage();
                    }
                }
                case "email": {
                    if (EmailValidator.getInstance().isValid(string)) break;
                    return "Did not match";
                }
                case "uri": {
                    try {
                        if (string.startsWith("//")) {
                            return "Protocol-relative";
                        }
                        uri1 = new URI(string);
                        if (!metaSchema.equals(MetaSchemaUris.DRAFT_3) && !uri1.isAbsolute()) {
                            return "Not absolute";
                        }
                        break;
                    }
                    catch (URISyntaxException e) {
                        return e.getReason();
                    }
                }
                case "hostname": 
                case "host-name": {
                    if (DomainValidator.getInstance().isValid(string)) break;
                    return "Failed DomainValidator";
                }
                case "ipv6": {
                    if (!InetAddressValidator.getInstance().isValidInet6Address(string)) {
                        return "Failed InetAddressValidator";
                    }
                    try {
                        InetAddress.getByName(string);
                        break;
                    }
                    catch (UnknownHostException e) {
                        return e.getMessage();
                    }
                }
                case "ipv4": 
                case "ip-address": {
                    if (InetAddressValidator.getInstance().isValidInet4Address(string)) break;
                    return "Failed InetAddressValidator";
                }
            }
        }
        return null;
    }

    private static String checkJsonPointer(String string) {
        if (string.replace("~0", "").replace("~1", "").contains("~")) {
            return "Not escaped";
        }
        try {
            JsonPointer jsonPointer = JsonPointer.compile((String)string);
            String readBack = jsonPointer.toString().replace("\\\\", "\\").replace("\\\"", "\"");
            if (readBack.equals(string)) {
                return null;
            }
            return "Not canonical: " + readBack;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    static {
        RELATIVE_JSON_POINTER_PATTERN = Pattern.compile("^(\\d+)(.*)$");
        HashSet<String> set = new HashSet<String>();
        set.add("\u0640");
        set.add("\u07fa");
        set.add("\u302e");
        set.add("\u302f");
        set.add("\u3031");
        set.add("\u3032");
        set.add("\u3033");
        set.add("\u3034");
        set.add("\u3035");
        set.add("\u303b");
        IDNA_DISALLOWED = set;
    }
}

