/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.TypeInferrer;

public class CombinedSchema {
    private final Schema schema;

    public CombinedSchema(Schema schema) {
        this.schema = schema;
    }

    public Collection<String> getInferredTypes() {
        Collection<Schema> allOf;
        Collection<String> allTypes = TypeInferrer.inferTypes(this.schema);
        Collection<Schema> anyOf = this.schema.getAnyOf();
        if (anyOf != null && !anyOf.isEmpty()) {
            for (Schema subSchema : anyOf) {
                allTypes.addAll(TypeInferrer.inferTypesNonEmpty(subSchema));
            }
        }
        if (!(allOf = this.schema.getAllOf()).isEmpty()) {
            for (Schema subSchema : allOf) {
                Collection<String> types = TypeInferrer.inferTypesNonEmpty(subSchema);
                allTypes.retainAll(types);
            }
        }
        return allTypes;
    }

    public Map<String, Schema> getProperties() {
        Collection<Schema> allOf;
        HashMap<String, Schema> allProperties = new HashMap<String, Schema>(this.schema.getProperties());
        Collection<Schema> anyOf = this.schema.getAnyOf();
        if (anyOf != null && !anyOf.isEmpty()) {
            for (Schema subSchema : anyOf) {
                allProperties.putAll(subSchema.getProperties());
            }
        }
        if (!(allOf = this.schema.getAllOf()).isEmpty()) {
            for (Schema subSchema : allOf) {
                allProperties.putAll(subSchema.getProperties());
            }
        }
        return allProperties;
    }

    public Collection<String> getNonProhibitedTypes() {
        Collection<Schema> allOf;
        HashSet<String> allTypes = new HashSet<String>(TypeInferrer.getNonProhibitedTypes(this.schema));
        Collection<Schema> anyOf = this.schema.getAnyOf();
        if (anyOf != null && !anyOf.isEmpty()) {
            for (Schema subSchema : anyOf) {
                allTypes.addAll(TypeInferrer.getNonProhibitedTypes(subSchema));
            }
        }
        if (!(allOf = this.schema.getAllOf()).isEmpty()) {
            for (Schema subSchema : allOf) {
                Collection<String> types = TypeInferrer.getNonProhibitedTypes(subSchema);
                allTypes.retainAll(types);
            }
        }
        return allTypes;
    }

    public Collection<String> getExplicitTypes() {
        Collection<Schema> allOf;
        Collection<Schema> anyOf;
        HashSet<String> allTypes = new HashSet<String>();
        Collection<String> explicitTypes = this.schema.getExplicitTypes();
        if (explicitTypes != null) {
            allTypes.addAll(explicitTypes);
        }
        if ((anyOf = this.schema.getAnyOf()) != null && !anyOf.isEmpty()) {
            for (Schema subSchema : anyOf) {
                Collection<String> types = subSchema.getExplicitTypes();
                if (types == null) continue;
                allTypes.addAll(types);
            }
        }
        if (!(allOf = this.schema.getAllOf()).isEmpty()) {
            for (Schema subSchema : allOf) {
                Collection<String> types = subSchema.getExplicitTypes();
                if (types == null) continue;
                allTypes.retainAll(types);
            }
        }
        return allTypes;
    }

    public Collection<Object> getEnums() {
        Collection<Schema> allOf;
        Collection<Schema> anyOf;
        HashSet<Object> allEnums = new HashSet<Object>();
        List<Object> enums1 = this.schema.getEnums();
        if (enums1 != null) {
            allEnums.addAll(enums1);
        }
        if ((anyOf = this.schema.getAnyOf()) != null && !anyOf.isEmpty()) {
            for (Schema subSchema : anyOf) {
                List<Object> enums = subSchema.getEnums();
                if (enums == null) continue;
                allEnums.addAll(enums);
            }
        }
        if (!(allOf = this.schema.getAllOf()).isEmpty()) {
            for (Schema subSchema : allOf) {
                List<Object> enums = subSchema.getEnums();
                if (enums == null) continue;
                allEnums.retainAll(enums);
            }
        }
        if (allEnums.isEmpty()) {
            return null;
        }
        return allEnums;
    }
}

