/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.StreamUtils;

public class CacheLoader {
    private static final Logger LOG = Logger.getLogger(CacheLoader.class.getName());
    private static final FileSystem FILE_SYSTEM = FileSystems.getDefault();

    public static String load(URI uri, boolean cacheSchema) throws IOException {
        if (cacheSchema && ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
            Path diskCacheName = FILE_SYSTEM.getPath(System.getProperty("java.io.tmpdir"), new String[0]).resolve("net.jimblackler.jsonschemafriend").resolve("cache").resolve(uri.getHost() + uri.getPath());
            if (Files.exists(diskCacheName, new LinkOption[0])) {
                LOG.fine("Cache loading: " + uri + System.lineSeparator() + "From: " + diskCacheName);
                return StreamUtils.streamToString(diskCacheName.toUri().toURL().openStream());
            }
            String content = StreamUtils.streamToString(uri.toURL().openStream());
            diskCacheName.getParent().toFile().mkdirs();
            try (PrintWriter out = new PrintWriter(diskCacheName.toFile());){
                out.println(content);
            }
            return content;
        }
        LOG.fine("Loading :" + uri);
        return StreamUtils.streamToString(uri.toURL().openStream());
    }
}

