/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.net.URI;
import net.jimblackler.jsonschemafriend.MissingPathException;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.Validator;

public abstract class ValidationError {
    private final URI uri;
    private final Object document;
    private final Schema schema;
    private final Object object;

    protected ValidationError(URI uri, Object document, Schema schema) {
        Object _object;
        this.uri = uri;
        this.document = document;
        this.schema = schema;
        try {
            _object = Validator.getObject(document, uri);
        }
        catch (MissingPathException e) {
            _object = null;
        }
        this.object = _object;
    }

    public String toString() {
        URI schemaPath = this.schema.getUri();
        String string = this.object == null ? "" : this.object.toString();
        return (string.length() <= 20 ? "\"" + string + "\" " : "") + (this.uri.toString().isEmpty() ? "" : "at " + this.uri + " ") + "failed " + (schemaPath.toString().isEmpty() ? "" : "against " + schemaPath + " ") + "with \"" + this.getMessage() + "\"";
    }

    public Object getObject() {
        return this.object;
    }

    public URI getUri() {
        return this.uri;
    }

    public Object getDocument() {
        return this.document;
    }

    public Schema getSchema() {
        return this.schema;
    }

    abstract String getMessage();
}

