/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.CacheLoader;
import net.jimblackler.jsonschemafriend.DocumentUtils;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.MetaSchemaDetector;
import net.jimblackler.jsonschemafriend.MetaSchemaUris;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.StandardGenerationException;
import net.jimblackler.jsonschemafriend.UrlRewriter;
import net.jimblackler.jsonschemafriend.Validator;

public class SchemaStore {
    private static final Logger LOG = Logger.getLogger(SchemaStore.class.getName());
    private final Map<URI, Object> canonicalUriToObject = new HashMap<URI, Object>();
    private final Map<URI, Object> canonicalUriToBaseObject = new HashMap<URI, Object>();
    private final Map<URI, URI> validUriToCanonicalUri = new HashMap<URI, URI>();
    private final Map<URI, URI> canonicalUriToResourceUri = new HashMap<URI, URI>();
    private final Map<URI, Schema> builtSchemas = new HashMap<URI, Schema>();
    private final Collection<URI> mapped = new HashSet<URI>();
    private final UrlRewriter urlRewriter;
    private int memorySchemaNumber;

    public SchemaStore() {
        this.urlRewriter = null;
    }

    public SchemaStore(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public Schema loadSchema(Object document) throws GenerationException {
        URI uri = URI.create(this.memorySchemaNumber == 0 ? "" : String.valueOf(this.memorySchemaNumber));
        ++this.memorySchemaNumber;
        URI canonicalUri = this.store(uri, document);
        return this.loadSchema(canonicalUri);
    }

    public Schema loadSchema(File file) throws GenerationException {
        if (!file.isFile()) {
            throw new GenerationException(file + " is not a file.");
        }
        return this.loadSchema(file.toURI());
    }

    public Schema loadSchema(URL url) throws GenerationException {
        try {
            return this.loadSchema(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new GenerationException(e);
        }
    }

    public Schema loadSchema(URI uri) throws GenerationException {
        return this.loadSchema(uri, true);
    }

    public Schema loadSchema(URI uri, boolean prevalidate) throws GenerationException {
        Schema metaSchema;
        Map<String, Object> validation;
        URI metaSchemaUri;
        Object schemaObject;
        uri = PathUtils.normalize(uri);
        while (true) {
            Map schemaJsonObject;
            Object refObject;
            if (this.builtSchemas.containsKey(uri)) {
                return this.builtSchemas.get(uri);
            }
            if (this.validUriToCanonicalUri.containsKey(uri)) {
                uri = this.validUriToCanonicalUri.get(uri);
                continue;
            }
            if (!this.canonicalUriToObject.containsKey(uri) && uri.isAbsolute()) {
                URI documentUri = PathUtils.baseDocumentFromUri(uri);
                LOG.fine("Loading: " + documentUri + " to resolve: " + uri);
                try {
                    String content = this.urlRewriter == null ? CacheLoader.load(documentUri) : CacheLoader.load(this.urlRewriter.rewrite(documentUri));
                    if (!this.mapped.contains(documentUri)) {
                        this.store(documentUri, DocumentUtils.parseJson(content));
                        continue;
                    }
                }
                catch (IOException e) {
                    LOG.warning("Failed attempt to auto fetch to resolve: " + uri);
                }
            }
            if (!((schemaObject = this.getObject(uri)) instanceof Map) || !((refObject = (schemaJsonObject = (Map)schemaObject).get("$ref")) instanceof String)) break;
            String refString = PathUtils.fixUnescaped((String)refObject);
            URI pointingTo = PathUtils.resolve(uri, URI.create(refString));
            URI metaSchema2 = MetaSchemaDetector.detectMetaSchema(this.canonicalUriToBaseObject.get(uri));
            if (metaSchema2.equals(MetaSchemaUris.DRAFT_2019_09) && schemaJsonObject.size() > 1) break;
            uri = pointingTo;
        }
        if (prevalidate && (schemaObject = this.getObject(uri)) != null && !PathUtils.normalize(metaSchemaUri = MetaSchemaDetector.detectMetaSchema(this.canonicalUriToBaseObject.get(uri))).equals(uri) && !((Boolean)(validation = new Validator().validateWithOutput(this, metaSchema = this.loadSchema(metaSchemaUri, false), schemaObject)).get("valid")).booleanValue()) {
            throw new StandardGenerationException(validation);
        }
        return new Schema(this, uri);
    }

    public void register(URI path, Schema schema) throws GenerationException {
        if (this.builtSchemas.put(path, schema) != null) {
            throw new GenerationException(path + " already registered");
        }
    }

    public URI store(URI uri, Object document) {
        if (!this.mapped.add(uri)) {
            throw new IllegalStateException("Double mapped");
        }
        return this.map(document, document, uri, uri, MetaSchemaDetector.detectMetaSchema(document), true);
    }

    URI map(Object object, Object baseObject, URI validUri, URI canonicalBaseUri, URI metaSchema, boolean isResource) {
        URI canonicalUri;
        block16: {
            block15: {
                Map jsonObject;
                String idKey = MetaSchemaUris.DRAFT_3.equals(metaSchema) || MetaSchemaUris.DRAFT_4.equals(metaSchema) ? "id" : "$id";
                canonicalUri = canonicalBaseUri;
                if (object instanceof Map) {
                    Object v;
                    jsonObject = (Map)object;
                    Object idObject = jsonObject.get(idKey);
                    if (idObject instanceof String) {
                        URI uRI = URI.create((String)idObject);
                        if (MetaSchemaUris.DRAFT_2019_09.equals(metaSchema) && uRI.getRawFragment() != null && !uRI.getRawFragment().isEmpty()) {
                            LOG.warning("Illegal fragment in ID");
                        } else {
                            canonicalUri = PathUtils.resolve(canonicalUri, uRI);
                        }
                    }
                    if ((v = jsonObject.get("$anchor")) instanceof String) {
                        try {
                            URI anchor = new URI(null, null, null, (String)v);
                            canonicalUri = PathUtils.resolve(canonicalUri, anchor);
                        }
                        catch (URISyntaxException e) {
                            LOG.warning("Problem with $anchor: " + e.getMessage());
                        }
                    }
                }
                if (isResource) {
                    URI was = this.canonicalUriToResourceUri.put(canonicalUri, validUri);
                    if (was != null) {
                        LOG.warning("Attempt to map from at least two locations: " + canonicalUri + System.lineSeparator() + validUri + System.lineSeparator() + was);
                        return canonicalUri;
                    }
                    if (this.canonicalUriToObject.put(canonicalUri, object) != null) {
                        throw new IllegalStateException("Different content with same IDs found mapping " + canonicalUri);
                    }
                    if (this.canonicalUriToBaseObject.put(canonicalUri, baseObject) != null) {
                        throw new IllegalStateException("Different content with same IDs found mapping " + canonicalUri);
                    }
                }
                if (!canonicalBaseUri.equals(canonicalUri)) {
                    this.validUriToCanonicalUri.put(canonicalBaseUri, canonicalUri);
                }
                if (!validUri.equals(canonicalUri)) {
                    this.validUriToCanonicalUri.put(validUri, canonicalUri);
                }
                if (!(object instanceof Map)) break block15;
                jsonObject = (Map)object;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    this.map(entry.getValue(), baseObject, PathUtils.append(validUri, key), PathUtils.append(canonicalUri, key), metaSchema, isResource);
                    if (canonicalBaseUri.equals(canonicalUri) || canonicalBaseUri.equals(validUri)) continue;
                    this.map(entry.getValue(), baseObject, PathUtils.append(canonicalBaseUri, key), PathUtils.append(canonicalUri, key), metaSchema, false);
                }
                break block16;
            }
            if (!(object instanceof List)) break block16;
            List jsonArray = (List)object;
            for (int idx = 0; idx != jsonArray.size(); ++idx) {
                this.map(jsonArray.get(idx), baseObject, PathUtils.append(validUri, String.valueOf(idx)), PathUtils.append(canonicalUri, String.valueOf(idx)), metaSchema, isResource);
            }
        }
        return canonicalUri;
    }

    Object getObject(URI canonicalUri) {
        if (this.validUriToCanonicalUri.containsKey(canonicalUri)) {
            throw new IllegalStateException("getObject(): non-canonical URL received");
        }
        if (this.canonicalUriToObject.containsKey(canonicalUri)) {
            return this.canonicalUriToObject.get(canonicalUri);
        }
        return null;
    }

    public Object getBaseObject(URI uri) {
        return this.canonicalUriToBaseObject.get(uri);
    }

    public URI canonicalUriToResourceUri(URI uri) {
        return this.canonicalUriToResourceUri.get(uri);
    }
}

