/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.jsonschemafriend;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.MetaSchemaDetector;
import net.jimblackler.jsonschemafriend.PathUtils;
import net.jimblackler.jsonschemafriend.SchemaStore;
import net.jimblackler.jsonschemafriend.Utils;
import net.jimblackler.jsonschemafriend.ValidationException;
import net.jimblackler.jsonschemafriend.Validator;

public class Schema {
    private static final Logger LOG = Logger.getLogger(Schema.class.getName());
    private final Object schemaObject;
    private final SchemaStore schemaStore;
    private final URI uri;
    private final Number multipleOf;
    private final Number maximum;
    private final Object exclusiveMaximum;
    private final Number minimum;
    private final Object exclusiveMinimum;
    private final Number divisibleBy;
    private final Number maxLength;
    private final Number minLength;
    private final String pattern;
    private final String format;
    private final String contentEncoding;
    private final String contentMediaType;
    private final Schema additionalItems;
    private final Schema unevaluatedItems;
    private final Schema _items;
    private final List<Schema> itemsTuple;
    private final Number maxItems;
    private final Number minItems;
    private final boolean uniqueItems;
    private final Schema contains;
    private final Number minContains;
    private final Number maxContains;
    private final Number maxProperties;
    private final Number minProperties;
    private final Collection<String> requiredProperties = new HashSet<String>();
    private final boolean required;
    private final Schema additionalProperties;
    private final Schema unevaluatedProperties;
    private final Map<String, Schema> _properties = new LinkedHashMap<String, Schema>();
    private final Collection<String> patternPropertiesPatterns = new ArrayList<String>();
    private final Collection<Schema> patternPropertiesSchemas = new ArrayList<Schema>();
    private final Map<String, Collection<String>> dependentRequired = new HashMap<String, Collection<String>>();
    private final Map<String, Schema> dependentSchemas = new HashMap<String, Schema>();
    private final Schema propertyNames;
    private final boolean hasConst;
    private final Object _const;
    private final List<Object> enums;
    private final Set<String> explicitTypes;
    private final Collection<Schema> typesSchema = new HashSet<Schema>();
    private final Collection<String> disallow = new HashSet<String>();
    private final Collection<Schema> disallowSchemas = new HashSet<Schema>();
    private final Object defaultValue;
    private final Schema _if;
    private final Schema _then;
    private final Schema _else;
    private final Collection<Schema> allOf = new ArrayList<Schema>();
    private final Collection<Schema> anyOf;
    private final Collection<Schema> oneOf;
    private final Schema not;
    private final Schema ref;
    private final Schema recursiveRef;
    private final boolean recursiveAnchor;
    private final List<Object> examples;
    private final String title;
    private final String description;
    private URI metaSchema;
    private Schema parent;

    Schema(SchemaStore schemaStore, URI uri) throws GenerationException {
        Object oneOfObject;
        Object refObject;
        Object extendsObject;
        Collection array;
        Map map;
        Map dependentRequiredJsonObject;
        ArrayList<String> spec;
        Map dependenciesJsonObject;
        Object patternPropertiesObject;
        this.schemaStore = schemaStore;
        this.uri = uri;
        schemaStore.register(uri, this);
        Object _schemaObject = schemaStore.getObject(uri);
        if (_schemaObject == null) {
            LOG.warning("No match for " + uri);
            _schemaObject = true;
        }
        this.schemaObject = _schemaObject;
        LinkedHashMap<String, Object> jsonObject = this.schemaObject instanceof Map ? (LinkedHashMap<String, Object>)this.schemaObject : new LinkedHashMap<String, Object>();
        this.multipleOf = (Number)jsonObject.get("multipleOf");
        this.maximum = (Number)jsonObject.get("maximum");
        this.exclusiveMaximum = jsonObject.get("exclusiveMaximum");
        this.minimum = (Number)jsonObject.get("minimum");
        this.exclusiveMinimum = jsonObject.get("exclusiveMinimum");
        this.divisibleBy = (Number)jsonObject.get("divisibleBy");
        this.maxLength = (Number)jsonObject.get("maxLength");
        this.minLength = (Number)jsonObject.get("minLength");
        Object patternObject = jsonObject.get("pattern");
        String _pattern = null;
        if (patternObject != null) {
            _pattern = (String)patternObject;
        }
        this.pattern = _pattern;
        Object formatObject = jsonObject.get("format");
        this.format = formatObject instanceof String ? (String)formatObject : null;
        Object contentEncodingObject = jsonObject.get("contentEncoding");
        this.contentEncoding = contentEncodingObject instanceof String ? (String)contentEncodingObject : null;
        Object contentMediaTypeObject = jsonObject.get("contentMediaType");
        this.contentMediaType = contentMediaTypeObject instanceof String ? (String)contentMediaTypeObject : null;
        this.additionalItems = this.getSubSchema(jsonObject, "additionalItems", uri);
        this.unevaluatedItems = this.getSubSchema(jsonObject, "unevaluatedItems", uri);
        Object itemsObject = jsonObject.get("items");
        URI itemsPath = PathUtils.append(uri, "items");
        if (itemsObject instanceof List) {
            this.itemsTuple = new ArrayList<Schema>();
            Collection jsonArray = (Collection)itemsObject;
            for (int idx = 0; idx != jsonArray.size(); ++idx) {
                this.itemsTuple.add(this.getSubSchema(PathUtils.append(itemsPath, String.valueOf(idx))));
            }
            this._items = null;
        } else {
            this.itemsTuple = null;
            this._items = this.getSubSchema(jsonObject, "items", uri);
        }
        this.maxItems = (Number)jsonObject.get("maxItems");
        this.minItems = (Number)jsonObject.get("minItems");
        this.uniqueItems = Utils.getOrDefault(jsonObject, "uniqueItems", false);
        this.contains = this.getSubSchema(jsonObject, "contains", uri);
        this.minContains = (Number)jsonObject.get("minContains");
        this.maxContains = (Number)jsonObject.get("maxContains");
        this.maxProperties = (Number)jsonObject.get("maxProperties");
        this.minProperties = (Number)jsonObject.get("minProperties");
        Object requiredObject = jsonObject.get("required");
        if (requiredObject instanceof List) {
            for (Object req : (Iterable)requiredObject) {
                this.requiredProperties.add((String)req);
            }
        }
        this.required = requiredObject instanceof Boolean && (Boolean)requiredObject != false;
        this.additionalProperties = this.getSubSchema(jsonObject, "additionalProperties", uri);
        this.unevaluatedProperties = this.getSubSchema(jsonObject, "unevaluatedProperties", uri);
        Object propertiesObject = jsonObject.get("properties");
        if (propertiesObject instanceof Map) {
            Map properties = (Map)propertiesObject;
            URI propertiesPointer = PathUtils.append(uri, "properties");
            for (String string : properties.keySet()) {
                URI uRI = PathUtils.append(propertiesPointer, string);
                this._properties.put(string, this.getSubSchema(uRI));
            }
        }
        if ((patternPropertiesObject = jsonObject.get("patternProperties")) instanceof Map) {
            Map patternProperties = (Map)patternPropertiesObject;
            URI propertiesPointer = PathUtils.append(uri, "patternProperties");
            for (String string : patternProperties.keySet()) {
                this.patternPropertiesPatterns.add(string);
                URI patternPointer = PathUtils.append(propertiesPointer, string);
                this.patternPropertiesSchemas.add(this.getSubSchema(patternPointer));
            }
        }
        if ((dependenciesJsonObject = (Map)jsonObject.get("dependencies")) != null) {
            for (Map.Entry entry : dependenciesJsonObject.entrySet()) {
                String string = (String)entry.getKey();
                spec = new ArrayList<String>();
                Object dependencyObject = entry.getValue();
                if (dependencyObject instanceof List) {
                    for (Object o : (Iterable)dependencyObject) {
                        spec.add((String)o);
                    }
                    this.dependentRequired.put(string, spec);
                    continue;
                }
                if (dependencyObject instanceof Map || dependencyObject instanceof Boolean) {
                    URI dependenciesPointer = PathUtils.append(uri, "dependencies");
                    this.dependentSchemas.put(string, this.getSubSchema(PathUtils.append(dependenciesPointer, string)));
                    continue;
                }
                ArrayList<String> objects = new ArrayList<String>();
                objects.add((String)dependencyObject);
                this.dependentRequired.put(string, objects);
            }
        }
        if ((dependentRequiredJsonObject = (Map)jsonObject.get("dependentRequired")) != null) {
            for (Map.Entry entry : dependentRequiredJsonObject.entrySet()) {
                spec = new ArrayList();
                for (Object req : (Iterable)entry.getValue()) {
                    spec.add((String)req);
                }
                this.dependentRequired.put((String)entry.getKey(), spec);
            }
        }
        if ((map = (Map)jsonObject.get("dependentSchemas")) != null) {
            for (String dependency : map.keySet()) {
                URI dependenciesPointer = PathUtils.append(uri, "dependentSchemas");
                this.dependentSchemas.put(dependency, this.getSubSchema(PathUtils.append(dependenciesPointer, dependency)));
            }
        }
        this.propertyNames = this.getSubSchema(jsonObject, "propertyNames", uri);
        if (jsonObject.containsKey("const")) {
            this.hasConst = true;
            this._const = jsonObject.get("const");
        } else {
            this.hasConst = false;
            this._const = null;
        }
        Collection collection = (Collection)jsonObject.get("enum");
        if (collection == null) {
            this.enums = null;
        } else {
            this.enums = new ArrayList<Object>();
            this.enums.addAll(collection);
        }
        Object typeObject = jsonObject.get("type");
        if (typeObject instanceof List) {
            URI typePointer = PathUtils.append(uri, "type");
            this.explicitTypes = new HashSet<String>();
            array = (List)typeObject;
            for (int idx = 0; idx != array.size(); ++idx) {
                Object arrayEntryObject = array.get(idx);
                if (arrayEntryObject instanceof Boolean || arrayEntryObject instanceof Map) {
                    this.typesSchema.add(this.getSubSchema(PathUtils.append(typePointer, String.valueOf(idx))));
                    continue;
                }
                this.explicitTypes.add((String)arrayEntryObject);
            }
        } else {
            this.explicitTypes = typeObject instanceof String ? Utils.setOf(typeObject.toString()) : null;
        }
        this._if = this.getSubSchema(jsonObject, "if", uri);
        this._then = this.getSubSchema(jsonObject, "then", uri);
        this._else = this.getSubSchema(jsonObject, "else", uri);
        Object allOfObject = jsonObject.get("allOf");
        if (allOfObject instanceof List) {
            array = (Collection)allOfObject;
            URI arrayPath = PathUtils.append(uri, "allOf");
            for (int idx = 0; idx != array.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.allOf.add(this.getSubSchema(indexPointer));
            }
        }
        if ((extendsObject = jsonObject.get("extends")) instanceof List) {
            URI arrayPath = PathUtils.append(uri, "extends");
            Collection array2 = (Collection)extendsObject;
            for (int idx = 0; idx != array2.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.allOf.add(this.getSubSchema(indexPointer));
            }
        } else if (extendsObject instanceof Map || extendsObject instanceof Boolean) {
            URI arrayPath = PathUtils.append(uri, "extends");
            this.allOf.add(this.getSubSchema(arrayPath));
        }
        if ((refObject = jsonObject.get("$ref")) instanceof String) {
            URI resolved = PathUtils.resolve(uri, URI.create(PathUtils.fixUnescaped((String)refObject)));
            this.ref = schemaStore.loadSchema(resolved, false);
        } else {
            this.ref = null;
        }
        Object recursiveRefObject = jsonObject.get("$recursiveRef");
        if (recursiveRefObject instanceof String) {
            URI resolved = PathUtils.resolve(uri, URI.create((String)recursiveRefObject));
            this.recursiveRef = schemaStore.loadSchema(resolved, false);
        } else {
            this.recursiveRef = null;
        }
        this.recursiveAnchor = Utils.getOrDefault(jsonObject, "$recursiveAnchor", false);
        Object anyOfObject = jsonObject.get("anyOf");
        if (anyOfObject instanceof List) {
            this.anyOf = new ArrayList<Schema>();
            Collection array3 = (Collection)anyOfObject;
            URI arrayPath = PathUtils.append(uri, "anyOf");
            for (int idx = 0; idx != array3.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.anyOf.add(this.getSubSchema(indexPointer));
            }
        } else {
            this.anyOf = null;
        }
        if ((oneOfObject = jsonObject.get("oneOf")) instanceof List) {
            this.oneOf = new ArrayList<Schema>();
            Collection array4 = (Collection)oneOfObject;
            URI arrayPath = PathUtils.append(uri, "oneOf");
            for (int idx = 0; idx != array4.size(); ++idx) {
                URI indexPointer = PathUtils.append(arrayPath, String.valueOf(idx));
                this.oneOf.add(this.getSubSchema(indexPointer));
            }
        } else {
            this.oneOf = null;
        }
        this.not = this.getSubSchema(jsonObject, "not", uri);
        Object disallowObject = jsonObject.get("disallow");
        if (disallowObject instanceof String) {
            this.disallow.add(disallowObject.toString());
        } else if (disallowObject instanceof List) {
            List array5 = (List)disallowObject;
            URI disallowPointer = PathUtils.append(uri, "disallow");
            for (int idx = 0; idx != array5.size(); ++idx) {
                Object disallowEntryObject = array5.get(idx);
                if (disallowEntryObject instanceof String) {
                    this.disallow.add((String)array5.get(idx));
                    continue;
                }
                this.disallowSchemas.add(this.getSubSchema(PathUtils.append(disallowPointer, String.valueOf(idx))));
            }
        }
        this.defaultValue = jsonObject.get("default");
        this.title = (String)jsonObject.get("title");
        this.description = (String)jsonObject.get("description");
        this.examples = (List)jsonObject.get("examples");
        if (this.examples != null) {
            Validator validator = new Validator();
            for (Object example : this.examples) {
                try {
                    validator.validate(this, example);
                }
                catch (ValidationException e) {
                    throw new GenerationException(e);
                }
            }
        }
    }

    private Schema getSubSchema(Map<String, Object> jsonObject, String name, URI uri) throws GenerationException {
        Object childObject = jsonObject.get(name);
        if (childObject instanceof Map || childObject instanceof Boolean) {
            return this.getSubSchema(PathUtils.append(uri, name));
        }
        return null;
    }

    private Schema getSubSchema(URI uri) throws GenerationException {
        Schema subSchema = this.schemaStore.loadSchema(uri, false);
        if (subSchema != null && subSchema.getUri().equals(uri)) {
            subSchema.setParent(this);
        }
        return subSchema;
    }

    public Boolean isFalse() {
        if (this.schemaObject instanceof Boolean) {
            return (Boolean)this.schemaObject == false;
        }
        return false;
    }

    public String toString() {
        return this.uri + " / " + this.schemaObject;
    }

    public boolean isExclusiveMinimumBoolean() {
        if (this.exclusiveMinimum instanceof Boolean) {
            return (Boolean)this.exclusiveMinimum;
        }
        return false;
    }

    public boolean isExclusiveMaximumBoolean() {
        if (this.exclusiveMaximum instanceof Boolean) {
            return (Boolean)this.exclusiveMaximum;
        }
        return false;
    }

    public Object getSchemaObject() {
        return this.schemaObject;
    }

    public URI getUri() {
        return this.uri;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getExclusiveMaximum() {
        if (this.exclusiveMaximum instanceof Number) {
            return (Number)this.exclusiveMaximum;
        }
        return null;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getExclusiveMinimum() {
        if (this.exclusiveMinimum instanceof Number) {
            return (Number)this.exclusiveMinimum;
        }
        return null;
    }

    public Number getDivisibleBy() {
        return this.divisibleBy;
    }

    public Number getMaxLength() {
        return this.maxLength;
    }

    public Number getMinLength() {
        return this.minLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFormat() {
        return this.format;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentMediaType() {
        return this.contentMediaType;
    }

    public Schema getAdditionalItems() {
        return this.additionalItems;
    }

    public Schema getUnevaluatedItems() {
        return this.unevaluatedItems;
    }

    public Schema getItems() {
        return this._items;
    }

    public List<Schema> getItemsTuple() {
        return this.itemsTuple == null ? null : Collections.unmodifiableList(this.itemsTuple);
    }

    public Number getMaxItems() {
        return this.maxItems;
    }

    public Number getMinItems() {
        return this.minItems;
    }

    public Schema getContains() {
        return this.contains;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public Number getMinContains() {
        return this.minContains;
    }

    public Number getMaxContains() {
        return this.maxContains;
    }

    public Number getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinProperties() {
        return this.minProperties;
    }

    public Collection<String> getRequiredProperties() {
        return Collections.unmodifiableCollection(this.requiredProperties);
    }

    public boolean isRequired() {
        return this.required;
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Schema getUnevaluatedProperties() {
        return this.unevaluatedProperties;
    }

    public Map<String, Schema> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public Collection<String> getPatternPropertiesPatterns() {
        return Collections.unmodifiableCollection(this.patternPropertiesPatterns);
    }

    public Collection<Schema> getPatternPropertiesSchema() {
        return Collections.unmodifiableCollection(this.patternPropertiesSchemas);
    }

    public Map<String, Collection<String>> getDependentRequired() {
        return Collections.unmodifiableMap(this.dependentRequired);
    }

    public Map<String, Schema> getDependentSchemas() {
        return Collections.unmodifiableMap(this.dependentSchemas);
    }

    public Schema getPropertyNames() {
        return this.propertyNames;
    }

    public boolean hasConst() {
        return this.hasConst;
    }

    public Object getConst() {
        return this._const;
    }

    public List<Object> getEnums() {
        return this.enums == null ? null : Collections.unmodifiableList(this.enums);
    }

    public Collection<String> getExplicitTypes() {
        if (this.explicitTypes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.explicitTypes);
    }

    public Collection<Schema> getTypesSchema() {
        return Collections.unmodifiableCollection(this.typesSchema);
    }

    public Schema getIf() {
        return this._if;
    }

    public Schema getThen() {
        return this._then;
    }

    public Schema getElse() {
        return this._else;
    }

    public Collection<Schema> getAllOf() {
        return Collections.unmodifiableCollection(this.allOf);
    }

    public Collection<Schema> getAnyOf() {
        return this.anyOf == null ? null : Collections.unmodifiableCollection(this.anyOf);
    }

    public Collection<Schema> getOneOf() {
        return this.oneOf == null ? null : Collections.unmodifiableCollection(this.oneOf);
    }

    public Schema getNot() {
        return this.not;
    }

    public Schema getRef() {
        return this.ref;
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public Schema getRecursiveRef() {
        return this.recursiveRef;
    }

    public Collection<String> getDisallow() {
        return Collections.unmodifiableCollection(this.disallow);
    }

    public Collection<Schema> getDisallowSchemas() {
        return Collections.unmodifiableCollection(this.disallowSchemas);
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public List<Object> getExamples() {
        return this.examples;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema getParent() {
        return this.parent;
    }

    protected void setParent(Schema parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Schemas may only have one parent");
        }
        this.parent = parent;
    }

    public URI getMetaSchema() {
        if (this.metaSchema == null) {
            this.metaSchema = MetaSchemaDetector.detectMetaSchema(this.schemaStore.getBaseObject(this.uri));
        }
        return this.metaSchema;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        return this.uri.equals(((Schema)obj).getUri());
    }
}

