/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.test.support;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzTester {
    private static final int THREADS = 8;
    public static final int SHORT_ITERATION = 10;
    private final Duration sleepFor;
    private final Duration lockAtMostFor;
    private final int iterations;
    private final LockingTaskExecutor lockingTaskExecutor;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FuzzTester(LockProvider lockProvider) {
        this(lockProvider, Duration.ofMillis(1L), Duration.of(5L, ChronoUnit.MINUTES), 100);
    }

    public FuzzTester(LockProvider lockProvider, Duration sleepFor, Duration lockAtMostFor, int iterations) {
        this.sleepFor = sleepFor;
        this.lockAtMostFor = lockAtMostFor;
        this.iterations = iterations;
        this.lockingTaskExecutor = new DefaultLockingTaskExecutor(lockProvider);
    }

    public void doFuzzTest() throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(8);
        int[] iters = IntStream.range(0, 8).map(i -> this.iterations).toArray();
        iters[0] = 10;
        Job job1 = new Job("lock1", this.lockAtMostFor);
        Job job2 = new Job("lock2", this.lockAtMostFor);
        List tasks = IntStream.range(0, 8).mapToObj(i -> () -> this.task(iters[i], i % 2 == 0 ? job1 : job2)).collect(Collectors.toList());
        this.waitForIt(executor.invokeAll(tasks));
        Assertions.assertThat((int)job2.getCounter()).isEqualTo(4 * this.iterations);
        Assertions.assertThat((int)job1.getCounter()).isEqualTo(3 * this.iterations + 10);
        this.sleepFor(job1.getLockConfiguration().getLockAtLeastFor());
    }

    private void waitForIt(List<Future<Void>> futures) throws InterruptedException, ExecutionException {
        for (Future<Void> f : futures) {
            f.get();
        }
    }

    protected Void task(int iterations, Job job) {
        try {
            AtomicInteger i = new AtomicInteger(0);
            while (i.get() < iterations) {
                this.lockingTaskExecutor.executeWithLock(() -> {
                    int n = job.getCounter();
                    if (this.shouldLog()) {
                        this.logger.debug("action=getLock value={} i={}", (Object)n, (Object)i);
                    }
                    this.sleep();
                    if (this.shouldLog()) {
                        this.logger.debug("action=setCounter value={} i={}", (Object)(n + 1), (Object)i);
                    }
                    job.setCounter(n + 1);
                    i.incrementAndGet();
                }, job.getLockConfiguration());
            }
            this.logger.debug("action=finished");
            return null;
        }
        catch (RuntimeException e) {
            this.logger.error("Unexpected exception", (Throwable)e);
            throw e;
        }
    }

    protected boolean shouldLog() {
        return false;
    }

    private void sleepFor(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void sleep() {
        this.sleepFor(this.sleepFor);
    }

    protected static class Job {
        private final String lockName;
        private int counter = 0;
        private final Duration lockAtMostFor;

        Job(String lockName, Duration lockAtMostFor) {
            this.lockName = lockName;
            this.lockAtMostFor = lockAtMostFor;
        }

        public LockConfiguration getLockConfiguration() {
            return new LockConfiguration(ClockProvider.now(), this.lockName, this.lockAtMostFor, Duration.of(5L, ChronoUnit.MILLIS));
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }
    }
}

