/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.test.support;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.test.support.FuzzTester;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public abstract class AbstractLockProviderIntegrationTest {
    protected final String LOCK_NAME1 = UUID.randomUUID().toString();
    public static final Duration LOCK_AT_LEAST_FOR = Duration.of(2L, ChronoUnit.SECONDS);

    protected abstract LockProvider getLockProvider();

    protected abstract void assertUnlocked(String var1);

    protected abstract void assertLocked(String var1);

    @Test
    public void shouldCreateLock() {
        Optional lock = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        Assertions.assertThat((Optional)lock).isNotEmpty();
        this.assertLocked(this.LOCK_NAME1);
        ((SimpleLock)lock.get()).unlock();
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldNotReturnSecondLock() {
        LockProvider lockProvider = this.getLockProvider();
        Optional lock = lockProvider.lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        Assertions.assertThat((Optional)lock).isNotEmpty();
        Assertions.assertThat((Optional)lockProvider.lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1))).isEmpty();
        ((SimpleLock)lock.get()).unlock();
    }

    @Test
    public void shouldCreateTwoIndependentLocks() {
        Optional lock1 = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        Assertions.assertThat((Optional)lock1).isNotEmpty();
        Optional lock2 = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig("name2"));
        Assertions.assertThat((Optional)lock2).isNotEmpty();
        ((SimpleLock)lock1.get()).unlock();
        ((SimpleLock)lock2.get()).unlock();
    }

    @Test
    public void shouldLockTwiceInARow() {
        LockProvider lockProvider = this.getLockProvider();
        Optional lock1 = lockProvider.lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        Assertions.assertThat((Optional)lock1).isNotEmpty();
        ((SimpleLock)lock1.get()).unlock();
        Optional lock2 = lockProvider.lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        Assertions.assertThat((Optional)lock2).isNotEmpty();
        ((SimpleLock)lock2.get()).unlock();
    }

    @Test
    public void shouldTimeout() throws InterruptedException {
        this.doTestTimeout(Duration.ofMillis(50L));
    }

    protected void doTestTimeout(Duration lockAtMostFor) throws InterruptedException {
        LockConfiguration configWithShortTimeout = AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1, lockAtMostFor, Duration.ZERO);
        Optional lock1 = this.getLockProvider().lock(configWithShortTimeout);
        Assertions.assertThat((Optional)lock1).isNotEmpty();
        Thread.sleep(lockAtMostFor.toMillis() * 2L);
        this.assertUnlocked(this.LOCK_NAME1);
        Optional lock2 = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1, Duration.ofMillis(50L), Duration.ZERO));
        Assertions.assertThat((Optional)lock2).isNotEmpty();
        ((SimpleLock)lock2.get()).unlock();
    }

    @Test
    public void shouldBeAbleToLockRightAfterUnlock() {
        LockConfiguration lockConfiguration = AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1);
        for (int i = 0; i < 10; ++i) {
            Optional lock = this.getLockProvider().lock(lockConfiguration);
            ((OptionalAssert)Assertions.assertThat((Optional)lock).describedAs("Successfully locked " + i, new Object[0])).isNotEmpty();
            Assertions.assertThat((Optional)this.getLockProvider().lock(lockConfiguration)).isEmpty();
            ((SimpleLock)lock.get()).unlock();
        }
    }

    @Test
    public void fuzzTestShouldPass() throws ExecutionException, InterruptedException {
        new FuzzTester(this.getLockProvider()).doFuzzTest();
    }

    @Test
    public void shouldLockAtLeastFor() throws InterruptedException {
        this.doTestShouldLockAtLeastFor(100);
    }

    protected void doTestShouldLockAtLeastFor(int sleepForMs) throws InterruptedException {
        Optional lock1 = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1, LOCK_AT_LEAST_FOR.multipliedBy(2L), LOCK_AT_LEAST_FOR));
        ((OptionalAssert)Assertions.assertThat((Optional)lock1).describedAs("Should be locked", new Object[0])).isNotEmpty();
        ((SimpleLock)lock1.get()).unlock();
        ((OptionalAssert)Assertions.assertThat((Optional)this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1))).describedAs(this.getClass().getName() + "Can not acquire lock, grace period did not pass yet", new Object[0])).isEmpty();
        Thread.sleep(LOCK_AT_LEAST_FOR.toMillis() + (long)sleepForMs);
        Optional lock3 = this.getLockProvider().lock(AbstractLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1));
        ((OptionalAssert)Assertions.assertThat((Optional)lock3).describedAs(this.getClass().getName() + "Can acquire the lock after grace period", new Object[0])).isNotEmpty();
        ((SimpleLock)lock3.get()).unlock();
    }

    protected void sleepFor(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static LockConfiguration lockConfig(String name) {
        return AbstractLockProviderIntegrationTest.lockConfig(name, Duration.of(5L, ChronoUnit.MINUTES), Duration.ZERO);
    }

    protected static LockConfiguration lockConfig(String name, Duration lockAtMostFor, Duration lockAtLeastFor) {
        return new LockConfiguration(ClockProvider.now(), name, lockAtMostFor, lockAtLeastFor);
    }
}

