/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.test.support;

import java.time.Duration;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.test.support.AbstractLockProviderIntegrationTest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public abstract class AbstractExtensibleLockProviderIntegrationTest
extends AbstractLockProviderIntegrationTest {
    private final Duration originalLockDuration = Duration.ofSeconds(2L);

    protected abstract ExtensibleLockProvider getLockProvider();

    @Test
    public void shouldBeAbleToExtendLock() {
        SimpleLock lock = this.lock(this.originalLockDuration);
        SimpleLock newLock = this.extendLock(lock);
        this.sleepFor(this.originalLockDuration);
        this.assertLocked(this.LOCK_NAME1);
        newLock.unlock();
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldBeAbleToExtendMultipleTimes() {
        SimpleLock lock = this.lock(this.originalLockDuration);
        SimpleLock newLock = this.extendLock(this.extendLock(this.extendLock(lock)));
        this.sleepFor(this.originalLockDuration);
        this.assertLocked(this.LOCK_NAME1);
        newLock.unlock();
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldNotBeAbleToExtendUnlockedLock() {
        SimpleLock lock = this.lock(this.originalLockDuration);
        lock.unlock();
        this.assertUnlocked(this.LOCK_NAME1);
        this.assertInvalidLock(() -> lock.extend(Duration.ofSeconds(10L), Duration.ZERO));
    }

    @Test
    public void shouldNotBeAbleToExtendExpiredLock() {
        Optional lock = this.getLockProvider().lock(AbstractExtensibleLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1, Duration.ofMillis(2L), Duration.ZERO));
        Assertions.assertThat((Optional)lock).isNotEmpty();
        this.sleepFor(Duration.ofMillis(4L));
        Optional newLock = ((SimpleLock)lock.get()).extend(Duration.ofSeconds(10L), Duration.ZERO);
        Assertions.assertThat((Optional)newLock).isEmpty();
        this.assertUnlocked(this.LOCK_NAME1);
    }

    @Test
    public void shouldBeAbleToExtendAtLeast() {
        SimpleLock lock = this.lock(Duration.ofSeconds(10L));
        SimpleLock newLock = this.extendLock(lock, Duration.ofSeconds(9L));
        newLock.unlock();
        this.assertLocked(this.LOCK_NAME1);
    }

    @Test
    public void lockCanNotBeExtendedTwice() {
        SimpleLock lock = this.lock(Duration.ofSeconds(10L));
        this.extendLock(lock, Duration.ofSeconds(9L));
        this.assertInvalidLock(() -> lock.extend(Duration.ofSeconds(10L), Duration.ofSeconds(9L)));
    }

    @Test
    public void lockCanNotBeUnlockedAfterExtending() {
        SimpleLock lock = this.lock(Duration.ofSeconds(10L));
        this.extendLock(lock, Duration.ofSeconds(9L));
        this.assertInvalidLock(() -> ((SimpleLock)lock).unlock());
    }

    private SimpleLock extendLock(SimpleLock lock) {
        return this.extendLock(lock, Duration.ZERO);
    }

    private SimpleLock extendLock(SimpleLock lock, Duration lockAtLeastFor) {
        Optional newLock = lock.extend(Duration.ofSeconds(10L), lockAtLeastFor);
        Assertions.assertThat((Optional)newLock).isNotEmpty();
        return (SimpleLock)newLock.get();
    }

    private SimpleLock lock(Duration lockAtMostFor) {
        Optional lock = this.getLockProvider().lock(AbstractExtensibleLockProviderIntegrationTest.lockConfig(this.LOCK_NAME1, lockAtMostFor, Duration.ZERO));
        Assertions.assertThat((Optional)lock).isNotEmpty();
        this.assertLocked(this.LOCK_NAME1);
        return (SimpleLock)lock.get();
    }

    private void assertInvalidLock(ThrowableAssert.ThrowingCallable operation) {
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)operation).isInstanceOf(IllegalStateException.class);
    }
}

