/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.zookeeper.curator;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCuratorLockProvider
implements LockProvider {
    public static final String DEFAULT_PATH = "/shedlock";
    private final String path;
    private final CuratorFramework client;
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperCuratorLockProvider.class);

    public ZookeeperCuratorLockProvider(@NonNull CuratorFramework client) {
        this(client, DEFAULT_PATH);
    }

    public ZookeeperCuratorLockProvider(@NonNull CuratorFramework client, @NonNull String path) {
        this.client = Objects.requireNonNull(client);
        this.path = PathUtils.validatePath((String)path);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        String nodePath = this.getNodePath(lockConfiguration.getName());
        try {
            Stat stat = new Stat();
            byte[] data = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(nodePath);
            if (this.isLocked(data)) {
                return Optional.empty();
            }
            return this.tryLock(lockConfiguration, nodePath, stat);
        }
        catch (KeeperException.NoNodeException e) {
            if (this.createNode(lockConfiguration, nodePath)) {
                return Optional.of(new CuratorLock(nodePath, this.client, lockConfiguration));
            }
            logger.trace("Node not created, must have been created by a parallel process");
            return Optional.empty();
        }
        catch (Exception e) {
            throw new LockException("Can not obtain lock node", (Throwable)e);
        }
    }

    private Optional<SimpleLock> tryLock(LockConfiguration lockConfiguration, String nodePath, Stat stat) throws Exception {
        try {
            ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(nodePath, ZookeeperCuratorLockProvider.serialize(lockConfiguration.getLockAtMostUntil()));
            return Optional.of(new CuratorLock(nodePath, this.client, lockConfiguration));
        }
        catch (KeeperException.BadVersionException e) {
            logger.trace("Node value can not be set, must have been set by a parallel process");
            return Optional.empty();
        }
    }

    private boolean createNode(LockConfiguration lockConfiguration, String nodePath) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(nodePath, ZookeeperCuratorLockProvider.serialize(lockConfiguration.getLockAtMostUntil()));
            return true;
        }
        catch (KeeperException.NodeExistsException e) {
            return false;
        }
        catch (Exception e) {
            throw new LockException("Can not create node", (Throwable)e);
        }
    }

    boolean isLocked(String nodePath) throws Exception {
        byte[] data = (byte[])this.client.getData().forPath(nodePath);
        return this.isLocked(data);
    }

    private boolean isLocked(byte[] data) {
        if (data == null || data.length == 0) {
            return true;
        }
        try {
            Instant lockedUntil = ZookeeperCuratorLockProvider.parse(data);
            return lockedUntil.isAfter(ClockProvider.now());
        }
        catch (DateTimeParseException e) {
            logger.debug("Can not parse date", (Throwable)e);
            return true;
        }
    }

    private static byte[] serialize(Instant date) {
        return Utils.toIsoString((Instant)date).getBytes();
    }

    private static Instant parse(byte[] data) {
        return Instant.parse(new String(data));
    }

    String getNodePath(String lockName) {
        return this.path + "/" + lockName;
    }

    private static final class CuratorLock
    extends AbstractSimpleLock {
        private final String nodePath;
        private final CuratorFramework client;

        private CuratorLock(String nodePath, CuratorFramework client, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.nodePath = nodePath;
            this.client = client;
        }

        public void doUnlock() {
            try {
                Instant unlockTime = this.lockConfiguration.getUnlockTime();
                this.client.setData().forPath(this.nodePath, ZookeeperCuratorLockProvider.serialize(unlockTime));
            }
            catch (Exception e) {
                throw new LockException("Can not remove node", (Throwable)e);
            }
        }
    }
}

