/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.zookeeper.curator;

import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZookeeperCuratorLockProvider
implements LockProvider {
    private final CuratorFramework client;

    public ZookeeperCuratorLockProvider(CuratorFramework client) {
        this.client = Objects.requireNonNull(client);
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(ZookeeperCuratorLockProvider.getNodeName(lockConfiguration));
            return Optional.of(new CuratorLock(lockConfiguration, this.client));
        }
        catch (KeeperException.NodeExistsException ex) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new LockException("Can not create node", (Throwable)e);
        }
    }

    private static String getNodeName(LockConfiguration lockConfiguration) {
        return "/" + lockConfiguration.getName();
    }

    private static final class CuratorLock
    implements SimpleLock {
        private final LockConfiguration configuration;
        private final CuratorFramework client;

        private CuratorLock(LockConfiguration configuration, CuratorFramework client) {
            this.configuration = configuration;
            this.client = client;
        }

        public void unlock() {
            try {
                this.client.delete().forPath(ZookeeperCuratorLockProvider.getNodeName(this.configuration));
            }
            catch (Exception e) {
                throw new LockException("Can not remove node", (Throwable)e);
            }
        }
    }
}

