/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.zookeeper.curator;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZookeeperCuratorLockProvider
implements LockProvider {
    public static final String DEFAULT_PATH = "/shedlock";
    private final String path;
    private final CuratorFramework client;

    public ZookeeperCuratorLockProvider(CuratorFramework client) {
        this(client, DEFAULT_PATH);
    }

    public ZookeeperCuratorLockProvider(CuratorFramework client, String path) {
        this.client = Objects.requireNonNull(client);
        this.path = PathUtils.validatePath((String)path);
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Instant now = Instant.now();
        if (lockConfiguration.getLockAtLeastUntil().isAfter(now)) {
            throw new UnsupportedOperationException("ZookeeperCuratorLockProvider does not support nonzero lockAtLeastUntil yet.");
        }
        try {
            String nodePath = this.getNodePath(lockConfiguration);
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(nodePath);
            return Optional.of(new CuratorLock(nodePath, this.client));
        }
        catch (KeeperException.NodeExistsException ex) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new LockException("Can not create node", (Throwable)e);
        }
    }

    private String getNodePath(LockConfiguration lockConfiguration) {
        return this.path + "/" + lockConfiguration.getName();
    }

    private static final class CuratorLock
    implements SimpleLock {
        private final String nodePath;
        private final CuratorFramework client;

        private CuratorLock(String nodePath, CuratorFramework client) {
            this.nodePath = nodePath;
            this.client = client;
        }

        public void unlock() {
            try {
                this.client.delete().forPath(this.nodePath);
            }
            catch (Exception e) {
                throw new LockException("Can not remove node", (Throwable)e);
            }
        }
    }
}

