/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.vertx.sqlclient;

import io.vertx.sqlclient.SqlClient;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.vertx.sqlclient.VertxSqlClientStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;

public class VertxSqlClientLockProvider
extends StorageBasedLockProvider {
    public VertxSqlClientLockProvider(Configuration configuration) {
        super((StorageAccessor)new VertxSqlClientStorageAccessor(configuration));
    }

    public static final class Configuration
    extends SqlConfiguration {
        private final SqlClient sqlClient;

        Configuration(SqlClient sqlClient, boolean dbUpperCase, DatabaseProduct databaseProduct, String tableName, SqlConfiguration.ColumnNames columnNames, String lockedByValue, boolean useDbTime) {
            super(databaseProduct, dbUpperCase, tableName, useDbTime ? null : TimeZone.getTimeZone("UTC"), columnNames, lockedByValue, useDbTime);
            this.sqlClient = Objects.requireNonNull(sqlClient, "sqlClient can not be null");
        }

        public SqlClient getSqlClient() {
            return this.sqlClient;
        }

        public static Builder builder(SqlClient sqlClient, DatabaseProduct databaseProduct) {
            return (Builder)new Builder(sqlClient).withDatabaseProduct(databaseProduct);
        }

        public static final class Builder
        extends SqlConfiguration.SqlConfigurationBuilder<Builder> {
            private final SqlClient sqlClient;

            public Builder(SqlClient sqlClient) {
                this.sqlClient = sqlClient;
            }

            public Configuration build() {
                return new Configuration(this.sqlClient, this.dbUpperCase, Objects.requireNonNull(this.databaseProduct), this.tableName, this.columnNames, this.lockedByValue, this.useDbTime);
            }
        }
    }
}

