/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.spanner.SpannerLockProvider;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;

class SpannerStorageAccessor
extends AbstractStorageAccessor {
    private final String table;
    private final String name;
    private final String lockedBy;
    private final String lockUntil;
    private final String lockedAt;
    private final String hostname;
    private final DatabaseClient databaseClient;

    public SpannerStorageAccessor(SpannerLockProvider.Configuration configuration) {
        SpannerLockProvider.TableConfiguration tableConfiguration = configuration.getTableConfiguration();
        this.lockUntil = tableConfiguration.getLockUntil();
        this.lockedAt = tableConfiguration.getLockedAt();
        this.lockedBy = tableConfiguration.getLockedBy();
        this.table = tableConfiguration.getTableName();
        this.name = tableConfiguration.getLockName();
        this.databaseClient = configuration.getDatabaseClient();
        this.hostname = configuration.getHostname();
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.run(tx -> this.findLock(tx, lockConfiguration.getName()).map(lock -> false).orElseGet(() -> {
            tx.buffer(this.buildMutation(lockConfiguration, Mutation.newInsertBuilder((String)this.table)));
            return true;
        })));
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.run(tx -> this.findLock(tx, lockConfiguration.getName()).filter(lock -> lock.lockedUntil().compareTo(Timestamp.now()) <= 0).map(lock -> {
            tx.buffer(this.buildMutation(lockConfiguration, Mutation.newUpdateBuilder((String)this.table)));
            return true;
        }).orElse(false)));
    }

    private Mutation buildMutation(LockConfiguration lockConfiguration, Mutation.WriteBuilder builder) {
        return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)builder.set(this.name).to(lockConfiguration.getName())).set(this.lockUntil).to(this.toTimestamp(lockConfiguration.getLockAtMostUntil()))).set(this.lockedAt).to(Timestamp.now())).set(this.lockedBy).to(this.hostname)).build();
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(this.run(tx -> this.findLock(tx, lockConfiguration.getName()).filter(lock -> this.hostname.equals(lock.lockedBy())).filter(lock -> lock.lockedUntil().compareTo(Timestamp.now()) > 0).map(lock -> {
            tx.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.table).set(this.name).to(lockConfiguration.getName())).set(this.lockUntil).to(this.toTimestamp(lockConfiguration.getLockAtMostUntil()))).build());
            return true;
        }).orElse(false)));
    }

    public void unlock(LockConfiguration lockConfiguration) {
        this.run(tx -> {
            this.findLock(tx, lockConfiguration.getName()).filter(lock -> this.hostname.equals(lock.lockedBy())).ifPresent(lock -> tx.buffer(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.table).set(this.name).to(lockConfiguration.getName())).set(this.lockUntil).to(this.toTimestamp(lockConfiguration.getUnlockTime()))).build()));
            return null;
        });
    }

    @Nullable
    private <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        try {
            return (T)this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(callable);
        }
        catch (Exception e) {
            throw new LockException("Spanner transaction failed", (Throwable)e);
        }
    }

    Optional<Lock> findLock(TransactionContext tx, String lockName) {
        return Optional.ofNullable(tx.readRow(this.table, Key.of((Object[])new Object[]{lockName}), List.of(this.name, this.lockUntil, this.lockedBy, this.lockedAt))).map(this::newLock);
    }

    Lock newLock(Struct row) {
        return new Lock(row.getString(this.name), row.getString(this.lockedBy), row.getTimestamp(this.lockedAt), row.getTimestamp(this.lockUntil));
    }

    private Timestamp toTimestamp(Instant instant) {
        return Timestamp.ofTimeSecondsAndNanos((long)instant.getEpochSecond(), (int)instant.getNano());
    }

    record Lock(String lockName, String lockedBy, Timestamp lockedAt, Timestamp lockedUntil) {
    }
}

