/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.spanner;

import com.google.cloud.spanner.DatabaseClient;
import java.util.Objects;
import net.javacrumbs.shedlock.provider.spanner.SpannerStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import net.javacrumbs.shedlock.support.Utils;
import org.jspecify.annotations.Nullable;

public class SpannerLockProvider
extends StorageBasedLockProvider {
    public SpannerLockProvider(DatabaseClient databaseClient) {
        this(Configuration.builder().withDatabaseClient(databaseClient).build());
    }

    public SpannerLockProvider(Configuration configuration) {
        super((StorageAccessor)new SpannerStorageAccessor(configuration));
    }

    public static final class Configuration {
        private final DatabaseClient databaseClient;
        private final String hostname;
        private final TableConfiguration tableConfiguration;

        private Configuration(Builder builder) {
            this.databaseClient = Objects.requireNonNull(builder.databaseClient, "databaseClient must be set");
            this.tableConfiguration = builder.tableConfiguration;
            this.hostname = builder.hostname;
        }

        public static Builder builder() {
            return new Builder();
        }

        public DatabaseClient getDatabaseClient() {
            return this.databaseClient;
        }

        public String getHostname() {
            return this.hostname;
        }

        public TableConfiguration getTableConfiguration() {
            return this.tableConfiguration;
        }

        public static final class Builder {
            private @Nullable DatabaseClient databaseClient;
            private String hostname = Utils.getHostname();
            private TableConfiguration tableConfiguration = TableConfiguration.builder().withTableName("shedlock").withLockName("name").withLockedBy("locked_by").withLockedAt("locked_at").withLockUntil("lock_until").build();

            private Builder() {
            }

            public Builder withDatabaseClient(DatabaseClient databaseClient) {
                this.databaseClient = databaseClient;
                return this;
            }

            public Builder withHostName(String hostname) {
                this.hostname = hostname;
                return this;
            }

            public Builder withTableConfiguration(TableConfiguration tableConfiguration) {
                this.tableConfiguration = tableConfiguration;
                return this;
            }

            public Configuration build() {
                return new Configuration(this);
            }
        }
    }

    public static final class TableConfiguration {
        private final String tableName;
        private final String lockName;
        private final String lockUntil;
        private final String lockedAt;
        private final String lockedBy;

        private TableConfiguration(Builder builder) {
            this.tableName = Objects.requireNonNull(builder.tableName, "tableName must be set");
            this.lockName = Objects.requireNonNull(builder.lockName, "lockName must be set");
            this.lockUntil = Objects.requireNonNull(builder.lockUntil, "lockUntil must be set");
            this.lockedAt = Objects.requireNonNull(builder.lockedAt, "lockedAt must be set");
            this.lockedBy = Objects.requireNonNull(builder.lockedBy, "lockedBy must be set");
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getLockName() {
            return this.lockName;
        }

        public String getLockUntil() {
            return this.lockUntil;
        }

        public String getLockedAt() {
            return this.lockedAt;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        public static final class Builder {
            private @Nullable String tableName;
            private @Nullable String lockName;
            private @Nullable String lockUntil;
            private @Nullable String lockedAt;
            private @Nullable String lockedBy;

            private Builder() {
            }

            public Builder withTableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder withLockName(String lockNameColumn) {
                this.lockName = lockNameColumn;
                return this;
            }

            public Builder withLockUntil(String lockUntilColumn) {
                this.lockUntil = lockUntilColumn;
                return this;
            }

            public Builder withLockedAt(String lockedAtColumn) {
                this.lockedAt = lockedAtColumn;
                return this;
            }

            public Builder withLockedBy(String lockedByColumn) {
                this.lockedBy = lockedByColumn;
                return this;
            }

            public TableConfiguration build() {
                return new TableConfiguration(this);
            }
        }
    }
}

