/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.lettuce;

import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockProvider;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockTemplate;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class LettuceLockProvider
implements ExtensibleLockProvider {
    private final InternalRedisLockProvider internalRedisLockProvider;

    public LettuceLockProvider(@NonNull StatefulRedisConnection<String, String> connection) {
        this(connection, "default");
    }

    public LettuceLockProvider(@NonNull StatefulRedisConnection<String, String> connection, @NonNull String environment) {
        this(connection, environment, false);
    }

    public LettuceLockProvider(@NonNull StatefulRedisConnection<String, String> connection, @NonNull String environment, boolean safeUpdate) {
        this.internalRedisLockProvider = new InternalRedisLockProvider((InternalRedisLockTemplate)new LettuceRedisLockTemplate(connection), environment, "job-lock", safeUpdate);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        return this.internalRedisLockProvider.lock(lockConfiguration);
    }

    private record LettuceRedisLockTemplate(StatefulRedisConnection<String, String> connection) implements InternalRedisLockTemplate
    {
        public boolean setIfAbsent(String key, String value, long expirationMs) {
            return this.set(key, value, SetArgs.Builder.nx().px(expirationMs));
        }

        public boolean setIfPresent(String key, String value, long expirationMs) {
            return this.set(key, value, SetArgs.Builder.xx().px(expirationMs));
        }

        private boolean set(String key, String value, SetArgs args) {
            return "OK".equals(this.connection.sync().set((Object)key, (Object)value, args));
        }

        public Object eval(String script, String key, String ... values) {
            return this.connection.sync().eval(script, ScriptOutputType.INTEGER, (Object[])new String[]{key}, (Object[])values);
        }

        public void delete(String key) {
            this.connection.sync().del((Object[])new String[]{key});
        }
    }
}

