/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.lettuce;

import io.lettuce.core.SetArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class LettuceLockProvider
implements ExtensibleLockProvider {
    private static final String KEY_PREFIX = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final StatefulRedisConnection<String, String> connection;
    private final String environment;

    public LettuceLockProvider(@NonNull StatefulRedisConnection<String, String> connection) {
        this(connection, ENV_DEFAULT);
    }

    public LettuceLockProvider(@NonNull StatefulRedisConnection<String, String> connection, @NonNull String environment) {
        this.connection = connection;
        this.environment = environment;
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        long expireTime = LettuceLockProvider.getMsUntil(lockConfiguration.getLockAtMostUntil());
        String key = LettuceLockProvider.buildKey(lockConfiguration.getName(), this.environment);
        String rez = this.connection.sync().set((Object)key, (Object)LettuceLockProvider.buildValue(), SetArgs.Builder.nx().px(expireTime));
        if ("OK".equals(rez)) {
            return Optional.of(new RedisLock(key, this.connection, lockConfiguration));
        }
        return Optional.empty();
    }

    static String buildKey(String lockName, String environment) {
        return String.format("%s:%s:%s", KEY_PREFIX, environment, lockName);
    }

    private static long getMsUntil(Instant instant) {
        return Duration.between(ClockProvider.now(), instant).toMillis();
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname());
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final StatefulRedisConnection<String, String> connection;

        private RedisLock(String key, StatefulRedisConnection<String, String> connection, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.connection = connection;
        }

        public void doUnlock() {
            long keepLockFor = LettuceLockProvider.getMsUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                try {
                    this.connection.sync().del((Object[])new String[]{this.key});
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                this.connection.sync().set((Object)this.key, (Object)LettuceLockProvider.buildValue(), SetArgs.Builder.xx().px(keepLockFor));
            }
        }

        @NonNull
        protected Optional<SimpleLock> doExtend(@NonNull LockConfiguration newConfiguration) {
            long expiryMs = LettuceLockProvider.getMsUntil(newConfiguration.getLockAtMostUntil());
            String result = this.connection.sync().set((Object)this.key, (Object)LettuceLockProvider.buildValue(), SetArgs.Builder.xx().px(expiryMs));
            if ("OK".equals(result)) {
                return Optional.of(new RedisLock(this.key, this.connection, newConfiguration));
            }
            return Optional.empty();
        }
    }
}

