/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.jedis4;

import java.util.List;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockProvider;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockTemplate;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.Pool;

public class JedisLockProvider
implements ExtensibleLockProvider {
    private final InternalRedisLockProvider internalRedisLockProvider;

    public JedisLockProvider(@NonNull Pool<Jedis> jedisPool) {
        this(jedisPool, "default");
    }

    public JedisLockProvider(@NonNull Pool<Jedis> jedisPool, @NonNull String environment) {
        this(jedisPool, environment, false);
    }

    public JedisLockProvider(@NonNull Pool<Jedis> jedisPool, @NonNull String environment, boolean safeUpdate) {
        this.internalRedisLockProvider = new InternalRedisLockProvider((InternalRedisLockTemplate)new JedisPoolTemplate(jedisPool), environment, "job-lock", safeUpdate);
    }

    public JedisLockProvider(@NonNull JedisCommands jedisCommands, @NonNull String environment) {
        this(jedisCommands, environment, false);
    }

    public JedisLockProvider(@NonNull JedisCommands jedisCommands, @NonNull String environment, boolean safeUpdate) {
        this.internalRedisLockProvider = new InternalRedisLockProvider((InternalRedisLockTemplate)new JedisCommandsTemplate(jedisCommands), environment, "job-lock", safeUpdate);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        return this.internalRedisLockProvider.lock(lockConfiguration);
    }

    private record JedisPoolTemplate(Pool<Jedis> jedisPool) implements InternalRedisLockTemplate
    {
        public boolean setIfAbsent(String key, String value, long expirationMs) {
            return this.set(key, value, SetParams.setParams().nx().px(expirationMs));
        }

        public boolean setIfPresent(String key, String value, long expirationMs) {
            return this.set(key, value, SetParams.setParams().xx().px(expirationMs));
        }

        private boolean set(String key, String value, SetParams params) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                boolean bl = "OK".equals(jedis.set(key, value, params));
                return bl;
            }
        }

        public Object eval(String script, String key, String ... values) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                Object object = jedis.eval(script, List.of(key), List.of(values));
                return object;
            }
        }

        public void delete(String key) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.del(key);
            }
        }
    }

    private record JedisCommandsTemplate(JedisCommands jedisCommands) implements InternalRedisLockTemplate
    {
        public boolean setIfAbsent(String key, String value, long expirationMs) {
            return this.set(key, value, SetParams.setParams().nx().px(expirationMs));
        }

        public boolean setIfPresent(String key, String value, long expirationMs) {
            return this.set(key, value, SetParams.setParams().xx().px(expirationMs));
        }

        private boolean set(String key, String value, SetParams params) {
            return "OK".equals(this.jedisCommands.set(key, value, params));
        }

        public Object eval(String script, String key, String ... values) {
            return this.jedisCommands.eval(script, List.of(key), List.of(values));
        }

        public void delete(String key) {
            this.jedisCommands.del(key);
        }
    }
}

