/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.ConnectionFactory;
import java.util.Objects;
import java.util.TimeZone;
import net.javacrumbs.shedlock.provider.r2dbc.R2dbcStorageAccessor;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.jspecify.annotations.Nullable;

public class R2dbcLockProvider
extends StorageBasedLockProvider {
    public R2dbcLockProvider(ConnectionFactory connectionFactory) {
        this(Configuration.builder(connectionFactory).build());
    }

    public R2dbcLockProvider(ConnectionFactory connectionFactory, String tableName) {
        this(((Configuration.Builder)Configuration.builder(connectionFactory).withTableName(tableName)).build());
    }

    public R2dbcLockProvider(Configuration configuration) {
        super((StorageAccessor)new R2dbcStorageAccessor(configuration));
    }

    public static final class Configuration
    extends SqlConfiguration {
        private final ConnectionFactory connectionFactory;

        Configuration(ConnectionFactory connectionFactory, boolean dbUpperCase, @Nullable DatabaseProduct databaseProduct, String tableName, SqlConfiguration.ColumnNames columnNames, String lockedByValue, boolean useDbTime, boolean forceUtcTimeZone) {
            super(databaseProduct, dbUpperCase, tableName, !useDbTime && forceUtcTimeZone ? TimeZone.getTimeZone("UTC") : null, columnNames, lockedByValue, useDbTime);
            this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory can not be null");
        }

        public ConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }

        public DatabaseProduct getDatabaseProduct() {
            if (super.getDatabaseProduct() != null) {
                return super.getDatabaseProduct();
            }
            return switch (this.connectionFactory.getMetadata().getName()) {
                case "Microsoft SQL Server" -> DatabaseProduct.SQL_SERVER;
                case "MySQL", "Jasync-MySQL" -> DatabaseProduct.MY_SQL;
                case "MariaDB" -> DatabaseProduct.MARIA_DB;
                case "Oracle Database" -> DatabaseProduct.ORACLE;
                case "PostgreSQL" -> DatabaseProduct.POSTGRES_SQL;
                case "H2" -> DatabaseProduct.H2;
                default -> DatabaseProduct.UNKNOWN;
            };
        }

        public static Builder builder(ConnectionFactory connectionFactory) {
            return new Builder(connectionFactory);
        }

        public static final class Builder
        extends SqlConfiguration.SqlConfigurationBuilder<Builder> {
            private final ConnectionFactory connectionFactory;
            private boolean forceUtcTimeZone;

            Builder(ConnectionFactory connectionFactory) {
                this.connectionFactory = connectionFactory;
            }

            public Builder forceUtcTimeZone(boolean forceDbTime) {
                this.forceUtcTimeZone = forceDbTime;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.connectionFactory, this.dbUpperCase, this.databaseProduct, this.tableName, this.columnNames, this.lockedByValue, this.useDbTime, this.forceUtcTimeZone);
            }
        }
    }
}

