/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.Statement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.function.Function;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;

abstract class R2dbcAdapter {
    R2dbcAdapter() {
    }

    static R2dbcAdapter create(DatabaseProduct databaseProduct) {
        return switch (databaseProduct) {
            case DatabaseProduct.SQL_SERVER -> new DefaultR2dbcAdapter((index, name) -> "@" + name, R2dbcAdapter::toLocalDateTime, R2dbcAdapter::bindByName);
            case DatabaseProduct.MY_SQL, DatabaseProduct.MARIA_DB -> new DefaultR2dbcAdapter((index, name) -> "?", R2dbcAdapter::toLocalDateTime, R2dbcAdapter::bindByIndex);
            case DatabaseProduct.ORACLE -> new DefaultR2dbcAdapter((index, name) -> ":" + name, R2dbcAdapter::toLocalDateTime, R2dbcAdapter::bindByName);
            default -> new DefaultR2dbcAdapter((index, name) -> "$" + index, R2dbcAdapter::toInstant, R2dbcAdapter::bindByIndex);
        };
    }

    private static Instant toInstant(ZonedDateTime date) {
        return date.toInstant();
    }

    private static LocalDateTime toLocalDateTime(ZonedDateTime dateTime) {
        return dateTime.toLocalDateTime();
    }

    private static void bindByName(Statement statement, int index, String name, Object value) {
        statement.bind(name, value);
    }

    private static void bindByIndex(Statement statement, int index, String name, Object value) {
        statement.bind(index, value);
    }

    protected abstract String toParameter(int var1, String var2);

    public abstract void bind(Statement var1, int var2, String var3, Object var4);

    private static class DefaultR2dbcAdapter
    extends R2dbcAdapter {
        private final ParameterResolver parameterResolver;
        private final Function<ZonedDateTime, Object> dateConverter;
        private final ValueBinder binder;

        private DefaultR2dbcAdapter(ParameterResolver parameterResolver, Function<ZonedDateTime, Object> dateConverter, ValueBinder binder) {
            this.parameterResolver = parameterResolver;
            this.dateConverter = dateConverter;
            this.binder = binder;
        }

        @Override
        protected String toParameter(int index, String name) {
            return this.parameterResolver.resolve(index, name);
        }

        @Override
        public void bind(Statement statement, int index, String name, Object value) {
            this.binder.bind(statement, index, name, this.normalizeValue(value));
        }

        private Object normalizeValue(Object value) {
            if (value instanceof ZonedDateTime) {
                ZonedDateTime dateTime = (ZonedDateTime)value;
                return this.dateConverter.apply(dateTime);
            }
            return value;
        }
    }

    @FunctionalInterface
    private static interface ParameterResolver {
        public String resolve(int var1, String var2);
    }

    @FunctionalInterface
    private static interface ValueBinder {
        public void bind(Statement var1, int var2, String var3, Object var4);
    }
}

