/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.r2dbc;

import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.Statement;
import java.time.Instant;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

abstract class AbstractR2dbcStorageAccessor
extends AbstractStorageAccessor {
    private final String tableName;

    public AbstractR2dbcStorageAccessor(@NonNull String tableName) {
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(Mono.from(this.insertRecordReactive(lockConfiguration)).block());
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(Mono.from(this.updateRecordReactive(lockConfiguration)).block());
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        return Boolean.TRUE.equals(Mono.from(this.extendReactive(lockConfiguration)).block());
    }

    public void unlock(@NonNull LockConfiguration lockConfiguration) {
        Mono.from(this.unlockReactive(lockConfiguration)).block();
    }

    public Publisher<Boolean> insertRecordReactive(@NonNull LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(" + this.toParameter(1, "name") + ", " + this.toParameter(2, "lock_until") + ", " + this.toParameter(3, "locked_at") + ", " + this.toParameter(4, "locked_by") + ")";
        return this.executeCommand(sql, statement -> {
            this.bind((Statement)statement, 0, "name", lockConfiguration.getName());
            this.bind((Statement)statement, 1, "lock_until", lockConfiguration.getLockAtMostUntil());
            this.bind((Statement)statement, 2, "locked_at", ClockProvider.now());
            this.bind((Statement)statement, 3, "locked_by", this.getHostname());
            return Mono.from((Publisher)statement.execute()).flatMap(it -> Mono.from((Publisher)it.getRowsUpdated())).map(it -> it > 0);
        }, this::handleInsertionException);
    }

    public Publisher<Boolean> updateRecordReactive(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = " + this.toParameter(1, "lock_until") + ", locked_at = " + this.toParameter(2, "locked_at") + ", locked_by = " + this.toParameter(3, "locked_by") + " WHERE name = " + this.toParameter(4, "name") + " AND lock_until <= " + this.toParameter(5, "now");
        return this.executeCommand(sql, statement -> {
            Instant now = ClockProvider.now();
            this.bind((Statement)statement, 0, "lock_until", lockConfiguration.getLockAtMostUntil());
            this.bind((Statement)statement, 1, "locked_at", now);
            this.bind((Statement)statement, 2, "locked_by", this.getHostname());
            this.bind((Statement)statement, 3, "name", lockConfiguration.getName());
            this.bind((Statement)statement, 4, "now", now);
            return Mono.from((Publisher)statement.execute()).flatMap(it -> Mono.from((Publisher)it.getRowsUpdated())).map(it -> it > 0);
        }, this::handleUpdateException);
    }

    public Publisher<Boolean> extendReactive(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = " + this.toParameter(1, "lock_until") + " WHERE name = " + this.toParameter(2, "name") + " AND locked_by = " + this.toParameter(3, "locked_by") + " AND lock_until > " + this.toParameter(4, "now");
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.executeCommand(sql, statement -> {
            this.bind((Statement)statement, 0, "lock_until", lockConfiguration.getLockAtMostUntil());
            this.bind((Statement)statement, 1, "name", lockConfiguration.getName());
            this.bind((Statement)statement, 2, "locked_by", this.getHostname());
            this.bind((Statement)statement, 3, "now", ClockProvider.now());
            return Mono.from((Publisher)statement.execute()).flatMap(it -> Mono.from((Publisher)it.getRowsUpdated())).map(it -> it > 0);
        }, this::handleUnlockException);
    }

    public Publisher<Void> unlockReactive(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = " + this.toParameter(1, "lock_until") + " WHERE name = " + this.toParameter(2, "name");
        return this.executeCommand(sql, statement -> {
            this.bind((Statement)statement, 0, "lock_until", lockConfiguration.getUnlockTime());
            this.bind((Statement)statement, 1, "name", lockConfiguration.getName());
            return Mono.from((Publisher)statement.execute()).flatMap(it -> Mono.from((Publisher)it.getRowsUpdated())).then();
        }, (s, t) -> this.handleUnlockException((String)s, (Throwable)t).then());
    }

    protected abstract <T> Mono<T> executeCommand(String var1, Function<Statement, Mono<T>> var2, BiFunction<String, Throwable, Mono<T>> var3);

    protected abstract String toParameter(int var1, String var2);

    protected abstract void bind(Statement var1, int var2, String var3, Object var4);

    Mono<Boolean> handleInsertionException(String sql, Throwable e) {
        if (!(e instanceof R2dbcDataIntegrityViolationException)) {
            this.logger.debug("Exception thrown when inserting record", e);
        }
        return Mono.just((Object)false);
    }

    Mono<Boolean> handleUpdateException(String sql, Throwable e) {
        return Mono.error((Throwable)new LockException("Unexpected exception when locking", e));
    }

    Mono<Boolean> handleUnlockException(String sql, Throwable e) {
        return Mono.error((Throwable)new LockException("Unexpected exception when unlocking", e));
    }
}

