/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.opensearch;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;

@Deprecated(forRemoval=true)
public class OpenSearchLockProvider
implements LockProvider {
    static final String SCHEDLOCK_DEFAULT_INDEX = "shedlock";
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String NAME = "name";
    private static final String UPDATE_SCRIPT = "if (ctx._source.lockUntil <= params.lockedAt) { ctx._source.lockedBy = params.lockedBy; ctx._source.lockedAt = params.lockedAt; ctx._source.lockUntil =  params.lockUntil; } else { ctx.op = 'none' }";
    private final RestHighLevelClient highLevelClient;
    private final String hostname;
    private final String index;

    public OpenSearchLockProvider(@NonNull RestHighLevelClient highLevelClient, @NonNull String index) {
        this.highLevelClient = highLevelClient;
        this.hostname = Utils.getHostname();
        this.index = index;
    }

    public OpenSearchLockProvider(@NonNull RestHighLevelClient highLevelClient) {
        this(highLevelClient, SCHEDLOCK_DEFAULT_INDEX);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        try {
            Map<String, Object> lockObject = this.lockObject(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil(), ClockProvider.now());
            UpdateRequest ur = this.updateRequest(lockConfiguration).script(new Script(ScriptType.INLINE, "painless", UPDATE_SCRIPT, lockObject)).upsert(lockObject);
            UpdateResponse res = this.highLevelClient.update(ur, RequestOptions.DEFAULT);
            if (res.getResult() != DocWriteResponse.Result.NOOP) {
                return Optional.of(new OpenSearchSimpleLock(lockConfiguration));
            }
            return Optional.empty();
        }
        catch (IOException | OpenSearchException e) {
            if (e instanceof OpenSearchException && ((OpenSearchException)e).status() == RestStatus.CONFLICT) {
                return Optional.empty();
            }
            throw new LockException("Unexpected exception occurred", e);
        }
    }

    private UpdateRequest updateRequest(@NonNull LockConfiguration lockConfiguration) {
        return ((UpdateRequest)new UpdateRequest().index(this.index)).id(lockConfiguration.getName()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    private Map<String, Object> lockObject(String name, Instant lockUntil, Instant lockedAt) {
        return Map.of(NAME, name, LOCKED_BY, this.hostname, LOCKED_AT, lockedAt.toEpochMilli(), LOCK_UNTIL, lockUntil.toEpochMilli());
    }

    private final class OpenSearchSimpleLock
    extends AbstractSimpleLock {
        private OpenSearchSimpleLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        public void doUnlock() {
            try {
                UpdateRequest ur = OpenSearchLockProvider.this.updateRequest(this.lockConfiguration).script(new Script(ScriptType.INLINE, "painless", "ctx._source.lockUntil = params.unlockTime", Collections.singletonMap("unlockTime", this.lockConfiguration.getUnlockTime().toEpochMilli())));
                OpenSearchLockProvider.this.highLevelClient.update(ur, RequestOptions.DEFAULT);
            }
            catch (IOException | OpenSearchException e) {
                throw new LockException("Unexpected exception occurred", e);
            }
        }
    }
}

