/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.neo4j;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;

class Neo4jStorageAccessor
extends AbstractStorageAccessor {
    private final String collectionName;
    private final Driver driver;
    private final @Nullable String databaseName;

    public Neo4jStorageAccessor(Driver driver, String collectionName, @Nullable String databaseName) {
        this.collectionName = Objects.requireNonNull(collectionName, "collectionName can not be null");
        this.driver = Objects.requireNonNull(driver, "driver can not be null");
        this.databaseName = databaseName;
        this.createLockNameUniqueConstraint();
    }

    private void createLockNameUniqueConstraint() {
        try (Session session = this.getSession();
             Transaction transaction = session.beginTransaction();){
            transaction.run(String.format("CREATE CONSTRAINT UNIQUE_%s_name IF NOT EXISTS FOR (lock:%s) REQUIRE lock.name IS UNIQUE", this.collectionName, this.collectionName));
            transaction.commit();
        }
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        String cypher = String.format("CYPHER runtime = slotted CREATE (lock:%s {name: $lockName, lock_until: $lockUntil, locked_at: $now, locked_by: $lockedBy })", this.collectionName);
        Map<String, Object> parameters = this.createParameterMap(lockConfiguration);
        return this.executeCommand(cypher, result -> {
            int insertedNodes = result.consume().counters().nodesCreated();
            return insertedNodes > 0;
        }, parameters, this::handleInsertionException);
    }

    private Map<String, Object> createParameterMap(LockConfiguration lockConfiguration) {
        return Map.of("lockName", lockConfiguration.getName(), "lockedBy", this.getHostname(), "now", ClockProvider.now().toString(), "lockUntil", lockConfiguration.getLockAtMostUntil().toString());
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        String cypher = String.format("CYPHER runtime = slotted MATCH (lock:%s) WHERE lock.name = $lockName AND lock.lock_until <= $now SET lock._LOCK_ = true WITH lock as l WHERE l.lock_until <= $now SET l.lock_until = $lockUntil, l.locked_at = $now, l.locked_by = $lockedBy REMOVE l._LOCK_ ", this.collectionName);
        Map<String, Object> parameters = this.createParameterMap(lockConfiguration);
        return this.executeCommand(cypher, statement -> {
            int updatedProperties = statement.consume().counters().propertiesSet();
            return updatedProperties > 1;
        }, parameters, this::handleUpdateException);
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        String cypher = String.format("CYPHER runtime = slotted MATCH (lock:%s) WHERE lock.name = $lockName AND lock.locked_by = $lockedBy AND lock.lock_until > $now SET lock._LOCK_ = true WITH lock as l WHERE l.name = $lockName AND l.locked_by = $lockedBy AND l.lock_until > $now SET l.lock_until = $lockUntil REMOVE l._LOCK_ ", this.collectionName);
        Map<String, Object> parameters = this.createParameterMap(lockConfiguration);
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.executeCommand(cypher, statement -> {
            int updatedProperties = statement.consume().counters().propertiesSet();
            return updatedProperties > 1;
        }, parameters, this::handleUnlockException);
    }

    public void unlock(LockConfiguration lockConfiguration) {
        String cypher = String.format("CYPHER runtime = slotted MATCH (lock:%s) WHERE lock.name = $lockName SET lock.lock_until = $lockUntil", this.collectionName);
        Map<String, Object> parameters = Map.of("lockName", lockConfiguration.getName(), "lockUntil", lockConfiguration.getUnlockTime().toString());
        this.executeCommand(cypher, statement -> Integer.valueOf(0), parameters, this::handleUnlockException);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T executeCommand(String cypher, Function<Result, T> body, Map<String, Object> parameters, BiFunction<String, Exception, T> exceptionHandler) {
        try (Session session = this.getSession();){
            Result result;
            block14: {
                Transaction transaction = session.beginTransaction();
                try {
                    Result result2 = transaction.run(cypher, parameters);
                    Result apply = body.apply(result2);
                    transaction.commit();
                    result = apply;
                    if (transaction == null) break block14;
                }
                catch (Throwable throwable) {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transaction.close();
            }
            return (T)result;
        }
        catch (Exception e) {
            return (T)exceptionHandler.apply(cypher, e);
        }
    }

    private Session getSession() {
        return this.databaseName == null ? this.driver.session() : this.driver.session(SessionConfig.forDatabase((String)this.databaseName));
    }

    boolean handleInsertionException(String cypher, Exception e) {
        return false;
    }

    boolean handleUpdateException(String cypher, Exception e) {
        throw new LockException("Unexpected exception when locking", (Throwable)e);
    }

    boolean handleUnlockException(String cypher, Exception e) {
        throw new LockException("Unexpected exception when unlocking", (Throwable)e);
    }
}

