/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import java.util.Date;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoLockProvider
extends StorageBasedLockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";

    public MongoLockProvider(MongoClient mongo, String databaseName) {
        this(mongo, databaseName, "shedLock");
    }

    public MongoLockProvider(MongoClient mongo, String databaseName, String collectionName) {
        this(new MongoAccessor(mongo, databaseName, collectionName));
    }

    MongoLockProvider(MongoAccessor mongoAccessor) {
        super((StorageBasedLockProvider.StorageAccessor)mongoAccessor);
    }

    static class MongoAccessor
    implements StorageBasedLockProvider.StorageAccessor {
        private final MongoClient mongo;
        private final String databaseName;
        private final String collectionName;
        private final String hostname;

        MongoAccessor(MongoClient mongo, String databaseName, String collectionName) {
            this.mongo = mongo;
            this.databaseName = databaseName;
            this.collectionName = collectionName;
            this.hostname = MongoLockProvider.getHostname();
        }

        public boolean insertRecord(LockConfiguration lockConfiguration) {
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.setOnInsert((String)MongoLockProvider.LOCK_UNTIL, (Object)Date.from(lockConfiguration.getLockUntil())), Updates.setOnInsert((String)MongoLockProvider.LOCKED_AT, (Object)MongoLockProvider.now()), Updates.setOnInsert((String)MongoLockProvider.LOCKED_BY, (Object)this.hostname)});
            try {
                Document result = (Document)this.getCollection().findOneAndUpdate(Filters.eq((String)MongoLockProvider.ID, (Object)lockConfiguration.getName()), update, new FindOneAndUpdateOptions().upsert(true));
                return result == null;
            }
            catch (MongoCommandException e) {
                if (e.getErrorCode() == 11000) {
                    return false;
                }
                throw e;
            }
        }

        public boolean updateRecord(LockConfiguration lockConfiguration) {
            Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)MongoLockProvider.LOCK_UNTIL, (Object)Date.from(lockConfiguration.getLockUntil())), Updates.set((String)MongoLockProvider.LOCKED_AT, (Object)MongoLockProvider.now()), Updates.set((String)MongoLockProvider.LOCKED_BY, (Object)this.hostname)});
            Document result = (Document)this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)MongoLockProvider.ID, (Object)lockConfiguration.getName()), Filters.lte((String)MongoLockProvider.LOCK_UNTIL, (Object)MongoLockProvider.now())}), update);
            return result != null;
        }

        public void unlock(LockConfiguration lockConfiguration) {
            this.getCollection().findOneAndUpdate(Filters.eq((String)MongoLockProvider.ID, (Object)lockConfiguration.getName()), Updates.combine((Bson[])new Bson[]{Updates.set((String)MongoLockProvider.LOCK_UNTIL, (Object)MongoLockProvider.now())}));
        }

        private MongoCollection<Document> getCollection() {
            return this.mongo.getDatabase(this.databaseName).getCollection(this.collectionName);
        }
    }
}

