/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    private final MongoClient mongo;
    private final String databaseName;
    private final String collectionName;
    private final String hostname;

    public MongoLockProvider(MongoClient mongo, String databaseName) {
        this(mongo, databaseName, "shedLock");
    }

    public MongoLockProvider(MongoClient mongo, String databaseName, String collectionName) {
        this.mongo = mongo;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.hostname = MongoLockProvider.getHostname();
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        boolean lockObtained = this.doLock(lockConfiguration);
        if (lockObtained) {
            return Optional.of(new MongoLock(lockConfiguration));
        }
        return Optional.empty();
    }

    protected boolean doLock(LockConfiguration lockConfiguration) {
        String name = lockConfiguration.getName();
        this.getCollection().findOneAndUpdate(Filters.eq((String)ID, (Object)name), Updates.setOnInsert((String)LOCK_UNTIL, (Object)this.now()), new FindOneAndUpdateOptions().upsert(true));
        Document result = (Document)this.getCollection().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)name), Filters.lte((String)LOCK_UNTIL, (Object)this.now())}), Updates.combine((Bson[])new Bson[]{Updates.set((String)LOCK_UNTIL, (Object)Date.from(lockConfiguration.getLockUntil())), Updates.set((String)LOCKED_AT, (Object)this.now()), Updates.set((String)LOCKED_BY, (Object)this.hostname)}));
        return result != null;
    }

    private Date now() {
        return new Date();
    }

    private MongoCollection<Document> getCollection() {
        return this.mongo.getDatabase(this.databaseName).getCollection(this.collectionName);
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    private class MongoLock
    implements SimpleLock {
        private final LockConfiguration lockConfiguration;

        public MongoLock(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
        }

        public void unlock() {
            MongoLockProvider.this.getCollection().findOneAndUpdate(Filters.eq((String)MongoLockProvider.ID, (Object)this.lockConfiguration.getName()), Updates.combine((Bson[])new Bson[]{Updates.set((String)MongoLockProvider.LOCK_UNTIL, (Object)MongoLockProvider.this.now())}));
        }
    }
}

