/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.memcached.spy;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.util.StringUtils;

public class MemcachedLockProvider
implements LockProvider {
    private static final String KEY_PREFIX = "shedlock";
    private static final String ENV_DEFAULT = "default";
    private final MemcachedClient client;
    private final String env;

    public MemcachedLockProvider(@NonNull MemcachedClient client) {
        this(client, ENV_DEFAULT);
    }

    public MemcachedLockProvider(@NonNull MemcachedClient client, @NonNull String env) {
        this.client = client;
        this.env = env;
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        long expireTime = MemcachedLockProvider.getSecondUntil(lockConfiguration.getLockAtMostUntil());
        String key = MemcachedLockProvider.buildKey(lockConfiguration.getName(), this.env);
        OperationStatus status = this.client.add(key, (int)expireTime, (Object)MemcachedLockProvider.buildValue()).getStatus();
        if (status.isSuccess()) {
            return Optional.of(new MemcachedLock(key, this.client, lockConfiguration));
        }
        return Optional.empty();
    }

    private static long getSecondUntil(Instant instant) {
        long millis = Duration.between(ClockProvider.now(), instant).toMillis();
        return millis / 1000L;
    }

    static String buildKey(String lockName, String env) {
        String k = String.format("%s:%s:%s", KEY_PREFIX, env, lockName);
        StringUtils.validateKey((String)k, (boolean)false);
        return k;
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname());
    }

    private static final class MemcachedLock
    extends AbstractSimpleLock {
        private final String key;
        private final MemcachedClient client;

        private MemcachedLock(@NonNull String key, @NonNull MemcachedClient client, @NonNull LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.client = client;
        }

        protected void doUnlock() {
            long keepLockFor = MemcachedLockProvider.getSecondUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                OperationStatus status = this.client.delete(this.key).getStatus();
                if (!status.isSuccess()) {
                    throw new LockException("Can not remove node. " + status.getMessage());
                }
            } else {
                OperationStatus status = this.client.replace(this.key, (int)keepLockFor, (Object)MemcachedLockProvider.buildValue()).getStatus();
                if (!status.isSuccess()) {
                    throw new LockException("Can not replace node. " + status.getMessage());
                }
            }
        }
    }
}

