/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jooq;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jooq.Shedlock;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.jooq.types.DayToSecond;

class JooqStorageAccessor
extends AbstractStorageAccessor {
    private final DSLContext dslContext;
    private final Shedlock t = Shedlock.SHEDLOCK;

    JooqStorageAccessor(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        return (Boolean)this.dslContext.transactionResult(tx -> tx.dsl().insertInto((Table)this.t).set(this.data(lockConfiguration)).onConflictDoNothing().execute() > 0);
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        return (Boolean)this.dslContext.transactionResult(tx -> tx.dsl().update((Table)this.t).set(this.data(lockConfiguration)).where(this.t.NAME.eq((Object)lockConfiguration.getName()).and(this.t.LOCK_UNTIL.le(this.now()))).execute() > 0);
    }

    public void unlock(LockConfiguration lockConfiguration) {
        Field lockAtLeastFor = this.t.LOCKED_AT.add((Number)DayToSecond.valueOf((Duration)lockConfiguration.getLockAtLeastFor()));
        this.dslContext.transaction(tx -> tx.dsl().update((Table)this.t).set(this.t.LOCK_UNTIL, DSL.when((Condition)lockAtLeastFor.gt(this.now()), (Field)lockAtLeastFor).otherwise(this.now())).where(this.t.NAME.eq((Object)lockConfiguration.getName()).and(this.t.LOCKED_BY.eq((Object)this.getHostname()))).execute());
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        return (Boolean)this.dslContext.transactionResult(tx -> tx.dsl().update((Table)this.t).set(this.t.LOCK_UNTIL, this.nowPlus(lockConfiguration.getLockAtMostFor())).where(this.t.NAME.eq((Object)lockConfiguration.getName()).and(this.t.LOCKED_BY.eq((Object)this.getHostname())).and(this.t.LOCK_UNTIL.gt(this.now()))).execute() > 0);
    }

    private Map<? extends TableField<Record, ? extends Serializable>, Serializable> data(LockConfiguration lockConfiguration) {
        return Map.of(this.t.NAME, lockConfiguration.getName(), this.t.LOCK_UNTIL, this.nowPlus(lockConfiguration.getLockAtMostFor()), this.t.LOCKED_AT, this.now(), this.t.LOCKED_BY, this.getHostname());
    }

    private Field<LocalDateTime> now() {
        return DSL.currentLocalDateTime((Field)DSL.inline((int)6));
    }

    private Field<LocalDateTime> nowPlus(Duration duration) {
        return DSL.localDateTimeAdd(this.now(), (Number)DayToSecond.valueOf((Duration)duration));
    }
}

