/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.nats.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.StorageType;
import io.nats.client.support.RandomUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsJetStreamLockProvider
implements LockProvider {
    private static final Logger logger = LoggerFactory.getLogger(NatsJetStreamLockProvider.class);
    private static final String BUCKET_NAME = "shedlock-locks";
    private static final int WRONG_LAST_SEQUENCE = 10071;
    private final KeyValue kv;

    public NatsJetStreamLockProvider(Connection connection) {
        this(connection, BUCKET_NAME);
    }

    public NatsJetStreamLockProvider(Connection connection, String bucketName) {
        KeyValue kvInit;
        Objects.requireNonNull(connection, "connection can not be null");
        Objects.requireNonNull(bucketName, "bucketName can not be null");
        try {
            kvInit = connection.keyValue(bucketName);
        }
        catch (IOException e) {
            logger.debug("Failed to get bucket '{}'. Trying to create it.", (Object)bucketName, (Object)e);
            try {
                KeyValueConfiguration config = KeyValueConfiguration.builder().name(bucketName).storageType(StorageType.Memory).build();
                connection.keyValueManagement().create(config);
                kvInit = connection.keyValue(bucketName);
            }
            catch (JetStreamApiException | IOException ex) {
                throw new LockException("Failed to create bucket", ex);
            }
        }
        this.kv = kvInit;
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        try {
            KeyValueEntry entry = this.getEntry(lockConfiguration);
            if (entry == null) {
                return this.createLock(lockConfiguration);
            }
            Instant lockUntil = NatsJetStreamLockProvider.getLockUntil(entry.getValue());
            if (lockUntil.isAfter(ClockProvider.now())) {
                return Optional.empty();
            }
            return this.updateLock(lockConfiguration, entry.getRevision());
        }
        catch (JetStreamApiException | IOException e) {
            throw new LockException("Failed to get lock", e);
        }
    }

    private Optional<SimpleLock> createLock(LockConfiguration lockConfiguration) {
        Instant lockUntil = lockConfiguration.getLockAtMostUntil();
        byte[] value = NatsJetStreamLockProvider.toBytes(lockUntil);
        try {
            this.kv.create(lockConfiguration.getName(), value);
            return Optional.of(new NatsJetStreamLock(this, lockConfiguration));
        }
        catch (JetStreamApiException e) {
            if (NatsJetStreamLockProvider.isConflict(e)) {
                return Optional.empty();
            }
            throw new LockException("Failed to create lock", (Throwable)e);
        }
        catch (IOException e) {
            throw new LockException("Failed to create lock", (Throwable)e);
        }
    }

    private static boolean isConflict(JetStreamApiException e) {
        return e.getApiErrorCode() == 10071;
    }

    private Optional<SimpleLock> updateLock(LockConfiguration lockConfiguration, long revision) {
        Instant lockUntil = lockConfiguration.getLockAtMostUntil();
        byte[] value = NatsJetStreamLockProvider.toBytes(lockUntil);
        try {
            this.kv.update(lockConfiguration.getName(), value, revision);
            return Optional.of(new NatsJetStreamLock(this, lockConfiguration));
        }
        catch (JetStreamApiException e) {
            if (NatsJetStreamLockProvider.isConflict(e)) {
                return Optional.empty();
            }
            throw new LockException("Failed to update lock", (Throwable)e);
        }
        catch (IOException e) {
            throw new LockException("Failed to update lock", (Throwable)e);
        }
    }

    private static byte[] toBytes(Instant lockUntil) {
        return NatsJetStreamLockProvider.longToBytes(lockUntil.toEpochMilli());
    }

    private static Instant getLockUntil(byte[] value) {
        return Instant.ofEpochMilli(RandomUtils.bytesToLong((byte[])value));
    }

    private void unlock(LockConfiguration lockConfiguration) {
        Instant lockAtLeastUntil = lockConfiguration.getLockAtLeastUntil();
        Instant now = ClockProvider.now();
        try {
            Instant lockAtMostUntil;
            KeyValueEntry entry = this.getEntry(lockConfiguration);
            if (entry == null) {
                return;
            }
            Instant lockUntil = NatsJetStreamLockProvider.getLockUntil(entry.getValue());
            if (lockUntil.isAfter(lockAtMostUntil = lockConfiguration.getLockAtMostUntil())) {
                return;
            }
            if (lockAtLeastUntil.isAfter(now)) {
                byte[] value = NatsJetStreamLockProvider.toBytes(lockAtLeastUntil);
                this.kv.update(lockConfiguration.getName(), value, entry.getRevision());
                return;
            }
            this.kv.delete(lockConfiguration.getName());
        }
        catch (JetStreamApiException | IOException e) {
            throw new LockException("Failed to unlock", e);
        }
    }

    private @Nullable KeyValueEntry getEntry(LockConfiguration lockConfiguration) throws IOException, JetStreamApiException {
        return this.kv.get(lockConfiguration.getName());
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    private static final class NatsJetStreamLock
    extends AbstractSimpleLock {
        private final NatsJetStreamLockProvider lockProvider;

        private NatsJetStreamLock(NatsJetStreamLockProvider lockProvider, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.lockProvider = lockProvider;
        }

        public void doUnlock() {
            this.lockProvider.unlock(this.lockConfiguration);
        }
    }
}

