/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc;

import java.sql.Connection;
import java.util.Objects;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbc.JdbcStorageAccessor;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLockProvider
extends StorageBasedLockProvider {
    public JdbcLockProvider(DataSource datasource) {
        this(datasource, "shedlock");
    }

    public JdbcLockProvider(DataSource datasource, String tableName) {
        this(((Configuration.Builder)new Configuration.Builder(datasource).withTableName(tableName)).build());
    }

    public JdbcLockProvider(Configuration configuration) {
        super((StorageAccessor)new JdbcStorageAccessor(configuration));
    }

    public static final class Configuration
    extends SqlConfiguration {
        private final DataSource dataSource;
        private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

        Configuration(DataSource dataSource, boolean dbUpperCase, @Nullable DatabaseProduct databaseProduct, String tableName, boolean forceUtcTimeZone, SqlConfiguration.ColumnNames columnNames, String lockedByValue, boolean useDbTime) {
            super(databaseProduct, dbUpperCase, tableName, forceUtcTimeZone ? TimeZone.getTimeZone("UTC") : null, columnNames, lockedByValue, useDbTime);
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource can not be null");
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public DatabaseProduct getDatabaseProduct() {
            DatabaseProduct databaseProduct;
            block9: {
                if (super.getDatabaseProduct() != null) {
                    return super.getDatabaseProduct();
                }
                Connection connection = this.dataSource.getConnection();
                try {
                    String jdbcProductName = connection.getMetaData().getDatabaseProductName();
                    databaseProduct = DatabaseProduct.matchProductName((String)jdbcProductName);
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.debug("Can not determine database product name {}", (Object)e.getMessage());
                        return DatabaseProduct.UNKNOWN;
                    }
                }
                connection.close();
            }
            return databaseProduct;
        }

        public static Builder builder(DataSource dataSource) {
            return new Builder(dataSource);
        }

        public static final class Builder
        extends SqlConfiguration.SqlConfigurationBuilder<Builder> {
            private final DataSource dataSource;
            private boolean forceUtcTimeZone;

            public Builder(DataSource dataSource) {
                this.dataSource = dataSource;
            }

            public Configuration build() {
                return new Configuration(this.dataSource, this.dbUpperCase, this.databaseProduct, this.tableName, this.forceUtcTimeZone, this.columnNames, this.lockedByValue, this.useDbTime);
            }

            public Builder forceUtcTimeZone() {
                this.forceUtcTimeZone = true;
                return this;
            }
        }
    }
}

