/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class JdbcStorageAccessor
extends AbstractJdbcStorageAccessor {
    private final DataSource dataSource;

    JdbcStorageAccessor(@NonNull DataSource dataSource, @NonNull String tableName) {
        super(tableName);
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource can not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected <T> T executeCommand(String sql, AbstractJdbcStorageAccessor.SqlFunction<PreparedStatement, T> body, BiFunction<String, SQLException, T> exceptionHandler) {
        try (Connection connection = this.dataSource.getConnection();){
            Object object;
            PreparedStatement statement;
            boolean originalAutocommit;
            block25: {
                block24: {
                    originalAutocommit = connection.getAutoCommit();
                    if (!originalAutocommit) {
                        connection.setAutoCommit(true);
                    }
                    statement = connection.prepareStatement(sql);
                    object = body.apply((Object)statement);
                    if (statement == null) break block24;
                    statement.close();
                }
                if (originalAutocommit) break block25;
                connection.setAutoCommit(false);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            String string = exceptionHandler.apply(sql, e);
                            if (!originalAutocommit) {
                                connection.setAutoCommit(false);
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            return (T)string;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (!originalAutocommit) {
                            connection.setAutoCommit(false);
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (SQLException e) {
            return (T)exceptionHandler.apply(sql, e);
        }
    }
}

